/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hertzbeat.common.config.CommonProperties;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.serialize.AlertDeserializer;
import org.apache.hertzbeat.common.serialize.AlertSerializer;
import org.apache.hertzbeat.common.serialize.KafkaMetricsDataDeserializer;
import org.apache.hertzbeat.common.serialize.KafkaMetricsDataSerializer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="kafka")
public class KafkaCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(KafkaCommonDataQueue.class);
    private final ReentrantLock alertLock = new ReentrantLock();
    private final ReentrantLock metricDataToAlertLock = new ReentrantLock();
    private final ReentrantLock metricDataToPersistentLock = new ReentrantLock();
    private final ReentrantLock metricDataToRealTimeStorageLock = new ReentrantLock();
    private final LinkedBlockingQueue<Alert> alertDataQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToAlertQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToPersistentStorageQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToRealTimeStorageQueue;
    private final CommonProperties.KafkaProperties kafka;
    private KafkaProducer<Long, CollectRep.MetricsData> metricsDataProducer;
    private KafkaProducer<Long, Alert> alertDataProducer;
    private KafkaConsumer<Long, Alert> alertDataConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToAlertConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToPersistentStorageConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToRealTimeStorageConsumer;

    public KafkaCommonDataQueue(CommonProperties properties) {
        if (properties == null || properties.getQueue() == null || properties.getQueue().getKafka() == null) {
            log.error("init error, please config common.queue.kafka props in application.yml");
            throw new IllegalArgumentException("please config common.queue.kafka props");
        }
        this.kafka = properties.getQueue().getKafka();
        this.alertDataQueue = new LinkedBlockingQueue();
        this.metricsDataToAlertQueue = new LinkedBlockingQueue();
        this.metricsDataToPersistentStorageQueue = new LinkedBlockingQueue();
        this.metricsDataToRealTimeStorageQueue = new LinkedBlockingQueue();
        this.initDataQueue();
    }

    private void initDataQueue() {
        try {
            HashMap<String, Object> producerConfig = new HashMap<String, Object>(3);
            producerConfig.put("bootstrap.servers", this.kafka.getServers());
            producerConfig.put("acks", "all");
            producerConfig.put("retries", 3);
            this.metricsDataProducer = new KafkaProducer(producerConfig, (Serializer)new LongSerializer(), (Serializer)new KafkaMetricsDataSerializer());
            this.alertDataProducer = new KafkaProducer(producerConfig, (Serializer)new LongSerializer(), (Serializer)new AlertSerializer());
            HashMap<String, Object> consumerConfig = new HashMap<String, Object>(4);
            consumerConfig.put("bootstrap.servers", this.kafka.getServers());
            consumerConfig.put("max.poll.records", "50");
            consumerConfig.put("enable.auto.commit", false);
            consumerConfig.put("max.poll.interval.ms", "900000");
            consumerConfig.put("group.id", "default-consumer");
            HashMap<String, String> alertConsumerConfig = new HashMap<String, String>(consumerConfig);
            alertConsumerConfig.put("group.id", "alert-consumer");
            this.alertDataConsumer = new KafkaConsumer(alertConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new AlertDeserializer());
            this.alertDataConsumer.subscribe(Collections.singletonList(this.kafka.getAlertsDataTopic()));
            HashMap<String, String> metricsToAlertConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToAlertConsumerConfig.put("group.id", "metrics-alert-consumer");
            this.metricsDataToAlertConsumer = new KafkaConsumer(metricsToAlertConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToAlertConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataTopic()));
            HashMap<String, String> metricsToPersistentConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToPersistentConsumerConfig.put("group.id", "metrics-persistent-consumer");
            this.metricsDataToPersistentStorageConsumer = new KafkaConsumer(metricsToPersistentConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToPersistentStorageConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataTopic()));
            HashMap<String, String> metricsToRealTimeConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToRealTimeConsumerConfig.put("group.id", "metrics-memory-consumer");
            this.metricsDataToRealTimeStorageConsumer = new KafkaConsumer(metricsToRealTimeConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToRealTimeStorageConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataTopic()));
        }
        catch (Exception e) {
            log.error("please config common.queue.kafka props correctly", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void sendAlertsData(Alert alert) {
        if (this.alertDataProducer != null) {
            this.alertDataProducer.send(new ProducerRecord(this.kafka.getAlertsDataTopic(), (Object)alert));
        } else {
            log.error("kafkaAlertProducer is not enable");
        }
    }

    @Override
    public Alert pollAlertsData() throws InterruptedException {
        return this.genericPollDataFunction(this.alertDataQueue, this.alertDataConsumer, this.alertLock);
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() throws InterruptedException {
        return this.genericPollDataFunction(this.metricsDataToAlertQueue, this.metricsDataToAlertConsumer, this.metricDataToAlertLock);
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToPersistentStorage() throws InterruptedException {
        return this.genericPollDataFunction(this.metricsDataToPersistentStorageQueue, this.metricsDataToPersistentStorageConsumer, this.metricDataToPersistentLock);
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToRealTimeStorage() throws InterruptedException {
        return this.genericPollDataFunction(this.metricsDataToRealTimeStorageQueue, this.metricsDataToRealTimeStorageConsumer, this.metricDataToRealTimeStorageLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T genericPollDataFunction(LinkedBlockingQueue<T> dataQueue, KafkaConsumer<Long, T> dataConsumer, ReentrantLock lock) throws InterruptedException {
        Object pollData = dataQueue.poll();
        if (pollData != null) {
            return pollData;
        }
        lock.lockInterruptibly();
        try {
            ConsumerRecords records = dataConsumer.poll(Duration.ofSeconds(1L));
            int index = 0;
            for (ConsumerRecord record : records) {
                if (index == 0) {
                    pollData = record.value();
                } else {
                    dataQueue.offer(record.value());
                }
                ++index;
            }
            dataConsumer.commitAsync();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            lock.unlock();
        }
        return pollData;
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        if (this.metricsDataProducer != null) {
            this.metricsDataProducer.send(new ProducerRecord(this.kafka.getMetricsDataTopic(), (Object)metricsData));
        } else {
            log.error("metricsDataProducer is not enabled");
        }
    }

    public void destroy() throws Exception {
        if (this.metricsDataProducer != null) {
            this.metricsDataProducer.close();
        }
        if (this.alertDataProducer != null) {
            this.alertDataProducer.close();
        }
        if (this.alertDataConsumer != null) {
            this.alertDataConsumer.close();
        }
        if (this.metricsDataToAlertConsumer != null) {
            this.metricsDataToAlertConsumer.close();
        }
        if (this.metricsDataToPersistentStorageConsumer != null) {
            this.metricsDataToPersistentStorageConsumer.close();
        }
        if (this.metricsDataToRealTimeStorageConsumer != null) {
            this.metricsDataToRealTimeStorageConsumer.close();
        }
    }
}

