/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_notice_receiver")
@Schema(description="Message notification recipient entity")
@EntityListeners(value={AuditingEntityListener.class})
public class NoticeReceiver {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Recipient entity primary key index ID", description="Recipient entity primary key index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Recipient name", description="Recipient name", example="tom", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    @NotBlank(message="name can not null")
    private @Size(max=100) @NotBlank(message="name can not null") String name;
    @Schema(title="Notification information method: 0-SMS 1-Email 2-webhook 3-WeChat Official Account 4-Enterprise WeChat Robot 5-DingTalk Robot 6-FeiShu Robot 7-Telegram Bot 8-SlackWebHook 9-Discord Bot 10-Enterprise WeChat app message", description="Notification information method: 0-SMS 1-Email 2-webhook 3-WeChat Official Account 4-Enterprise WeChat Robot 5-DingTalk Robot 6-FeiShu Robot 7-Telegram Bot 8-SlackWebHook 9-Discord Bot 10-Enterprise WeChat app message", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    @NotNull(message="type can not null")
    private @Min(value=0L) @NotNull(message="type can not null") Byte type;
    @Schema(title="Mobile number: Valid when the notification method is SMS", description="Mobile number: Valid when the notification method is SMS", example="18923435643", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    private @Size(max=100) String phone;
    @Schema(title="Email account: Valid when the notification method is email", description="Email account: Valid when the notification method is email", example="tom@qq.com", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    private @Size(max=100) String email;
    @Schema(title="URL address: The notification method is valid for webhook", description="URL address: The notification method is valid for webhook", example="https://www.tancloud.cn", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=300)
    @Column(length=300)
    private @Size(max=300) String hookUrl;
    @Schema(title="openId : The notification method is valid for WeChat official account, enterprise WeChat robot or FlyBook robot", description="openId : The notification method is valid for WeChat official account, enterprise WeChat robot or FlyBook robot", example="343432", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=300)
    @Column(length=300)
    private @Size(max=300) String wechatId;
    @Schema(title="Access token : The notification method is valid for DingTalk robot", description="Access token : The notification method is valid for DingTalk robot", example="34823984635647", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=300)
    @Column(length=300)
    private @Size(max=300) String accessToken;
    @Schema(title="Telegram bot token : The notification method is valid for Telegram Bot", description="Telegram bot token : The notification method is valid for Telegram Bot", example="1499012345:AAEOB_wEYS-DZyPM3h5NzI8voJMXXXXXX", accessMode=Schema.AccessMode.READ_WRITE)
    private String tgBotToken;
    @Schema(title="Telegram user id: The notification method is valid for Telegram Bot", description="Telegram user id: The notification method is valid for Telegram Bot", example="779294123", accessMode=Schema.AccessMode.READ_WRITE)
    private String tgUserId;
    @Schema(title="DingTalk,FeiShu,WeWork user id: The notification method is valid for DingTalk,FeiShu,WeWork Bot", description="DingTalk,FeiShu,WeWork user id: The notification method is valid for DingTalk,FeiShu,WeWork Bot", example="779294123", accessMode=Schema.AccessMode.READ_WRITE)
    private String userId;
    @Schema(title="URL address: The notification method is valid for Slack", description="URL address: The notification method is valid for Slack", example="https://hooks.slack.com/services/XXXX/XXXX/XXXX", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=300)
    @Column(length=300)
    private @Size(max=300) String slackWebHookUrl;
    @Schema(title="Enterprise weChat message: The notification method is valid for Enterprise WeChat app message", description="Enterprise weChat message: The notification method is valid for Enterprise WeChat app message", example="ww1a603432123d0dc1", accessMode=Schema.AccessMode.READ_WRITE)
    private String corpId;
    @Schema(title="Enterprise weChat appId: The notification method is valid for Enterprise WeChat app message", description="Enterprise weChat appId: The notification method is valid for Enterprise WeChat app message", example="1000001", accessMode=Schema.AccessMode.READ_WRITE)
    private Integer agentId;
    @Schema(title="Enterprise weChat secret: The notification method is valid for Enterprise WeChat app message", description="Enterprise weChat secret: The notification method is valid for Enterprise WeChat app message", example="oUydwn92ey0lnuY02MixNa57eNK-20dJn5NEOG-u2uE", accessMode=Schema.AccessMode.READ_WRITE)
    private String appSecret;
    @Schema(title="Enterprise weChat party id: The notification method is valid for Enterprise WeChat app message", description="Enterprise weChat party id: The notification method is valid for Enterprise WeChat app message", example="779294123", accessMode=Schema.AccessMode.READ_WRITE)
    private String partyId;
    @Schema(title="Enterprise weChat tag id: The notification method is valid for Enterprise WeChat app message", description="Enterprise weChat tag id: The notification method is valid for Enterprise WeChat app message", example="779294123", accessMode=Schema.AccessMode.READ_WRITE)
    private String tagId;
    @Schema(title="Discord channel id: The notification method is valid for Discord", description="Discord channel id: The notification method is valid for Discord", example="1065303416030642266", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=300)
    @Column(length=300)
    private @Size(max=300) String discordChannelId;
    @Schema(title="Discord bot token: The notification method is valid for Discord", description="Discord bot token: The notification method is valid for Discord", example="MTA2NTMwMzU0ODY4Mzg4MjUzNw.xxxxx.xxxxxxx", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=300)
    @Column(length=300)
    private @Size(max=300) String discordBotToken;
    @Schema(title="huawei cloud SMN ak: If the notification method is valid for huawei cloud SMN", description="huawei cloud SMN ak: If the notification method is valid for huawei cloud SMN", example="NCVBODJOEYHSW3VNXXXX", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=22)
    @Column(length=22)
    private @Size(max=22) String smnAk;
    @Schema(title="huawei cloud SMN sk: If the notification method is valid for huawei cloud SMN", description="huawei cloud SMN sk: If the notification method is valid for huawei cloud SMN", example="nmSNhUJN9MlpPl8lfCsgdA0KvHCL9JXXXX", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=42)
    @Column(length=42)
    private @Size(max=42) String smnSk;
    @Schema(title="huawei cloud SMN projectId: If the notification method is valid for huawei cloud SMN", description="huawei cloud SMN projectId: If the notification method is valid for huawei cloud SMN", example="320c2fb11edb47a481c299c1XXXXXX", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=32)
    @Column(length=32)
    private @Size(max=32) String smnProjectId;
    @Schema(title="huawei cloud SMN region: If the notification method is valid for huawei cloud SMN", description="huawei cloud SMN region: If the notification method is valid for huawei cloud SMN", example="cn-east-3", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=32)
    @Column(length=32)
    private @Size(max=32) String smnRegion;
    @Schema(title="huawei cloud SMN TopicUrn: If the notification method is valid for huawei cloud SMN", description="huawei cloud SMN TopicUrn: If the notification method is valid for huawei cloud SMN", example="urn:smn:cn-east-3:xxx:hertzbeat_test", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=300)
    @Column(length=300)
    private @Size(max=300) String smnTopicUrn;
    @Schema(title="serverChanToken : The notification method is valid for ServerChan", description="serverChanToken : The notification method is valid for ServerChan", example="SCT193569TSNm6xIabdjqeZPtOGOWcvU1e", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=300)
    @Column(length=300)
    private @Size(max=300) String serverChanToken;
    @Schema(title="Gotify token : The notification method is valid for Gotify", description="Gotify token : The notification method is valid for Gotify", example="A845h__ZMqDxZlO", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=300)
    @Column(length=300)
    private @Size(max=300) String gotifyToken;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record creation time (millisecond timestamp)", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)", example="1612198444000", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static NoticeReceiverBuilder builder() {
        return new NoticeReceiverBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Byte getType() {
        return this.type;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getHookUrl() {
        return this.hookUrl;
    }

    public String getWechatId() {
        return this.wechatId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTgBotToken() {
        return this.tgBotToken;
    }

    public String getTgUserId() {
        return this.tgUserId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSlackWebHookUrl() {
        return this.slackWebHookUrl;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public String getTagId() {
        return this.tagId;
    }

    public String getDiscordChannelId() {
        return this.discordChannelId;
    }

    public String getDiscordBotToken() {
        return this.discordBotToken;
    }

    public String getSmnAk() {
        return this.smnAk;
    }

    public String getSmnSk() {
        return this.smnSk;
    }

    public String getSmnProjectId() {
        return this.smnProjectId;
    }

    public String getSmnRegion() {
        return this.smnRegion;
    }

    public String getSmnTopicUrn() {
        return this.smnTopicUrn;
    }

    public String getServerChanToken() {
        return this.serverChanToken;
    }

    public String getGotifyToken() {
        return this.gotifyToken;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setHookUrl(String hookUrl) {
        this.hookUrl = hookUrl;
    }

    public void setWechatId(String wechatId) {
        this.wechatId = wechatId;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTgBotToken(String tgBotToken) {
        this.tgBotToken = tgBotToken;
    }

    public void setTgUserId(String tgUserId) {
        this.tgUserId = tgUserId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setSlackWebHookUrl(String slackWebHookUrl) {
        this.slackWebHookUrl = slackWebHookUrl;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public void setDiscordChannelId(String discordChannelId) {
        this.discordChannelId = discordChannelId;
    }

    public void setDiscordBotToken(String discordBotToken) {
        this.discordBotToken = discordBotToken;
    }

    public void setSmnAk(String smnAk) {
        this.smnAk = smnAk;
    }

    public void setSmnSk(String smnSk) {
        this.smnSk = smnSk;
    }

    public void setSmnProjectId(String smnProjectId) {
        this.smnProjectId = smnProjectId;
    }

    public void setSmnRegion(String smnRegion) {
        this.smnRegion = smnRegion;
    }

    public void setSmnTopicUrn(String smnTopicUrn) {
        this.smnTopicUrn = smnTopicUrn;
    }

    public void setServerChanToken(String serverChanToken) {
        this.serverChanToken = serverChanToken;
    }

    public void setGotifyToken(String gotifyToken) {
        this.gotifyToken = gotifyToken;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoticeReceiver)) {
            return false;
        }
        NoticeReceiver other = (NoticeReceiver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Byte this$type = this.getType();
        Byte other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$hookUrl = this.getHookUrl();
        String other$hookUrl = other.getHookUrl();
        if (this$hookUrl == null ? other$hookUrl != null : !this$hookUrl.equals(other$hookUrl)) {
            return false;
        }
        String this$wechatId = this.getWechatId();
        String other$wechatId = other.getWechatId();
        if (this$wechatId == null ? other$wechatId != null : !this$wechatId.equals(other$wechatId)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$tgBotToken = this.getTgBotToken();
        String other$tgBotToken = other.getTgBotToken();
        if (this$tgBotToken == null ? other$tgBotToken != null : !this$tgBotToken.equals(other$tgBotToken)) {
            return false;
        }
        String this$tgUserId = this.getTgUserId();
        String other$tgUserId = other.getTgUserId();
        if (this$tgUserId == null ? other$tgUserId != null : !this$tgUserId.equals(other$tgUserId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$slackWebHookUrl = this.getSlackWebHookUrl();
        String other$slackWebHookUrl = other.getSlackWebHookUrl();
        if (this$slackWebHookUrl == null ? other$slackWebHookUrl != null : !this$slackWebHookUrl.equals(other$slackWebHookUrl)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        if (this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId)) {
            return false;
        }
        String this$appSecret = this.getAppSecret();
        String other$appSecret = other.getAppSecret();
        if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
            return false;
        }
        String this$partyId = this.getPartyId();
        String other$partyId = other.getPartyId();
        if (this$partyId == null ? other$partyId != null : !this$partyId.equals(other$partyId)) {
            return false;
        }
        String this$tagId = this.getTagId();
        String other$tagId = other.getTagId();
        if (this$tagId == null ? other$tagId != null : !this$tagId.equals(other$tagId)) {
            return false;
        }
        String this$discordChannelId = this.getDiscordChannelId();
        String other$discordChannelId = other.getDiscordChannelId();
        if (this$discordChannelId == null ? other$discordChannelId != null : !this$discordChannelId.equals(other$discordChannelId)) {
            return false;
        }
        String this$discordBotToken = this.getDiscordBotToken();
        String other$discordBotToken = other.getDiscordBotToken();
        if (this$discordBotToken == null ? other$discordBotToken != null : !this$discordBotToken.equals(other$discordBotToken)) {
            return false;
        }
        String this$smnAk = this.getSmnAk();
        String other$smnAk = other.getSmnAk();
        if (this$smnAk == null ? other$smnAk != null : !this$smnAk.equals(other$smnAk)) {
            return false;
        }
        String this$smnSk = this.getSmnSk();
        String other$smnSk = other.getSmnSk();
        if (this$smnSk == null ? other$smnSk != null : !this$smnSk.equals(other$smnSk)) {
            return false;
        }
        String this$smnProjectId = this.getSmnProjectId();
        String other$smnProjectId = other.getSmnProjectId();
        if (this$smnProjectId == null ? other$smnProjectId != null : !this$smnProjectId.equals(other$smnProjectId)) {
            return false;
        }
        String this$smnRegion = this.getSmnRegion();
        String other$smnRegion = other.getSmnRegion();
        if (this$smnRegion == null ? other$smnRegion != null : !this$smnRegion.equals(other$smnRegion)) {
            return false;
        }
        String this$smnTopicUrn = this.getSmnTopicUrn();
        String other$smnTopicUrn = other.getSmnTopicUrn();
        if (this$smnTopicUrn == null ? other$smnTopicUrn != null : !this$smnTopicUrn.equals(other$smnTopicUrn)) {
            return false;
        }
        String this$serverChanToken = this.getServerChanToken();
        String other$serverChanToken = other.getServerChanToken();
        if (this$serverChanToken == null ? other$serverChanToken != null : !this$serverChanToken.equals(other$serverChanToken)) {
            return false;
        }
        String this$gotifyToken = this.getGotifyToken();
        String other$gotifyToken = other.getGotifyToken();
        if (this$gotifyToken == null ? other$gotifyToken != null : !this$gotifyToken.equals(other$gotifyToken)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NoticeReceiver;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Byte $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $hookUrl = this.getHookUrl();
        result = result * 59 + ($hookUrl == null ? 43 : $hookUrl.hashCode());
        String $wechatId = this.getWechatId();
        result = result * 59 + ($wechatId == null ? 43 : $wechatId.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $tgBotToken = this.getTgBotToken();
        result = result * 59 + ($tgBotToken == null ? 43 : $tgBotToken.hashCode());
        String $tgUserId = this.getTgUserId();
        result = result * 59 + ($tgUserId == null ? 43 : $tgUserId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $slackWebHookUrl = this.getSlackWebHookUrl();
        result = result * 59 + ($slackWebHookUrl == null ? 43 : $slackWebHookUrl.hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        String $appSecret = this.getAppSecret();
        result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
        String $partyId = this.getPartyId();
        result = result * 59 + ($partyId == null ? 43 : $partyId.hashCode());
        String $tagId = this.getTagId();
        result = result * 59 + ($tagId == null ? 43 : $tagId.hashCode());
        String $discordChannelId = this.getDiscordChannelId();
        result = result * 59 + ($discordChannelId == null ? 43 : $discordChannelId.hashCode());
        String $discordBotToken = this.getDiscordBotToken();
        result = result * 59 + ($discordBotToken == null ? 43 : $discordBotToken.hashCode());
        String $smnAk = this.getSmnAk();
        result = result * 59 + ($smnAk == null ? 43 : $smnAk.hashCode());
        String $smnSk = this.getSmnSk();
        result = result * 59 + ($smnSk == null ? 43 : $smnSk.hashCode());
        String $smnProjectId = this.getSmnProjectId();
        result = result * 59 + ($smnProjectId == null ? 43 : $smnProjectId.hashCode());
        String $smnRegion = this.getSmnRegion();
        result = result * 59 + ($smnRegion == null ? 43 : $smnRegion.hashCode());
        String $smnTopicUrn = this.getSmnTopicUrn();
        result = result * 59 + ($smnTopicUrn == null ? 43 : $smnTopicUrn.hashCode());
        String $serverChanToken = this.getServerChanToken();
        result = result * 59 + ($serverChanToken == null ? 43 : $serverChanToken.hashCode());
        String $gotifyToken = this.getGotifyToken();
        result = result * 59 + ($gotifyToken == null ? 43 : $gotifyToken.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "NoticeReceiver(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", phone=" + this.getPhone() + ", email=" + this.getEmail() + ", hookUrl=" + this.getHookUrl() + ", wechatId=" + this.getWechatId() + ", accessToken=" + this.getAccessToken() + ", tgBotToken=" + this.getTgBotToken() + ", tgUserId=" + this.getTgUserId() + ", userId=" + this.getUserId() + ", slackWebHookUrl=" + this.getSlackWebHookUrl() + ", corpId=" + this.getCorpId() + ", agentId=" + this.getAgentId() + ", appSecret=" + this.getAppSecret() + ", partyId=" + this.getPartyId() + ", tagId=" + this.getTagId() + ", discordChannelId=" + this.getDiscordChannelId() + ", discordBotToken=" + this.getDiscordBotToken() + ", smnAk=" + this.getSmnAk() + ", smnSk=" + this.getSmnSk() + ", smnProjectId=" + this.getSmnProjectId() + ", smnRegion=" + this.getSmnRegion() + ", smnTopicUrn=" + this.getSmnTopicUrn() + ", serverChanToken=" + this.getServerChanToken() + ", gotifyToken=" + this.getGotifyToken() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public NoticeReceiver(Long id, String name, Byte type, String phone, String email, String hookUrl, String wechatId, String accessToken, String tgBotToken, String tgUserId, String userId, String slackWebHookUrl, String corpId, Integer agentId, String appSecret, String partyId, String tagId, String discordChannelId, String discordBotToken, String smnAk, String smnSk, String smnProjectId, String smnRegion, String smnTopicUrn, String serverChanToken, String gotifyToken, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.phone = phone;
        this.email = email;
        this.hookUrl = hookUrl;
        this.wechatId = wechatId;
        this.accessToken = accessToken;
        this.tgBotToken = tgBotToken;
        this.tgUserId = tgUserId;
        this.userId = userId;
        this.slackWebHookUrl = slackWebHookUrl;
        this.corpId = corpId;
        this.agentId = agentId;
        this.appSecret = appSecret;
        this.partyId = partyId;
        this.tagId = tagId;
        this.discordChannelId = discordChannelId;
        this.discordBotToken = discordBotToken;
        this.smnAk = smnAk;
        this.smnSk = smnSk;
        this.smnProjectId = smnProjectId;
        this.smnRegion = smnRegion;
        this.smnTopicUrn = smnTopicUrn;
        this.serverChanToken = serverChanToken;
        this.gotifyToken = gotifyToken;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public NoticeReceiver() {
    }

    public static class NoticeReceiverBuilder {
        private Long id;
        private String name;
        private Byte type;
        private String phone;
        private String email;
        private String hookUrl;
        private String wechatId;
        private String accessToken;
        private String tgBotToken;
        private String tgUserId;
        private String userId;
        private String slackWebHookUrl;
        private String corpId;
        private Integer agentId;
        private String appSecret;
        private String partyId;
        private String tagId;
        private String discordChannelId;
        private String discordBotToken;
        private String smnAk;
        private String smnSk;
        private String smnProjectId;
        private String smnRegion;
        private String smnTopicUrn;
        private String serverChanToken;
        private String gotifyToken;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        NoticeReceiverBuilder() {
        }

        public NoticeReceiverBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public NoticeReceiverBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NoticeReceiverBuilder type(Byte type) {
            this.type = type;
            return this;
        }

        public NoticeReceiverBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public NoticeReceiverBuilder email(String email) {
            this.email = email;
            return this;
        }

        public NoticeReceiverBuilder hookUrl(String hookUrl) {
            this.hookUrl = hookUrl;
            return this;
        }

        public NoticeReceiverBuilder wechatId(String wechatId) {
            this.wechatId = wechatId;
            return this;
        }

        public NoticeReceiverBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public NoticeReceiverBuilder tgBotToken(String tgBotToken) {
            this.tgBotToken = tgBotToken;
            return this;
        }

        public NoticeReceiverBuilder tgUserId(String tgUserId) {
            this.tgUserId = tgUserId;
            return this;
        }

        public NoticeReceiverBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public NoticeReceiverBuilder slackWebHookUrl(String slackWebHookUrl) {
            this.slackWebHookUrl = slackWebHookUrl;
            return this;
        }

        public NoticeReceiverBuilder corpId(String corpId) {
            this.corpId = corpId;
            return this;
        }

        public NoticeReceiverBuilder agentId(Integer agentId) {
            this.agentId = agentId;
            return this;
        }

        public NoticeReceiverBuilder appSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public NoticeReceiverBuilder partyId(String partyId) {
            this.partyId = partyId;
            return this;
        }

        public NoticeReceiverBuilder tagId(String tagId) {
            this.tagId = tagId;
            return this;
        }

        public NoticeReceiverBuilder discordChannelId(String discordChannelId) {
            this.discordChannelId = discordChannelId;
            return this;
        }

        public NoticeReceiverBuilder discordBotToken(String discordBotToken) {
            this.discordBotToken = discordBotToken;
            return this;
        }

        public NoticeReceiverBuilder smnAk(String smnAk) {
            this.smnAk = smnAk;
            return this;
        }

        public NoticeReceiverBuilder smnSk(String smnSk) {
            this.smnSk = smnSk;
            return this;
        }

        public NoticeReceiverBuilder smnProjectId(String smnProjectId) {
            this.smnProjectId = smnProjectId;
            return this;
        }

        public NoticeReceiverBuilder smnRegion(String smnRegion) {
            this.smnRegion = smnRegion;
            return this;
        }

        public NoticeReceiverBuilder smnTopicUrn(String smnTopicUrn) {
            this.smnTopicUrn = smnTopicUrn;
            return this;
        }

        public NoticeReceiverBuilder serverChanToken(String serverChanToken) {
            this.serverChanToken = serverChanToken;
            return this;
        }

        public NoticeReceiverBuilder gotifyToken(String gotifyToken) {
            this.gotifyToken = gotifyToken;
            return this;
        }

        public NoticeReceiverBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public NoticeReceiverBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public NoticeReceiverBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public NoticeReceiverBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public NoticeReceiver build() {
            return new NoticeReceiver(this.id, this.name, this.type, this.phone, this.email, this.hookUrl, this.wechatId, this.accessToken, this.tgBotToken, this.tgUserId, this.userId, this.slackWebHookUrl, this.corpId, this.agentId, this.appSecret, this.partyId, this.tagId, this.discordChannelId, this.discordBotToken, this.smnAk, this.smnSk, this.smnProjectId, this.smnRegion, this.smnTopicUrn, this.serverChanToken, this.gotifyToken, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "NoticeReceiver.NoticeReceiverBuilder(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", phone=" + this.phone + ", email=" + this.email + ", hookUrl=" + this.hookUrl + ", wechatId=" + this.wechatId + ", accessToken=" + this.accessToken + ", tgBotToken=" + this.tgBotToken + ", tgUserId=" + this.tgUserId + ", userId=" + this.userId + ", slackWebHookUrl=" + this.slackWebHookUrl + ", corpId=" + this.corpId + ", agentId=" + this.agentId + ", appSecret=" + this.appSecret + ", partyId=" + this.partyId + ", tagId=" + this.tagId + ", discordChannelId=" + this.discordChannelId + ", discordBotToken=" + this.discordBotToken + ", smnAk=" + this.smnAk + ", smnSk=" + this.smnSk + ", smnProjectId=" + this.smnProjectId + ", smnRegion=" + this.smnRegion + ", smnTopicUrn=" + this.smnTopicUrn + ", serverChanToken=" + this.serverChanToken + ", gotifyToken=" + this.gotifyToken + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

