/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.kafka;

import java.util.Properties;
import org.apache.hertzbeat.collector.collect.common.cache.AbstractConnection;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;

public class KafkaConnect
extends AbstractConnection<AdminClient> {
    private static AdminClient adminClient;

    public KafkaConnect(String brokerList) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", brokerList);
        properties.put("retries", (Object)3);
        properties.put("retry.backoff.ms", (Object)500);
        adminClient = KafkaAdminClient.create((Properties)properties);
    }

    public AdminClient getConnection() {
        return adminClient;
    }

    public void closeConnection() throws Exception {
        if (adminClient != null) {
            adminClient.close();
        }
    }

    public static synchronized AdminClient getAdminClient(String brokerList) {
        if (adminClient == null) {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", brokerList);
            adminClient = KafkaAdminClient.create((Properties)properties);
        }
        return adminClient;
    }
}

