/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.kafka.KafkaConnect;
import org.apache.hertzbeat.collector.collect.kafka.SupportedCommand;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.KafkaProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class KafkaCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(KafkaCollectImpl.class);

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        KafkaProtocol kafkaProtocol = metrics.getKclient();
        Assert.isTrue((metrics != null && kafkaProtocol != null ? 1 : 0) != 0, (String)"Kafka collect must have kafkaProtocol params");
        Assert.hasText((String)kafkaProtocol.getHost(), (String)"Kafka Protocol host is required.");
        Assert.hasText((String)kafkaProtocol.getPort(), (String)"Kafka Protocol port is required.");
    }

    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        try {
            KafkaProtocol kafkaProtocol = metrics.getKclient();
            String command = kafkaProtocol.getCommand();
            boolean isKafkaCommand = SupportedCommand.isKafkaCommand(command);
            if (!isKafkaCommand) {
                log.error("Unsupported command: {}", (Object)command);
                return;
            }
            AdminClient adminClient = KafkaConnect.getAdminClient(kafkaProtocol.getHost() + ":" + kafkaProtocol.getPort());
            switch (SupportedCommand.fromCommand(command)) {
                case TOPIC_DESCRIBE: {
                    KafkaCollectImpl.collectTopicDescribe(builder, adminClient);
                    break;
                }
                case TOPIC_LIST: {
                    KafkaCollectImpl.collectTopicList(builder, adminClient);
                    break;
                }
                case TOPIC_OFFSET: {
                    this.collectTopicOffset(builder, adminClient);
                    break;
                }
                default: {
                    log.error("Unsupported command: {}", (Object)command);
                    break;
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Kafka collect error", (Throwable)e);
        }
    }

    private void collectTopicOffset(CollectRep.MetricsData.Builder builder, AdminClient adminClient) throws InterruptedException, ExecutionException {
        ListTopicsResult listTopicsResult = adminClient.listTopics(new ListTopicsOptions().listInternal(true));
        Set names = (Set)listTopicsResult.names().get();
        names.forEach(name -> {
            try {
                Map map = (Map)adminClient.describeTopics(Collections.singleton(name)).all().get(3L, TimeUnit.SECONDS);
                map.forEach((key, value) -> value.partitions().forEach(info -> this.extractedOffset(builder, adminClient, (String)name, (TopicDescription)value, (TopicPartitionInfo)info)));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.warn("Topic {} get offset fail", name);
            }
        });
    }

    private void extractedOffset(CollectRep.MetricsData.Builder builder, AdminClient adminClient, String name, TopicDescription value, TopicPartitionInfo info) {
        try {
            TopicPartition topicPartition = new TopicPartition(value.name(), info.partition());
            long earliestOffset = this.getEarliestOffset(adminClient, topicPartition);
            long latestOffset = this.getLatestOffset(adminClient, topicPartition);
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            valueRowBuilder.addColumns(value.name());
            valueRowBuilder.addColumns(String.valueOf(info.partition()));
            valueRowBuilder.addColumns(String.valueOf(earliestOffset));
            valueRowBuilder.addColumns(String.valueOf(latestOffset));
            builder.addValues(valueRowBuilder.build());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.warn("Topic {} get offset fail", (Object)name);
        }
    }

    private long getEarliestOffset(AdminClient adminClient, TopicPartition topicPartition) throws InterruptedException, ExecutionException, TimeoutException {
        return ((ListOffsetsResult.ListOffsetsResultInfo)((Map)adminClient.listOffsets(Collections.singletonMap(topicPartition, OffsetSpec.earliest())).all().get(3L, TimeUnit.SECONDS)).get(topicPartition)).offset();
    }

    private long getLatestOffset(AdminClient adminClient, TopicPartition topicPartition) throws InterruptedException, ExecutionException, TimeoutException {
        return ((ListOffsetsResult.ListOffsetsResultInfo)((Map)adminClient.listOffsets(Collections.singletonMap(topicPartition, OffsetSpec.latest())).all().get(3L, TimeUnit.SECONDS)).get(topicPartition)).offset();
    }

    private static void collectTopicList(CollectRep.MetricsData.Builder builder, AdminClient adminClient) throws InterruptedException, ExecutionException {
        ListTopicsOptions options = new ListTopicsOptions().listInternal(true);
        Set names = (Set)adminClient.listTopics(options).names().get();
        names.forEach(name -> {
            CollectRep.ValueRow valueRow = CollectRep.ValueRow.newBuilder().addColumns(name).build();
            builder.addValues(valueRow);
        });
    }

    private static void collectTopicDescribe(CollectRep.MetricsData.Builder builder, AdminClient adminClient) throws InterruptedException, ExecutionException {
        ListTopicsOptions options = new ListTopicsOptions();
        options.listInternal(true);
        ListTopicsResult listTopicsResult = adminClient.listTopics(options);
        Set names = (Set)listTopicsResult.names().get();
        DescribeTopicsResult describeTopicsResult = adminClient.describeTopics((Collection)names);
        Map map = (Map)describeTopicsResult.all().get();
        map.forEach((key, value) -> {
            List listp = value.partitions();
            listp.forEach(info -> {
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                valueRowBuilder.addColumns(value.name());
                valueRowBuilder.addColumns(String.valueOf(value.partitions().size()));
                valueRowBuilder.addColumns(String.valueOf(info.partition()));
                valueRowBuilder.addColumns(info.leader().host());
                valueRowBuilder.addColumns(String.valueOf(info.leader().port()));
                valueRowBuilder.addColumns(String.valueOf(info.replicas().size()));
                valueRowBuilder.addColumns(String.valueOf(info.replicas()));
                builder.addValues(valueRowBuilder.build());
            });
        });
    }

    public String supportProtocol() {
        return "kclient";
    }
}

