/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.prometheus.PrometheusAutoCollectImpl;
import org.apache.hertzbeat.collector.collect.strategy.CollectStrategyFactory;
import org.apache.hertzbeat.collector.dispatch.CollectDataDispatch;
import org.apache.hertzbeat.collector.dispatch.timer.Timeout;
import org.apache.hertzbeat.collector.dispatch.timer.WheelTimerTask;
import org.apache.hertzbeat.collector.dispatch.unit.UnitConvert;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.JexlExpressionRunner;
import org.apache.hertzbeat.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollect
implements Runnable,
Comparable<MetricsCollect> {
    private static final Logger log = LoggerFactory.getLogger(MetricsCollect.class);
    private static final long WARN_DISPATCH_TIME = 100L;
    protected String collectorIdentity;
    protected long tenantId;
    protected long monitorId;
    protected String app;
    protected Metrics metrics;
    protected Timeout timeout;
    protected CollectDataDispatch collectDataDispatch;
    protected byte runPriority;
    protected boolean isCyclic;
    protected long newTime = System.currentTimeMillis();
    protected long startTime;
    protected List<UnitConvert> unitConvertList;

    public MetricsCollect(Metrics metrics, Timeout timeout, CollectDataDispatch collectDataDispatch, String collectorIdentity, List<UnitConvert> unitConvertList) {
        this.timeout = timeout;
        this.metrics = metrics;
        this.collectorIdentity = collectorIdentity;
        WheelTimerTask timerJob = (WheelTimerTask)timeout.task();
        Job job = timerJob.getJob();
        this.monitorId = job.getMonitorId();
        this.tenantId = job.getTenantId();
        this.app = job.getApp();
        this.collectDataDispatch = collectDataDispatch;
        this.isCyclic = job.isCyclic();
        this.unitConvertList = unitConvertList;
        this.runPriority = this.isCyclic ? (byte)-1 : (byte)1;
    }

    @Override
    public void run() {
        CollectRep.MetricsData.Builder response;
        block9: {
            this.startTime = System.currentTimeMillis();
            this.setNewThreadName(this.monitorId, this.app, this.startTime, this.metrics);
            response = CollectRep.MetricsData.newBuilder();
            response.setApp(this.app);
            response.setId(this.monitorId);
            response.setTenantId(this.tenantId);
            if ("prometheus".equalsIgnoreCase(this.metrics.getProtocol())) {
                List metricsData = PrometheusAutoCollectImpl.getInstance().collect(response, this.metrics);
                this.validateResponse((CollectRep.MetricsData)metricsData.stream().findFirst().orElse(null));
                this.collectDataDispatch.dispatchCollectData(this.timeout, this.metrics, metricsData);
                return;
            }
            response.setMetrics(this.metrics.getName());
            AbstractCollect abstractCollect = CollectStrategyFactory.invoke(this.metrics.getProtocol());
            if (abstractCollect == null) {
                log.error("[Dispatcher] - not support this: app: {}, metrics: {}, protocol: {}.", new Object[]{this.app, this.metrics.getName(), this.metrics.getProtocol()});
                response.setCode(CollectRep.Code.FAIL);
                response.setMsg("not support " + this.app + ", " + this.metrics.getName() + ", " + this.metrics.getProtocol());
            } else {
                try {
                    abstractCollect.preCheck(this.metrics);
                    abstractCollect.collect(response, this.monitorId, this.app, this.metrics);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null && e.getCause() != null) {
                        msg = e.getCause().getMessage();
                    }
                    if (e instanceof IllegalArgumentException) {
                        log.error("[Metrics PreCheck]: {}.", (Object)msg, (Object)e);
                    } else {
                        log.error("[Metrics Collect]: {}.", (Object)msg, (Object)e);
                    }
                    response.setCode(CollectRep.Code.FAIL);
                    if (msg == null) break block9;
                    response.setMsg(msg);
                }
            }
        }
        if (this.fastFailed()) {
            return;
        }
        this.calculateFields(this.metrics, response);
        CollectRep.MetricsData metricsData = this.validateResponse(response);
        this.collectDataDispatch.dispatchCollectData(this.timeout, this.metrics, metricsData);
    }

    private void calculateFields(Metrics metrics, CollectRep.MetricsData.Builder collectData) {
        collectData.setPriority((int)metrics.getPriority().byteValue());
        LinkedList<CollectRep.Field> fieldList = new LinkedList<CollectRep.Field>();
        for (Metrics.Field field : metrics.getFields()) {
            CollectRep.Field.Builder fieldBuilder = CollectRep.Field.newBuilder();
            fieldBuilder.setName(field.getField()).setType((int)field.getType()).setLabel(field.isLabel());
            if (field.getUnit() != null) {
                fieldBuilder.setUnit(field.getUnit());
            }
            fieldList.add(fieldBuilder.build());
        }
        collectData.addAllFields(fieldList);
        List aliasRowList = collectData.getValuesList();
        if (aliasRowList == null || aliasRowList.isEmpty()) {
            return;
        }
        collectData.clearValues();
        if (metrics.getCalculates() == null) {
            metrics.setCalculates(Collections.emptyList());
        }
        HashMap fieldAliasMap = new HashMap(8);
        Map<String, JexlExpression> fieldExpressionMap = metrics.getCalculates().stream().map(cal -> this.transformCal((String)cal, fieldAliasMap)).filter(Objects::nonNull).collect(Collectors.toMap(arr -> (String)arr[0], arr -> (JexlExpression)arr[1], (oldValue, newValue) -> newValue));
        if (metrics.getUnits() == null) {
            metrics.setUnits(Collections.emptyList());
        }
        Map<String, Pair> fieldUnitMap = metrics.getUnits().stream().map(this::transformUnit).filter(Objects::nonNull).collect(Collectors.toMap(arr -> (String)arr[0], arr -> (Pair)arr[1], (oldValue, newValue) -> newValue));
        List fields = metrics.getFields();
        List aliasFields = metrics.getAliasFields();
        HashMap<String, String> aliasFieldValueMap = new HashMap<String, String>(8);
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(8);
        HashMap<String, String> stringTypefieldValueMap = new HashMap<String, String>(8);
        HashMap<String, String> aliasFieldUnitMap = new HashMap<String, String>(8);
        CollectRep.ValueRow.Builder realValueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (CollectRep.ValueRow aliasRow : aliasRowList) {
            for (int aliasIndex = 0; aliasIndex < aliasFields.size(); ++aliasIndex) {
                String aliasFieldValue = aliasRow.getColumns(aliasIndex);
                String aliasField = (String)aliasFields.get(aliasIndex);
                if (!"&nbsp;".equals(aliasFieldValue)) {
                    aliasFieldValueMap.put(aliasField, aliasFieldValue);
                    CollectUtil.DoubleAndUnit doubleAndUnit = CollectUtil.extractDoubleAndUnitFromStr((String)aliasFieldValue);
                    if (doubleAndUnit != null && doubleAndUnit.getValue() != null) {
                        fieldValueMap.put(aliasField, doubleAndUnit.getValue());
                        if (doubleAndUnit.getUnit() != null) {
                            aliasFieldUnitMap.put(aliasField, doubleAndUnit.getUnit());
                        }
                    } else {
                        fieldValueMap.put(aliasField, aliasFieldValue);
                    }
                    stringTypefieldValueMap.put(aliasField, aliasFieldValue);
                    continue;
                }
                fieldValueMap.put(aliasField, null);
                stringTypefieldValueMap.put(aliasField, null);
            }
            for (Metrics.Field field : fields) {
                String realField = field.getField();
                JexlExpression expression = fieldExpressionMap.get(realField);
                String value = null;
                String aliasFieldUnit = null;
                if (expression != null) {
                    try {
                        HashMap<String, String> context;
                        if (1 == field.getType()) {
                            context = stringTypefieldValueMap;
                        } else {
                            for (Map.Entry unitEntry : aliasFieldUnitMap.entrySet()) {
                                if (!expression.getSourceText().contains((CharSequence)unitEntry.getKey())) continue;
                                aliasFieldUnit = (String)unitEntry.getValue();
                                break;
                            }
                            context = fieldValueMap;
                        }
                        Object objValue = JexlExpressionRunner.evaluate((JexlExpression)expression, context);
                        if (objValue != null) {
                            value = String.valueOf(objValue);
                        }
                    }
                    catch (Exception e) {
                        log.info("[calculates execute warning] {}.", (Object)e.getMessage());
                    }
                } else {
                    String aliasField = (String)fieldAliasMap.get(realField);
                    value = aliasField != null ? (String)aliasFieldValueMap.get(aliasField) : (String)aliasFieldValueMap.get(realField);
                    if (value != null) {
                        byte fieldType = field.getType();
                        if (fieldType == 0) {
                            CollectUtil.DoubleAndUnit doubleAndUnit = CollectUtil.extractDoubleAndUnitFromStr((String)value);
                            Double tempValue = doubleAndUnit == null ? null : doubleAndUnit.getValue();
                            value = tempValue == null ? null : String.valueOf(tempValue);
                            aliasFieldUnit = doubleAndUnit == null ? null : doubleAndUnit.getUnit();
                        } else if (fieldType == 3) {
                            int tempValue = CommonUtil.parseTimeStrToSecond((String)value);
                            value = tempValue == -1 ? null : String.valueOf(tempValue);
                        }
                    }
                }
                Pair unitPair = fieldUnitMap.get(realField);
                if (aliasFieldUnit != null) {
                    if (unitPair != null) {
                        unitPair.setLeft(aliasFieldUnit);
                    } else if (field.getUnit() != null && !aliasFieldUnit.equalsIgnoreCase(field.getUnit())) {
                        unitPair = Pair.of((Object)aliasFieldUnit, (Object)field.getUnit());
                    }
                }
                if (value != null && unitPair != null) {
                    for (UnitConvert unitConvert : this.unitConvertList) {
                        if (!unitConvert.checkUnit((String)unitPair.getLeft()) || !unitConvert.checkUnit((String)unitPair.getRight())) continue;
                        value = unitConvert.convert(value, (String)unitPair.getLeft(), (String)unitPair.getRight());
                    }
                }
                if (0 == field.getType()) {
                    value = CommonUtil.parseDoubleStr((String)value, (String)field.getUnit());
                }
                if (value == null) {
                    value = "&nbsp;";
                }
                realValueRowBuilder.addColumns(value);
            }
            aliasFieldValueMap.clear();
            fieldValueMap.clear();
            aliasFieldUnitMap.clear();
            stringTypefieldValueMap.clear();
            collectData.addValues(realValueRowBuilder.build());
            realValueRowBuilder.clear();
        }
    }

    private Object[] transformCal(String cal, Map<String, String> fieldAliasMap) {
        JexlExpression expression;
        int splitIndex = cal.indexOf("=");
        String field = cal.substring(0, splitIndex).trim();
        String expressionStr = cal.substring(splitIndex + 1).trim().replace("\\#", "#");
        try {
            expression = JexlExpressionRunner.compile((String)expressionStr);
        }
        catch (Exception e) {
            fieldAliasMap.put(field, expressionStr);
            return null;
        }
        return new Object[]{field, expression};
    }

    private Object[] transformUnit(String unit) {
        int equalIndex = unit.indexOf("=");
        int arrowIndex = unit.indexOf("->");
        if (equalIndex < 0 || arrowIndex < 0) {
            return null;
        }
        String field = unit.substring(0, equalIndex).trim();
        String originUnit = unit.substring(equalIndex + 1, arrowIndex).trim();
        String newUnit = unit.substring(arrowIndex + 2).trim();
        return new Object[]{field, Pair.of((Object)originUnit, (Object)newUnit)};
    }

    private boolean fastFailed() {
        return this.timeout == null || this.timeout.isCancelled();
    }

    private CollectRep.MetricsData validateResponse(CollectRep.MetricsData.Builder builder) {
        long endTime = System.currentTimeMillis();
        builder.setTime(endTime);
        long runningTime = endTime - this.startTime;
        long allTime = endTime - this.newTime;
        if (this.startTime - this.newTime >= 100L) {
            log.warn("[Collector Dispatch Warn, Dispatch Use {}ms.", (Object)(this.startTime - this.newTime));
        }
        if (builder.getCode() != CollectRep.Code.SUCCESS) {
            log.info("[Collect Failed, Run {}ms, All {}ms] Reason: {}", new Object[]{runningTime, allTime, builder.getMsg()});
        } else {
            log.info("[Collect Success, Run {}ms, All {}ms].", (Object)runningTime, (Object)allTime);
        }
        return builder.build();
    }

    private void validateResponse(CollectRep.MetricsData metricsData) {
        if (metricsData == null) {
            log.error("[Collect Failed] Response metrics data is null.");
            return;
        }
        long endTime = System.currentTimeMillis();
        long runningTime = endTime - this.startTime;
        long allTime = endTime - this.newTime;
        if (this.startTime - this.newTime >= 100L) {
            log.warn("[Collector Dispatch Warn, Dispatch Use {}ms.", (Object)(this.startTime - this.newTime));
        }
        if (metricsData.getCode() != CollectRep.Code.SUCCESS) {
            log.info("[Collect Failed, Run {}ms, All {}ms] Reason: {}", new Object[]{runningTime, allTime, metricsData.getMsg()});
        } else {
            log.info("[Collect Success, Run {}ms, All {}ms].", (Object)runningTime, (Object)allTime);
        }
    }

    private void setNewThreadName(long monitorId, String app, long startTime, Metrics metrics) {
        String builder = monitorId + "-" + app + "-" + metrics.getName() + "-" + String.valueOf(startTime).substring(9);
        Thread.currentThread().setName(builder);
    }

    @Override
    public int compareTo(MetricsCollect collect) {
        return collect.runPriority - this.runPriority;
    }

    public String getCollectorIdentity() {
        return this.collectorIdentity;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public long getMonitorId() {
        return this.monitorId;
    }

    public String getApp() {
        return this.app;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public CollectDataDispatch getCollectDataDispatch() {
        return this.collectDataDispatch;
    }

    public byte getRunPriority() {
        return this.runPriority;
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public long getNewTime() {
        return this.newTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public List<UnitConvert> getUnitConvertList() {
        return this.unitConvertList;
    }

    public void setCollectorIdentity(String collectorIdentity) {
        this.collectorIdentity = collectorIdentity;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public void setMonitorId(long monitorId) {
        this.monitorId = monitorId;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }

    public void setCollectDataDispatch(CollectDataDispatch collectDataDispatch) {
        this.collectDataDispatch = collectDataDispatch;
    }

    public void setRunPriority(byte runPriority) {
        this.runPriority = runPriority;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
    }

    public void setNewTime(long newTime) {
        this.newTime = newTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setUnitConvertList(List<UnitConvert> unitConvertList) {
        this.unitConvertList = unitConvertList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsCollect)) {
            return false;
        }
        MetricsCollect other = (MetricsCollect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTenantId() != other.getTenantId()) {
            return false;
        }
        if (this.getMonitorId() != other.getMonitorId()) {
            return false;
        }
        if (this.getRunPriority() != other.getRunPriority()) {
            return false;
        }
        if (this.isCyclic() != other.isCyclic()) {
            return false;
        }
        if (this.getNewTime() != other.getNewTime()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        String this$collectorIdentity = this.getCollectorIdentity();
        String other$collectorIdentity = other.getCollectorIdentity();
        if (this$collectorIdentity == null ? other$collectorIdentity != null : !this$collectorIdentity.equals(other$collectorIdentity)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        Metrics this$metrics = this.getMetrics();
        Metrics other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        Timeout this$timeout = this.getTimeout();
        Timeout other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        CollectDataDispatch this$collectDataDispatch = this.getCollectDataDispatch();
        CollectDataDispatch other$collectDataDispatch = other.getCollectDataDispatch();
        if (this$collectDataDispatch == null ? other$collectDataDispatch != null : !this$collectDataDispatch.equals(other$collectDataDispatch)) {
            return false;
        }
        List<UnitConvert> this$unitConvertList = this.getUnitConvertList();
        List<UnitConvert> other$unitConvertList = other.getUnitConvertList();
        return !(this$unitConvertList == null ? other$unitConvertList != null : !((Object)this$unitConvertList).equals(other$unitConvertList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricsCollect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $tenantId = this.getTenantId();
        result = result * 59 + (int)($tenantId >>> 32 ^ $tenantId);
        long $monitorId = this.getMonitorId();
        result = result * 59 + (int)($monitorId >>> 32 ^ $monitorId);
        result = result * 59 + this.getRunPriority();
        result = result * 59 + (this.isCyclic() ? 79 : 97);
        long $newTime = this.getNewTime();
        result = result * 59 + (int)($newTime >>> 32 ^ $newTime);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        String $collectorIdentity = this.getCollectorIdentity();
        result = result * 59 + ($collectorIdentity == null ? 43 : $collectorIdentity.hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        Metrics $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        Timeout $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        CollectDataDispatch $collectDataDispatch = this.getCollectDataDispatch();
        result = result * 59 + ($collectDataDispatch == null ? 43 : $collectDataDispatch.hashCode());
        List<UnitConvert> $unitConvertList = this.getUnitConvertList();
        result = result * 59 + ($unitConvertList == null ? 43 : ((Object)$unitConvertList).hashCode());
        return result;
    }

    public String toString() {
        return "MetricsCollect(collectorIdentity=" + this.getCollectorIdentity() + ", tenantId=" + this.getTenantId() + ", monitorId=" + this.getMonitorId() + ", app=" + this.getApp() + ", metrics=" + this.getMetrics() + ", timeout=" + this.getTimeout() + ", collectDataDispatch=" + this.getCollectDataDispatch() + ", runPriority=" + this.getRunPriority() + ", isCyclic=" + this.isCyclic() + ", newTime=" + this.getNewTime() + ", startTime=" + this.getStartTime() + ", unitConvertList=" + this.getUnitConvertList() + ")";
    }
}

