/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.usthe.sureness.provider.SurenessAccount;
import com.usthe.sureness.provider.SurenessAccountProvider;
import com.usthe.sureness.provider.ducument.DocumentAccountProvider;
import com.usthe.sureness.util.JsonWebTokenUtil;
import com.usthe.sureness.util.Md5Util;
import io.jsonwebtoken.Claims;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.manager.pojo.dto.LoginDto;
import org.apache.hertzbeat.manager.pojo.dto.RefreshTokenResponse;
import org.apache.hertzbeat.manager.service.AccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=-2147483648)
public class AccountServiceImpl
implements AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    private static final long PERIOD_TIME = 3600L;
    private final SurenessAccountProvider accountProvider = new DocumentAccountProvider();

    @Override
    public Map<String, String> authGetToken(LoginDto loginDto) throws AuthenticationException {
        SurenessAccount account = this.accountProvider.loadAccount(loginDto.getIdentifier());
        if (account == null || StringUtils.isBlank(account.getPassword())) {
            throw new AuthenticationException("Incorrect Account or Password");
        }
        String password = loginDto.getCredential();
        if (StringUtils.isNotBlank(account.getSalt())) {
            password = Md5Util.md5(password + account.getSalt());
        }
        if (!account.getPassword().equals(password)) {
            throw new AuthenticationException("Incorrect Account or Password");
        }
        if (account.isDisabledAccount() || account.isExcessiveAttempts()) {
            throw new AuthenticationException("Expired or Illegal Account");
        }
        List<String> roles = account.getOwnRoles();
        String issueToken = JsonWebTokenUtil.issueJwt(loginDto.getIdentifier(), (Long)3600L, roles);
        HashMap<String, Object> customClaimMap = new HashMap<String, Object>(1);
        customClaimMap.put("refresh", true);
        String issueRefresh = JsonWebTokenUtil.issueJwt(loginDto.getIdentifier(), (Long)115200L, customClaimMap);
        HashMap<String, String> resp = new HashMap<String, String>(2);
        resp.put("token", issueToken);
        resp.put("refreshToken", issueRefresh);
        resp.put("role", JsonUtil.toJson(roles));
        return resp;
    }

    @Override
    public RefreshTokenResponse refreshToken(String refreshToken) throws Exception {
        Claims claims = JsonWebTokenUtil.parseJwt(refreshToken);
        String userId = String.valueOf(claims.getSubject());
        boolean isRefresh = claims.get("refresh", Boolean.class);
        if (StringUtils.isBlank(userId) || !isRefresh) {
            throw new AuthenticationException("Illegal Refresh Token");
        }
        SurenessAccount account = this.accountProvider.loadAccount(userId);
        if (account == null) {
            throw new AuthenticationException("Not Exists This Token Mapping Account");
        }
        List<String> roles = account.getOwnRoles();
        String issueToken = this.issueToken(userId, roles, 3600L);
        String issueRefresh = this.issueToken(userId, roles, 115200L);
        return new RefreshTokenResponse(issueToken, issueRefresh);
    }

    private String issueToken(String userId, List<String> roles, long expirationMillis) {
        HashMap<String, Object> customClaimMap = new HashMap<String, Object>(1);
        customClaimMap.put("refresh", true);
        return JsonWebTokenUtil.issueJwt(userId, expirationMillis, roles, customClaimMap);
    }
}

