/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.scheduler.netty.process;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.ProtoJsonUtil;
import org.apache.hertzbeat.manager.scheduler.netty.ManageServer;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectOneTimeDataResponseProcessor
implements NettyRemotingProcessor {
    private static final Logger log = LoggerFactory.getLogger(CollectOneTimeDataResponseProcessor.class);
    private final ManageServer manageServer;

    public CollectOneTimeDataResponseProcessor(ManageServer manageServer) {
        this.manageServer = manageServer;
    }

    @Override
    public ClusterMsg.Message handle(ChannelHandlerContext ctx, ClusterMsg.Message message) {
        TypeReference<List<String>> typeReference = new TypeReference<List<String>>(){};
        List<String> jsonArr = JsonUtil.fromJson(message.getMsg(), typeReference);
        if (jsonArr == null) {
            log.error("netty receive response one time task data parse null error");
            return null;
        }
        ArrayList<CollectRep.MetricsData> metricsDataList = new ArrayList<CollectRep.MetricsData>(jsonArr.size());
        for (String str : jsonArr) {
            CollectRep.MetricsData metricsData = (CollectRep.MetricsData)ProtoJsonUtil.toProtobuf(str, CollectRep.MetricsData.newBuilder());
            if (metricsData == null) continue;
            metricsDataList.add(metricsData);
        }
        this.manageServer.getCollectorAndJobScheduler().collectSyncJobResponse(metricsDataList);
        return null;
    }
}

