/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.manager.service.TagService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Tag Manage API")
@RestController
@RequestMapping(path={"/api/tag"}, produces={"application/json"})
public class TagController {
    @Autowired
    private TagService tagService;

    @PostMapping
    @Operation(summary="Add Tag", description="Add Tag")
    public ResponseEntity<Message<Void>> addNewTags(@Valid @RequestBody List<org.apache.hertzbeat.common.entity.manager.Tag> tags) {
        this.tagService.addTags(tags);
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @PutMapping
    @Operation(summary="Modify an existing tag", description="Modify an existing tag")
    public ResponseEntity<Message<Void>> modifyMonitor(@Valid @RequestBody org.apache.hertzbeat.common.entity.manager.Tag tag) {
        if (tag.getId() == null) {
            throw new IllegalArgumentException("ID cannot be null.");
        }
        this.tagService.modifyTag(tag);
        return ResponseEntity.ok(Message.success("Modify success"));
    }

    @GetMapping
    @Operation(summary="Get tags information", description="Obtain label information based on conditions")
    public ResponseEntity<Message<Page<org.apache.hertzbeat.common.entity.manager.Tag>>> getTags(@Parameter(description="Tag content search", example="status") @RequestParam(required=false) String search, @Parameter(description="Tag type", example="0") @RequestParam(required=false) Byte type, @Parameter(description="List current page", example="0") @RequestParam(defaultValue="0") int pageIndex, @Parameter(description="Number of list pagination", example="8") @RequestParam(defaultValue="8") int pageSize) {
        return ResponseEntity.ok(Message.success(this.tagService.getTags(search, type, pageIndex, pageSize)));
    }

    @DeleteMapping
    @Operation(summary="Delete tags based on ID", description="Delete tags based on ID")
    public ResponseEntity<Message<Void>> deleteTags(@Parameter(description="TAG IDs ", example="6565463543") @RequestParam(required=false) List<Long> ids) {
        this.tagService.deleteTags(new HashSet<Long>(ids));
        return ResponseEntity.ok(Message.success("Delete success"));
    }
}

