/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.status;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.Predicate;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.StatusPageComponent;
import org.apache.hertzbeat.common.entity.manager.StatusPageHistory;
import org.apache.hertzbeat.common.entity.manager.StatusPageOrg;
import org.apache.hertzbeat.common.entity.manager.Tag;
import org.apache.hertzbeat.common.entity.manager.TagItem;
import org.apache.hertzbeat.manager.config.StatusProperties;
import org.apache.hertzbeat.manager.dao.MonitorDao;
import org.apache.hertzbeat.manager.dao.StatusPageComponentDao;
import org.apache.hertzbeat.manager.dao.StatusPageHistoryDao;
import org.apache.hertzbeat.manager.dao.StatusPageOrgDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class CalculateStatus {
    private static final Logger log = LoggerFactory.getLogger(CalculateStatus.class);
    private static final int DEFAULT_CALCULATE_INTERVAL_TIME = 300;
    private final StatusPageOrgDao statusPageOrgDao;
    private final StatusPageComponentDao statusPageComponentDao;
    private final StatusPageHistoryDao statusPageHistoryDao;
    private final MonitorDao monitorDao;
    private final int intervals;

    public CalculateStatus(StatusPageOrgDao statusPageOrgDao, StatusPageComponentDao statusPageComponentDao, StatusProperties statusProperties, StatusPageHistoryDao statusPageHistoryDao, MonitorDao monitorDao) {
        this.statusPageOrgDao = statusPageOrgDao;
        this.monitorDao = monitorDao;
        this.statusPageComponentDao = statusPageComponentDao;
        this.statusPageHistoryDao = statusPageHistoryDao;
        this.intervals = statusProperties.getCalculate() == null ? 300 : statusProperties.getCalculate().getInterval();
        this.startCalculate();
        this.startCombineHistory();
    }

    private void startCalculate() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("Status calculate has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("status-page-calculate-%d").build();
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        scheduledExecutor.scheduleAtFixedRate(() -> {
            log.info("start to calculate status page state");
            try {
                Iterable statusPageOrgList = this.statusPageOrgDao.findAll();
                for (StatusPageOrg statusPageOrg : statusPageOrgList) {
                    long orgId = statusPageOrg.getId();
                    List<StatusPageComponent> pageComponentList = this.statusPageComponentDao.findByOrgId(orgId);
                    HashSet<Byte> stateSet = new HashSet<Byte>(8);
                    for (StatusPageComponent component : pageComponentList) {
                        byte state = 0;
                        if (component.getMethod() == 1) {
                            state = component.getConfigState();
                        } else {
                            TagItem tagItem = component.getTag();
                            if (tagItem != null) {
                                Specification specification = (root, query, criteriaBuilder) -> {
                                    ArrayList<Predicate> andList = new ArrayList<Predicate>();
                                    ListJoin tagJoin = root.join(root.getModel().getList("tags", Tag.class), JoinType.LEFT);
                                    if (StringUtils.isNotBlank(tagItem.getValue())) {
                                        andList.add(criteriaBuilder.equal(tagJoin.get("name"), tagItem.getName()));
                                        andList.add(criteriaBuilder.equal(tagJoin.get("tagValue"), tagItem.getValue()));
                                    } else {
                                        andList.add(criteriaBuilder.equal(tagJoin.get("name"), tagItem.getName()));
                                    }
                                    Predicate[] andPredicates = new Predicate[andList.size()];
                                    Predicate andPredicate = criteriaBuilder.and(andList.toArray(andPredicates));
                                    return query.where((Expression)andPredicate).getRestriction();
                                };
                                List monitorList = this.monitorDao.findAll(specification);
                                state = 2;
                                for (Monitor monitor : monitorList) {
                                    if (monitor.getStatus() == 2) {
                                        state = 1;
                                        break;
                                    }
                                    if (monitor.getStatus() != 1) continue;
                                    state = 0;
                                }
                            }
                        }
                        stateSet.add(state);
                        component.setState(state);
                        this.statusPageComponentDao.save(component);
                        StatusPageHistory statusPageHistory = StatusPageHistory.builder().componentId(component.getId()).state(state).timestamp(System.currentTimeMillis()).build();
                        this.statusPageHistoryDao.save(statusPageHistory);
                    }
                    stateSet.remove((byte)2);
                    if (stateSet.remove((byte)1)) {
                        if (stateSet.contains((byte)0)) {
                            statusPageOrg.setState((byte)1);
                        } else {
                            statusPageOrg.setState((byte)2);
                        }
                    } else {
                        statusPageOrg.setState((byte)0);
                    }
                    statusPageOrg.setGmtUpdate(LocalDateTime.now());
                    this.statusPageOrgDao.save(statusPageOrg);
                }
            }
            catch (Exception e) {
                log.error("status page calculate component state error: {}", (Object)e.getMessage(), (Object)e);
            }
        }, 5L, this.intervals, TimeUnit.SECONDS);
    }

    private void startCombineHistory() {
        LocalDateTime nextRun;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("History combine has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("status-page-calculate-%d").build();
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(nextRun = now.withHour(1).withMinute(0).withSecond(0))) {
            nextRun = nextRun.plusDays(1L);
        }
        long delay = Duration.between(now, nextRun).toMillis();
        scheduledExecutor.scheduleAtFixedRate(() -> {
            try {
                LocalDateTime nowTime = LocalDateTime.now();
                ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(Instant.now());
                LocalDateTime midnight = nowTime.withHour(0).withMinute(0).withSecond(0).withNano(0);
                LocalDateTime preNight = midnight.minusDays(1L);
                long midnightTimestamp = midnight.toInstant(zoneOffset).toEpochMilli();
                long preNightTimestamp = preNight.toInstant(zoneOffset).toEpochMilli();
                List<StatusPageHistory> statusPageHistoryList = this.statusPageHistoryDao.findStatusPageHistoriesByTimestampBetween(preNightTimestamp, midnightTimestamp);
                HashMap<Long, StatusPageHistory> statusPageHistoryMap = new HashMap<Long, StatusPageHistory>(8);
                for (StatusPageHistory statusPageHistory : statusPageHistoryList) {
                    statusPageHistory.setNormal(0);
                    statusPageHistory.setAbnormal(0);
                    statusPageHistory.setUnknowing(0);
                    if (statusPageHistoryMap.containsKey(statusPageHistory.getComponentId())) {
                        StatusPageHistory history = (StatusPageHistory)statusPageHistoryMap.get(statusPageHistory.getComponentId());
                        if (statusPageHistory.getState() == 1) {
                            history.setAbnormal(history.getAbnormal() + this.intervals);
                        } else if (statusPageHistory.getState() == 2) {
                            history.setUnknowing(history.getUnknowing() + this.intervals);
                        } else {
                            history.setNormal(history.getNormal() + this.intervals);
                        }
                        statusPageHistoryMap.put(statusPageHistory.getComponentId(), history);
                        continue;
                    }
                    if (statusPageHistory.getState() == 1) {
                        statusPageHistory.setAbnormal(this.intervals);
                    } else if (statusPageHistory.getState() == 2) {
                        statusPageHistory.setUnknowing(this.intervals);
                    } else {
                        statusPageHistory.setNormal(this.intervals);
                    }
                    statusPageHistoryMap.put(statusPageHistory.getComponentId(), statusPageHistory);
                }
                this.statusPageHistoryDao.deleteAll(statusPageHistoryList);
                for (StatusPageHistory history : statusPageHistoryMap.values()) {
                    double total = history.getNormal() + history.getAbnormal() + history.getUnknowing();
                    double uptime = 0.0;
                    if (total > 0.0) {
                        uptime = (double)history.getNormal().intValue() / total;
                    }
                    history.setUptime(uptime);
                    if (history.getAbnormal() > 0) {
                        history.setState((byte)1);
                    } else if (history.getNormal() > 0) {
                        history.setState((byte)0);
                    } else {
                        history.setState((byte)2);
                    }
                    this.statusPageHistoryDao.save(history);
                }
            }
            catch (Exception e) {
                log.error("status page combine history error: {}", (Object)e.getMessage(), (Object)e);
            }
        }, delay, TimeUnit.DAYS.toMillis(1L), TimeUnit.MILLISECONDS);
    }

    public int getCalculateStatusIntervals() {
        return this.intervals;
    }
}

