/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WeChatAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(WeChatAlertNotifyHandlerImpl.class);
    private static final String CORP_ID = "YOUR_CORP_ID";
    private static final String CORP_SECRET = "YOUR_CORP_SECRET";
    private static final String AGENT_ID = "YOUR_AGENT_ID";
    private static final String GET_TOKEN_URL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=YOUR_CORP_ID&corpsecret=YOUR_CORP_SECRET";
    private static final String SEND_MESSAGE_URL = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=";
    private static final String ACCESS_TOKEN = "access_token";

    WeChatAlertNotifyHandlerImpl() {
    }

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        try {
            String accessToken = this.getAccessToken();
            String messageContent = this.constructMessageContent(receiver, noticeTemplate, alert);
            this.sendMessage(accessToken, messageContent);
        }
        catch (Exception e) {
            log.error("Failed to send WeChat alert", e);
        }
    }

    private String getAccessToken() throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(new URI(GET_TOKEN_URL)).GET().build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        JsonObject jsonObject = JsonParser.parseString(response.body()).getAsJsonObject();
        String accessToken = null;
        if (jsonObject.has(ACCESS_TOKEN)) {
            accessToken = jsonObject.get(ACCESS_TOKEN).getAsString();
        } else {
            log.error("Failed to obtain ACCESS_TOKEN from response: {}", (Object)response.body());
        }
        return accessToken;
    }

    private String constructMessageContent(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        JsonObject messageContent = new JsonObject();
        messageContent.addProperty("msgtype", "text");
        JsonObject textContent = new JsonObject();
        String alertMessage = String.format("\u8b66\u544a\uff1a%s\n\u8be6\u60c5\uff1a%s", alert.getAlertDefineId(), alert.getContent());
        textContent.addProperty("content", alertMessage);
        messageContent.add("text", textContent);
        JsonObject atInfo = new JsonObject();
        atInfo.addProperty("isAtAll", false);
        messageContent.add("at", atInfo);
        return messageContent.toString();
    }

    private void sendMessage(String accessToken, String messageContent) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(new URI(SEND_MESSAGE_URL + accessToken)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(messageContent)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        log.info("Message sent response: {}", (Object)response.body());
    }

    @Override
    public byte type() {
        return 3;
    }
}

