/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.component.alerter.impl.CommonRobotNotifyResp;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ServerChanAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(ServerChanAlertNotifyHandlerImpl.class);

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) throws AlertNoticeException {
        try {
            ServerChanWebHookDto serverChanWebHookDto = new ServerChanWebHookDto();
            serverChanWebHookDto.setTitle(this.bundle.getString("alerter.notify.title"));
            serverChanWebHookDto.setDesp(this.renderContent(noticeTemplate, alert));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<ServerChanWebHookDto> httpEntity = new HttpEntity<ServerChanWebHookDto>(serverChanWebHookDto, headers);
            String webHookUrl = String.format(this.alerterProperties.getServerChanWebhookUrl(), receiver.getServerChanToken());
            ResponseEntity<CommonRobotNotifyResp> responseEntity = this.restTemplate.postForEntity(webHookUrl, httpEntity, CommonRobotNotifyResp.class, new Object[0]);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                log.warn("Send ServerChan webHook: {} Failed: {}", (Object)webHookUrl, responseEntity.getBody());
                throw new AlertNoticeException("Http StatusCode " + responseEntity.getStatusCode());
            }
            log.debug("Send ServerChan webHook: {} Success", (Object)webHookUrl);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[ServerChan Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 12;
    }

    protected static class ServerChanWebHookDto {
        private static final String MARKDOWN = "markdown";
        private String title;
        private String desp;

        public String getTitle() {
            return this.title;
        }

        public String getDesp() {
            return this.desp;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setDesp(String desp) {
            this.desp = desp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerChanWebHookDto)) {
                return false;
            }
            ServerChanWebHookDto other = (ServerChanWebHookDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$desp = this.getDesp();
            String other$desp = other.getDesp();
            return !(this$desp == null ? other$desp != null : !this$desp.equals(other$desp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServerChanWebHookDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $desp = this.getDesp();
            result = result * 59 + ($desp == null ? 43 : $desp.hashCode());
            return result;
        }

        public String toString() {
            return "ServerChanAlertNotifyHandlerImpl.ServerChanWebHookDto(title=" + this.getTitle() + ", desp=" + this.getDesp() + ")";
        }
    }
}

