/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.component.alerter.impl.CommonRobotNotifyResp;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
final class FlyBookAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(FlyBookAlertNotifyHandlerImpl.class);
    private static final String[] TITLE_COLOR = new String[]{"red", "yellow", "orange"};

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        try {
            String notificationContent = JsonUtil.toJson(this.renderContent(noticeTemplate, alert));
            String cardMessage = this.createLarkMessage(receiver.getUserId(), notificationContent, alert.getPriority());
            String webHookUrl = this.alerterProperties.getFlyBookWebhookUrl() + receiver.getAccessToken();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<String> flyEntity = new HttpEntity<String>(cardMessage, headers);
            ResponseEntity<CommonRobotNotifyResp> entity = this.restTemplate.postForEntity(webHookUrl, flyEntity, CommonRobotNotifyResp.class, new Object[0]);
            if (entity.getStatusCode() == HttpStatus.OK) {
                assert (entity.getBody() != null);
                if (((CommonRobotNotifyResp)entity.getBody()).getCode() != null && ((CommonRobotNotifyResp)entity.getBody()).getCode() != 0) {
                    log.warn("Send feiShu webHook: {} Failed: {}", (Object)webHookUrl, (Object)((CommonRobotNotifyResp)entity.getBody()).getMsg());
                    throw new AlertNoticeException(((CommonRobotNotifyResp)entity.getBody()).getMsg());
                }
            } else {
                log.warn("Send feiShu webHook: {} Failed: {}", (Object)webHookUrl, entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            log.debug("Send feiShu webHook: {} Success", (Object)webHookUrl);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[FeiShu Notify Error] " + e.getMessage());
        }
    }

    private String createLarkMessage(String userId, String notificationContent, byte priority) {
        String larkCardMessage = "{\n    \"msg_type\": \"interactive\",\n    \"card\": {\n        \"config\": {\n            \"update_multi\": true\n        },\n        \"i18n_elements\": {\n            \"zh_cn\": [\n                {\n                    \"tag\": \"column_set\",\n                    \"flex_mode\": \"none\",\n                    \"horizontal_spacing\": \"default\",\n                    \"background_style\": \"default\",\n                    \"columns\": [\n                        {\n                            \"tag\": \"column\",\n                            \"elements\": [\n                                {\n                                    \"tag\": \"div\",\n                                    \"text\": {\n                                        \"tag\": \"plain_text\",\n                                        \"content\": \"\",\n                                        \"text_size\": \"normal\",\n                                        \"text_align\": \"left\",\n                                        \"text_color\": \"default\"\n                                    }\n                                }\n                            ],\n                            \"width\": \"weighted\",\n                            \"weight\": 1\n                        }\n                    ]\n                },\n                {\n                    \"tag\": \"column_set\",\n                    \"flex_mode\": \"none\",\n                    \"horizontal_spacing\": \"default\",\n                    \"background_style\": \"default\",\n                    \"columns\": [\n                        {\n                            \"tag\": \"column\",\n                            \"elements\": [\n                                {\n                                    \"tag\": \"div\",\n                                    \"text\": {\n                                        \"tag\": \"plain_text\",\n                                        \"content\": %s,\n                                        \"text_size\": \"normal\",\n                                        \"text_align\": \"left\",\n                                        \"text_color\": \"default\"\n                                    }\n                                }\n                            ],\n                            \"width\": \"weighted\",\n                            \"weight\": 1\n                        }\n                    ]\n                },\n                %s\n                {\n                    \"tag\": \"action\",\n                    \"actions\": [\n                        {\n                            \"tag\": \"button\",\n                            \"text\": {\n                                \"tag\": \"plain_text\",\n                                \"content\": \"\u767b\u5165\u63a7\u5236\u53f0\"\n                            },\n                            \"type\": \"default\",\n                            \"complex_interaction\": true,\n                            \"width\": \"default\",\n                            \"size\": \"medium\",\n                            \"multi_url\": {\n                                \"url\": \"%s\"\n                            }\n                        }\n                    ]\n                }\n            ]\n        },\n        \"i18n_header\": {\n            \"zh_cn\": {\n                \"title\": {\n                    \"tag\": \"plain_text\",\n                    \"content\": \"HertzBeat \u544a\u8b66\"\n                },\n                \"template\": \"%s\"\n            }\n        }\n    }\n}\n";
        String atUserElement = "";
        if (StringUtils.isNotBlank(userId)) {
            String atUserId = Arrays.stream(userId.split(",")).map(id -> "<at id=" + id + "></at>").collect(Collectors.joining(" "));
            atUserElement = String.format("{\n    \"tag\": \"div\",\n    \"text\": {\n        \"content\": \"%s\",\n        \"tag\": \"lark_md\"\n    }\n},\n", atUserId);
        }
        return String.format(larkCardMessage, notificationContent, atUserElement, this.alerterProperties.getConsoleUrl(), TITLE_COLOR[priority]);
    }

    @Override
    public byte type() {
        return 6;
    }
}

