/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.alerter.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.NoticeReceiver;
import org.apache.hertzbeat.common.entity.manager.NoticeTemplate;
import org.apache.hertzbeat.common.util.StrUtil;
import org.apache.hertzbeat.manager.component.alerter.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.manager.component.alerter.impl.CommonRobotNotifyResp;
import org.apache.hertzbeat.manager.support.exception.AlertNoticeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
final class DingTalkRobotAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(DingTalkRobotAlertNotifyHandlerImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, Alert alert) {
        try {
            DingTalkWebHookDto dingTalkWebHookDto = new DingTalkWebHookDto();
            DingTalkWebHookDto.MarkdownDTO markdownDTO = new DingTalkWebHookDto.MarkdownDTO();
            markdownDTO.setText(this.renderContent(noticeTemplate, alert));
            markdownDTO.setTitle(this.bundle.getString("alerter.notify.title"));
            dingTalkWebHookDto.setMarkdown(markdownDTO);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<DingTalkWebHookDto> httpEntity = new HttpEntity<DingTalkWebHookDto>(dingTalkWebHookDto, headers);
            String webHookUrl = this.alerterProperties.getDingTalkWebhookUrl() + receiver.getAccessToken();
            ResponseEntity<CommonRobotNotifyResp> responseEntity = this.restTemplate.postForEntity(webHookUrl, httpEntity, CommonRobotNotifyResp.class, new Object[0]);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                log.warn("Send dingTalk webHook: {} Failed: {}", (Object)webHookUrl, responseEntity.getBody());
                throw new AlertNoticeException("Http StatusCode " + responseEntity.getStatusCode());
            }
            assert (responseEntity.getBody() != null);
            if (((CommonRobotNotifyResp)responseEntity.getBody()).getErrCode() != 0) {
                log.warn("Send dingTalk webHook: {} Failed: {}", (Object)webHookUrl, (Object)((CommonRobotNotifyResp)responseEntity.getBody()).getErrMsg());
                throw new AlertNoticeException(((CommonRobotNotifyResp)responseEntity.getBody()).getErrMsg());
            }
            log.debug("Send dingTalk webHook: {} Success", (Object)webHookUrl);
            DingTalkWebHookDto dingTalkWebHookTextDto = this.checkNeedAtNominator(receiver);
            if (dingTalkWebHookTextDto != null) {
                HttpEntity<DingTalkWebHookDto> httpEntityText = new HttpEntity<DingTalkWebHookDto>(dingTalkWebHookTextDto, headers);
                this.restTemplate.postForEntity(webHookUrl, httpEntityText, CommonRobotNotifyResp.class, new Object[0]);
            }
            log.debug("Send dingTalk @ message webHook: {} Success", (Object)webHookUrl);
            return;
        }
        catch (Exception e) {
            throw new AlertNoticeException("[DingTalk Notify Error] " + e.getMessage());
        }
    }

    private DingTalkWebHookDto checkNeedAtNominator(NoticeReceiver receiver) {
        if (StringUtils.isBlank(receiver.getPhone()) && StringUtils.isBlank(receiver.getTgUserId())) {
            return null;
        }
        DingTalkWebHookDto dingTalkWebHookDto = new DingTalkWebHookDto();
        dingTalkWebHookDto.setMsgType("text");
        DingTalkWebHookDto.AtDTO atDTO = new DingTalkWebHookDto.AtDTO();
        dingTalkWebHookDto.setAt(atDTO);
        if (StringUtils.isNotBlank(receiver.getPhone())) {
            atDTO.setAtMobiles(StrUtil.analysisArgToList(receiver.getPhone()));
        }
        if (StringUtils.isNotBlank(receiver.getTgUserId())) {
            atDTO.setAtUserIds(StrUtil.analysisArgToList(receiver.getTgUserId()));
        }
        DingTalkWebHookDto.TextDTO textDTO = new DingTalkWebHookDto.TextDTO();
        textDTO.setContent(this.bundle.getString("alerter.notify.title"));
        dingTalkWebHookDto.setText(textDTO);
        return dingTalkWebHookDto;
    }

    @Override
    public byte type() {
        return 5;
    }

    private static class DingTalkWebHookDto {
        private static final String DEFAULT_MSG_TYPE = "markdown";
        private static final String TEXT_MSG_TYPE = "text";
        @JsonProperty(value="msgtype")
        private String msgType = "markdown";
        private MarkdownDTO markdown;
        private AtDTO at;
        private TextDTO text;

        public String getMsgType() {
            return this.msgType;
        }

        public MarkdownDTO getMarkdown() {
            return this.markdown;
        }

        public AtDTO getAt() {
            return this.at;
        }

        public TextDTO getText() {
            return this.text;
        }

        @JsonProperty(value="msgtype")
        public void setMsgType(String msgType) {
            this.msgType = msgType;
        }

        public void setMarkdown(MarkdownDTO markdown) {
            this.markdown = markdown;
        }

        public void setAt(AtDTO at) {
            this.at = at;
        }

        public void setText(TextDTO text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DingTalkWebHookDto)) {
                return false;
            }
            DingTalkWebHookDto other = (DingTalkWebHookDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msgType = this.getMsgType();
            String other$msgType = other.getMsgType();
            if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
                return false;
            }
            MarkdownDTO this$markdown = this.getMarkdown();
            MarkdownDTO other$markdown = other.getMarkdown();
            if (this$markdown == null ? other$markdown != null : !((Object)this$markdown).equals(other$markdown)) {
                return false;
            }
            AtDTO this$at = this.getAt();
            AtDTO other$at = other.getAt();
            if (this$at == null ? other$at != null : !((Object)this$at).equals(other$at)) {
                return false;
            }
            TextDTO this$text = this.getText();
            TextDTO other$text = other.getText();
            return !(this$text == null ? other$text != null : !((Object)this$text).equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DingTalkWebHookDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msgType = this.getMsgType();
            result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
            MarkdownDTO $markdown = this.getMarkdown();
            result = result * 59 + ($markdown == null ? 43 : ((Object)$markdown).hashCode());
            AtDTO $at = this.getAt();
            result = result * 59 + ($at == null ? 43 : ((Object)$at).hashCode());
            TextDTO $text = this.getText();
            result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
            return result;
        }

        public String toString() {
            return "DingTalkRobotAlertNotifyHandlerImpl.DingTalkWebHookDto(msgType=" + this.getMsgType() + ", markdown=" + this.getMarkdown() + ", at=" + this.getAt() + ", text=" + this.getText() + ")";
        }

        private static class MarkdownDTO {
            private String text;
            private String title;

            public String getText() {
                return this.text;
            }

            public String getTitle() {
                return this.title;
            }

            public void setText(String text) {
                this.text = text;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MarkdownDTO)) {
                    return false;
                }
                MarkdownDTO other = (MarkdownDTO)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$text = this.getText();
                String other$text = other.getText();
                if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                    return false;
                }
                String this$title = this.getTitle();
                String other$title = other.getTitle();
                return !(this$title == null ? other$title != null : !this$title.equals(other$title));
            }

            protected boolean canEqual(Object other) {
                return other instanceof MarkdownDTO;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $text = this.getText();
                result = result * 59 + ($text == null ? 43 : $text.hashCode());
                String $title = this.getTitle();
                result = result * 59 + ($title == null ? 43 : $title.hashCode());
                return result;
            }

            public String toString() {
                return "DingTalkRobotAlertNotifyHandlerImpl.DingTalkWebHookDto.MarkdownDTO(text=" + this.getText() + ", title=" + this.getTitle() + ")";
            }
        }

        private static class AtDTO {
            private Boolean isAtAll;
            private List<String> atUserIds;
            private List<String> atMobiles;

            public Boolean getIsAtAll() {
                return this.isAtAll;
            }

            public List<String> getAtUserIds() {
                return this.atUserIds;
            }

            public List<String> getAtMobiles() {
                return this.atMobiles;
            }

            public void setIsAtAll(Boolean isAtAll) {
                this.isAtAll = isAtAll;
            }

            public void setAtUserIds(List<String> atUserIds) {
                this.atUserIds = atUserIds;
            }

            public void setAtMobiles(List<String> atMobiles) {
                this.atMobiles = atMobiles;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AtDTO)) {
                    return false;
                }
                AtDTO other = (AtDTO)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$isAtAll = this.getIsAtAll();
                Boolean other$isAtAll = other.getIsAtAll();
                if (this$isAtAll == null ? other$isAtAll != null : !((Object)this$isAtAll).equals(other$isAtAll)) {
                    return false;
                }
                List<String> this$atUserIds = this.getAtUserIds();
                List<String> other$atUserIds = other.getAtUserIds();
                if (this$atUserIds == null ? other$atUserIds != null : !((Object)this$atUserIds).equals(other$atUserIds)) {
                    return false;
                }
                List<String> this$atMobiles = this.getAtMobiles();
                List<String> other$atMobiles = other.getAtMobiles();
                return !(this$atMobiles == null ? other$atMobiles != null : !((Object)this$atMobiles).equals(other$atMobiles));
            }

            protected boolean canEqual(Object other) {
                return other instanceof AtDTO;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $isAtAll = this.getIsAtAll();
                result = result * 59 + ($isAtAll == null ? 43 : ((Object)$isAtAll).hashCode());
                List<String> $atUserIds = this.getAtUserIds();
                result = result * 59 + ($atUserIds == null ? 43 : ((Object)$atUserIds).hashCode());
                List<String> $atMobiles = this.getAtMobiles();
                result = result * 59 + ($atMobiles == null ? 43 : ((Object)$atMobiles).hashCode());
                return result;
            }

            public String toString() {
                return "DingTalkRobotAlertNotifyHandlerImpl.DingTalkWebHookDto.AtDTO(isAtAll=" + this.getIsAtAll() + ", atUserIds=" + this.getAtUserIds() + ", atMobiles=" + this.getAtMobiles() + ")";
            }
        }

        private static class TextDTO {
            private String content;

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TextDTO)) {
                    return false;
                }
                TextDTO other = (TextDTO)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$content = this.getContent();
                String other$content = other.getContent();
                return !(this$content == null ? other$content != null : !this$content.equals(other$content));
            }

            protected boolean canEqual(Object other) {
                return other instanceof TextDTO;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $content = this.getContent();
                result = result * 59 + ($content == null ? 43 : $content.hashCode());
                return result;
            }

            public String toString() {
                return "DingTalkRobotAlertNotifyHandlerImpl.DingTalkWebHookDto.TextDTO(content=" + this.getContent() + ")";
            }
        }
    }
}

