/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.util;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TimeExpressionUtil {
    private static final Map<String, Function<LocalDateTime, String>> FORMATTER = new LinkedHashMap<String, Function<LocalDateTime, String>>();
    private static final Map<Character, TemporalUnit> UNIT_MAP = new HashMap<Character, TemporalUnit>();
    private static final String FORMATTER_NAMES;
    private static final String UNIT_NAMES;

    private TimeExpressionUtil() {
    }

    public static String calculate(String template) {
        return TimeExpressionUtil.calculate(template, LocalDateTime.now());
    }

    public static String calculate(String template, LocalDateTime now) {
        if (StringUtils.isBlank(template)) {
            return template;
        }
        String regex = "\\$\\{(@(" + FORMATTER_NAMES + ")(\\s*[-+]\\s*\\d+[" + UNIT_NAMES + "])*)}";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(template);
        while (matcher.find()) {
            String part = matcher.group(0);
            String expression = matcher.group(1);
            template = template.replace(part, TimeExpressionUtil.calculateExpression(expression, now));
        }
        return template;
    }

    private static String calculateExpression(String expression, LocalDateTime now) {
        expression = expression.replaceAll("\\s", "");
        String regex = "(@(" + FORMATTER_NAMES + "))|([-+]\\d+[" + UNIT_NAMES + "])";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(expression);
        ArrayList<String> elements = new ArrayList<String>();
        while (matcher.find()) {
            elements.add(matcher.group(0));
        }
        LocalDateTime result = now;
        for (int i = 1; i < elements.size(); ++i) {
            String element = (String)elements.get(i);
            int operator = element.charAt(0) == '-' ? -1 : 1;
            int duration = Integer.parseInt(element.substring(1, element.length() - 1));
            char unit = element.charAt(element.length() - 1);
            result = result.plus(operator * duration, UNIT_MAP.get(Character.valueOf(unit)));
        }
        return FORMATTER.get(((String)elements.get(0)).substring(1)).apply(result);
    }

    static {
        FORMATTER.put("now", date -> DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format((TemporalAccessor)date));
        FORMATTER.put("date", date -> DateTimeFormatter.ofPattern("yyyy-MM-dd").format((TemporalAccessor)date));
        FORMATTER.put("timestamp10", date -> String.valueOf(date.toEpochSecond(ZoneOffset.UTC)));
        FORMATTER.put("timestamp", date -> String.valueOf(date.toInstant(ZoneOffset.UTC).toEpochMilli()));
        FORMATTER.put("time", date -> DateTimeFormatter.ofPattern("HH:mm:ss").format((TemporalAccessor)date));
        FORMATTER.put("year", date -> DateTimeFormatter.ofPattern("yyyy").format((TemporalAccessor)date));
        FORMATTER.put("month", date -> DateTimeFormatter.ofPattern("MM").format((TemporalAccessor)date));
        FORMATTER.put("day", date -> DateTimeFormatter.ofPattern("dd").format((TemporalAccessor)date));
        FORMATTER.put("hour", date -> DateTimeFormatter.ofPattern("HH").format((TemporalAccessor)date));
        FORMATTER.put("minute", date -> DateTimeFormatter.ofPattern("mm").format((TemporalAccessor)date));
        FORMATTER.put("millisecond", date -> DateTimeFormatter.ofPattern("SSS").format((TemporalAccessor)date));
        FORMATTER.put("second", date -> DateTimeFormatter.ofPattern("ss").format((TemporalAccessor)date));
        UNIT_MAP.put(Character.valueOf('y'), ChronoUnit.YEARS);
        UNIT_MAP.put(Character.valueOf('M'), ChronoUnit.MONTHS);
        UNIT_MAP.put(Character.valueOf('d'), ChronoUnit.DAYS);
        UNIT_MAP.put(Character.valueOf('H'), ChronoUnit.HOURS);
        UNIT_MAP.put(Character.valueOf('m'), ChronoUnit.MINUTES);
        UNIT_MAP.put(Character.valueOf('s'), ChronoUnit.SECONDS);
        UNIT_MAP.put(Character.valueOf('w'), ChronoUnit.WEEKS);
        FORMATTER_NAMES = String.join((CharSequence)"|", FORMATTER.keySet());
        UNIT_NAMES = UNIT_MAP.keySet().stream().map(String::valueOf).collect(Collectors.joining(""));
    }
}

