/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.util;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.cache.CacheProvider;
import com.jayway.jsonpath.spi.cache.LRUCache;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class JsonPathParser {
    private static final ParseContext PARSER;

    private JsonPathParser() {
    }

    public static List<Object> parseContentWithJsonPath(String content, String jsonPath) {
        if (StringUtils.isAnyEmpty(content, jsonPath)) {
            return Collections.emptyList();
        }
        return (List)PARSER.parse(content).read(jsonPath, new Predicate[0]);
    }

    public static <T> T parseContentWithJsonPath(String content, String jsonPath, TypeRef<T> typeRef) {
        if (StringUtils.isAnyEmpty(content, jsonPath)) {
            return null;
        }
        return PARSER.parse(content).read(jsonPath, typeRef);
    }

    static {
        Configuration conf = Configuration.defaultConfiguration().addOptions(Option.DEFAULT_PATH_LEAF_TO_NULL).addOptions(Option.ALWAYS_RETURN_LIST);
        CacheProvider.setCache(new LRUCache(128));
        PARSER = JsonPath.using(conf);
    }
}

