/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.timer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hertzbeat.collector.dispatch.MetricsTaskDispatch;
import org.apache.hertzbeat.collector.dispatch.timer.Timeout;
import org.apache.hertzbeat.collector.dispatch.timer.TimerTask;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.support.SpringContextHolder;
import org.apache.hertzbeat.common.util.AesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WheelTimerTask
implements TimerTask {
    private static final Logger log = LoggerFactory.getLogger(WheelTimerTask.class);
    private final Job job;
    private final MetricsTaskDispatch metricsTaskDispatch = SpringContextHolder.getBean(MetricsTaskDispatch.class);
    private static final Gson GSON = new Gson();

    public WheelTimerTask(Job job) {
        this.job = job;
        this.initJobMetrics(job);
    }

    private void initJobMetrics(Job job) {
        List<Configmap> config = job.getConfigmap();
        Map<String, Configmap> configmap = config.stream().peek(item -> {
            Object patt2920$temp;
            if (item.getType() == 2 && item.getValue() != null) {
                String decodeValue = AesUtil.aesDecode(String.valueOf(item.getValue()));
                if (decodeValue == null) {
                    log.error("Aes Decode value {} error.", item.getValue());
                }
                item.setValue(decodeValue);
            } else if (item.getValue() != null && (patt2920$temp = item.getValue()) instanceof String) {
                String value = (String)patt2920$temp;
                item.setValue(value.trim());
            }
        }).collect(Collectors.toMap(Configmap::getKey, item -> item, (key1, key2) -> key1));
        List<Metrics> metrics = job.getMetrics();
        ArrayList<Metrics> metricsTmp = new ArrayList<Metrics>(metrics.size());
        for (Metrics metric : metrics) {
            JsonElement jsonElement = GSON.toJsonTree(metric);
            CollectUtil.replaceSmilingPlaceholder(jsonElement, configmap);
            metric = GSON.fromJson(jsonElement, Metrics.class);
            if (job.getApp().equals("push")) {
                CollectUtil.replaceFieldsForPushStyleMonitor(metric, configmap);
            }
            metricsTmp.add(metric);
        }
        job.setMetrics(metricsTmp);
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        this.job.setDispatchTime(System.currentTimeMillis());
        this.metricsTaskDispatch.dispatchMetricsTask(timeout);
    }

    public Job getJob() {
        return this.job;
    }
}

