/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.export;

import org.apache.hertzbeat.collector.dispatch.entrance.internal.CollectJobService;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="netty")
public class NettyDataQueue
implements CommonDataQueue {
    private static final Logger log = LoggerFactory.getLogger(NettyDataQueue.class);
    protected static final String NETTY_DATA_QUEUE_PREFIX = "common.queue";
    private final CollectJobService collectJobService;

    public NettyDataQueue(CollectJobService collectJobService) {
        this.collectJobService = collectJobService;
    }

    @Override
    public void sendAlertsData(Alert alert) {
    }

    @Override
    public Alert pollAlertsData() throws InterruptedException {
        return null;
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() throws InterruptedException {
        return null;
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToPersistentStorage() throws InterruptedException {
        return null;
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToRealTimeStorage() throws InterruptedException {
        return null;
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        this.collectJobService.sendAsyncCollectData(metricsData);
    }
}

