/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.entrance.processor;

import io.netty.channel.ChannelHandlerContext;
import org.apache.hertzbeat.collector.dispatch.timer.TimerDispatch;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.support.SpringContextHolder;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoOfflineProcessor
implements NettyRemotingProcessor {
    private static final Logger log = LoggerFactory.getLogger(GoOfflineProcessor.class);
    private TimerDispatch timerDispatch;

    @Override
    public ClusterMsg.Message handle(ChannelHandlerContext ctx, ClusterMsg.Message message) {
        if (this.timerDispatch == null) {
            this.timerDispatch = SpringContextHolder.getBean(TimerDispatch.class);
        }
        this.timerDispatch.goOffline();
        log.info("receive offline message and handle success");
        message.getMsg();
        if (message.getMsg().contains("Auth Failed")) {
            log.error("[Auth Failed]receive client auth failed message and go offline. {}", (Object)message.getMsg());
            return null;
        }
        return ClusterMsg.Message.newBuilder().setIdentity(message.getIdentity()).setDirection(ClusterMsg.Direction.RESPONSE).setMsg(String.valueOf(0)).build();
    }
}

