/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.entrance.processor;

import io.netty.channel.ChannelHandlerContext;
import org.apache.hertzbeat.collector.dispatch.entrance.CollectServer;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectCyclicDataProcessor
implements NettyRemotingProcessor {
    private static final Logger log = LoggerFactory.getLogger(CollectCyclicDataProcessor.class);
    private final CollectServer collectServer;

    public CollectCyclicDataProcessor(CollectServer collectServer) {
        this.collectServer = collectServer;
    }

    @Override
    public ClusterMsg.Message handle(ChannelHandlerContext ctx, ClusterMsg.Message message) {
        Job job = JsonUtil.fromJson(message.getMsg(), Job.class);
        if (job == null) {
            log.error("collector receive cyclic task job is null");
            return null;
        }
        this.collectServer.getCollectJobService().addAsyncCollectJob(job);
        return null;
    }
}

