/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.entrance.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hertzbeat.collector.dispatch.DispatchProperties;
import org.apache.hertzbeat.collector.dispatch.WorkerPool;
import org.apache.hertzbeat.collector.dispatch.entrance.CollectServer;
import org.apache.hertzbeat.collector.dispatch.entrance.internal.CollectResponseEventListener;
import org.apache.hertzbeat.collector.dispatch.timer.TimerDispatch;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.ProtoJsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CollectJobService {
    private static final Logger log = LoggerFactory.getLogger(CollectJobService.class);
    private static final String COLLECTOR_STR = "-collector";
    private final TimerDispatch timerDispatch;
    private final WorkerPool workerPool;
    private final String collectorIdentity;
    private String mode = null;
    private CollectServer collectServer;

    public CollectJobService(TimerDispatch timerDispatch, DispatchProperties properties, WorkerPool workerPool) {
        this.timerDispatch = timerDispatch;
        this.workerPool = workerPool;
        if (properties != null && properties.getEntrance() != null && properties.getEntrance().getNetty() != null && properties.getEntrance().getNetty().isEnabled()) {
            this.mode = properties.getEntrance().getNetty().getMode();
            String collectorName = properties.getEntrance().getNetty().getIdentity();
            if (StringUtils.hasText(collectorName)) {
                this.collectorIdentity = collectorName;
            } else {
                this.collectorIdentity = IpDomainUtil.getCurrentHostName() + COLLECTOR_STR;
                log.info("user not config this collector identity, use [host name - host ip] default: {}.", (Object)this.collectorIdentity);
            }
        } else {
            this.collectorIdentity = "main-default-collector";
        }
    }

    public List<CollectRep.MetricsData> collectSyncJobData(Job job) {
        final LinkedList<CollectRep.MetricsData> metricsData = new LinkedList<CollectRep.MetricsData>();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        CollectResponseEventListener listener = new CollectResponseEventListener(){

            @Override
            public void response(List<CollectRep.MetricsData> responseMetrics) {
                if (responseMetrics != null) {
                    metricsData.addAll(responseMetrics);
                }
                countDownLatch.countDown();
            }
        };
        this.timerDispatch.addJob(job, listener);
        try {
            countDownLatch.await(120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.info("The sync task runs for 120 seconds with no response and returns");
        }
        return metricsData;
    }

    public void collectSyncOneTimeJobData(Job oneTimeJob) {
        this.workerPool.executeJob(() -> {
            List<CollectRep.MetricsData> metricsDataList = this.collectSyncJobData(oneTimeJob);
            ArrayList<String> jsons = new ArrayList<String>(metricsDataList.size());
            for (CollectRep.MetricsData metricsData : metricsDataList) {
                String json = ProtoJsonUtil.toJsonStr(metricsData);
                if (json == null) continue;
                jsons.add(json);
            }
            String response = JsonUtil.toJson(jsons);
            ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setMsg(response).setDirection(ClusterMsg.Direction.REQUEST).setType(ClusterMsg.MessageType.RESPONSE_ONE_TIME_TASK_DATA).build();
            this.collectServer.sendMsg(message);
        });
    }

    public void addAsyncCollectJob(Job job) {
        this.timerDispatch.addJob(job.clone(), null);
    }

    public void cancelAsyncCollectJob(Long jobId) {
        if (jobId != null) {
            this.timerDispatch.deleteJob(jobId, true);
        }
    }

    public void sendAsyncCollectData(CollectRep.MetricsData metricsData) {
        String data = ProtoJsonUtil.toJsonStr(metricsData);
        ClusterMsg.Message message = ClusterMsg.Message.newBuilder().setIdentity(this.collectorIdentity).setMsg(data).setDirection(ClusterMsg.Direction.REQUEST).setType(ClusterMsg.MessageType.RESPONSE_CYCLIC_TASK_DATA).build();
        this.collectServer.sendMsg(message);
    }

    public String getCollectorIdentity() {
        return this.collectorIdentity;
    }

    public String getCollectorMode() {
        return this.mode;
    }

    public void setCollectServer(CollectServer collectServer) {
        this.collectServer = collectServer;
    }
}

