/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.redfish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.cache.CacheIdentifier;
import org.apache.hertzbeat.collector.collect.common.cache.ConnectionCommonCache;
import org.apache.hertzbeat.collector.collect.common.cache.RedfishConnect;
import org.apache.hertzbeat.collector.collect.redfish.ConnectSession;
import org.apache.hertzbeat.collector.collect.redfish.RedfishClient;
import org.apache.hertzbeat.collector.collect.redfish.RedfishCollectionSchema;
import org.apache.hertzbeat.collector.util.JsonPathParser;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.RedfishProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedfishCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(RedfishCollectImpl.class);
    private final ConnectionCommonCache<CacheIdentifier, RedfishConnect> connectionCommonCache = new ConnectionCommonCache();

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getRedfish() == null) {
            throw new IllegalArgumentException("Redfish collect must has redfish params");
        }
        RedfishProtocol redfishProtocol = metrics.getRedfish();
        Assert.hasText(redfishProtocol.getHost(), "Redfish Protocol host is required.");
        Assert.hasText(redfishProtocol.getPort(), "Redfish Protocol port is required.");
        Assert.hasText(redfishProtocol.getUsername(), "Redfish Protocol username is required.");
        Assert.hasText(redfishProtocol.getPassword(), "Redfish Protocol password is required.");
    }

    @Override
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        ConnectSession connectSession = null;
        try {
            connectSession = this.getRedfishConnectSession(metrics.getRedfish());
        }
        catch (Exception e) {
            log.error("Redfish session create error: {}", (Object)e.getMessage());
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(e.getMessage());
            return;
        }
        List<String> resourcesUri = this.getResourcesUri(metrics, connectSession);
        if (resourcesUri == null || resourcesUri.isEmpty()) {
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("Get redfish resources uri error");
            return;
        }
        for (String uri : resourcesUri) {
            String resp = null;
            try {
                resp = connectSession.getRedfishResource(uri);
            }
            catch (Exception e) {
                log.error("Get redfish {} detail resource error: {}", (Object)uri, (Object)e.getMessage());
                continue;
            }
            this.parseRedfishResource(builder, resp, metrics);
        }
    }

    private ConnectSession getRedfishConnectSession(RedfishProtocol redfishProtocol) throws Exception {
        RedfishConnect redfishConnect;
        CacheIdentifier identifier = CacheIdentifier.builder().ip(redfishProtocol.getHost()).port(redfishProtocol.getPort()).password(redfishProtocol.getPassword()).username(redfishProtocol.getUsername()).build();
        ConnectSession redfishConnectSession = null;
        Optional<RedfishConnect> cacheOption = this.connectionCommonCache.getCache(identifier, true);
        if (cacheOption.isPresent() && ((redfishConnectSession = (redfishConnect = cacheOption.get()).getConnection()) == null || !redfishConnectSession.isOpen())) {
            redfishConnectSession = null;
            this.connectionCommonCache.removeCache(identifier);
        }
        if (redfishConnectSession != null) {
            return redfishConnectSession;
        }
        RedfishClient redfishClient = RedfishClient.create(redfishProtocol);
        redfishConnectSession = redfishClient.connect();
        this.connectionCommonCache.addCache(identifier, new RedfishConnect(redfishConnectSession));
        return redfishConnectSession;
    }

    @Override
    public String supportProtocol() {
        return "redfish";
    }

    private List<String> getResourcesUri(Metrics metrics, ConnectSession connectSession) {
        String schema;
        String name = metrics.getName();
        String collectionSchema = metrics.getRedfish().getSchema();
        String string = schema = collectionSchema != null ? collectionSchema : RedfishCollectionSchema.getSchema(name);
        if (!StringUtils.hasText(schema)) {
            return null;
        }
        String pattern = "\\{\\w+\\}";
        Pattern r = Pattern.compile(pattern);
        String[] fragment = r.split(schema);
        List<String> res = new ArrayList<String>();
        for (String value : fragment) {
            ArrayList<String> temp = new ArrayList<String>();
            if (res.isEmpty()) {
                res.add(value);
            } else {
                res = res.stream().map(s -> s + value).collect(Collectors.toList());
            }
            for (String s2 : res) {
                List<String> t = this.getCollectionResource(s2, connectSession);
                temp.addAll(t);
            }
            res.clear();
            res.addAll(temp);
        }
        return res;
    }

    private List<String> parseCollectionResource(String resp) {
        if (!StringUtils.hasText(resp)) {
            return Collections.emptyList();
        }
        String resourceIdPath = "$.Members[*].['@odata.id']";
        List<Object> resourceIds = JsonPathParser.parseContentWithJsonPath(resp, resourceIdPath);
        List<String> res = resourceIds.stream().filter(Objects::nonNull).map(String::valueOf).toList();
        return res;
    }

    private List<String> getCollectionResource(String uri, ConnectSession connectSession) {
        String resp = null;
        try {
            resp = connectSession.getRedfishResource(uri);
        }
        catch (Exception e) {
            log.error("Get redfish {} collection resource error: {}", (Object)uri, (Object)e.getMessage());
            return Collections.emptyList();
        }
        return this.parseCollectionResource(resp);
    }

    private void parseRedfishResource(CollectRep.MetricsData.Builder builder, String resp, Metrics metrics) {
        if (!StringUtils.hasText(resp)) {
            return;
        }
        List<String> aliasFields = metrics.getAliasFields();
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String alias : aliasFields) {
            List<Object> res = JsonPathParser.parseContentWithJsonPath(resp, alias);
            if (res != null && !res.isEmpty()) {
                Object value = res.get(0);
                valueRowBuilder.addColumns(value == null ? "&nbsp;" : String.valueOf(value));
                continue;
            }
            valueRowBuilder.addColumns("&nbsp;");
        }
        builder.addValues(valueRowBuilder.build());
    }
}

