/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.nginx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.NginxProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NginxCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(NginxCollectImpl.class);
    private static final int SUCCESS_CODE = 200;
    private static final String NGINX_STATUS_NAME = "nginx_status";
    private static final String REQ_STATUS_NAME = "req_status";
    private static final String AVAILABLE = "available";
    private static final String CONNECTIONS = "connections";
    private static final String ACTIVE = "active";
    private static final String GET = "get";
    private static final String FIELD_SPLIT = "_";
    private static final String REGEX_KEYS = "server\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)";
    private static final String REGEX_VALUES = "(\\d+) (\\d+) (\\d+)";
    private static final String REGEX_SERVER = "(\\w+): (\\d+)";
    private static final String REGEX_SPLIT = "\\r?\\n";
    private static final String REGEX_LINE_SPLIT = "\\s+";

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        NginxProtocol nginxProtocol;
        if (metrics == null || (nginxProtocol = metrics.getNginx()) == null || nginxProtocol.isInValid()) {
            throw new IllegalArgumentException("Nginx collect must has nginx params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        NginxProtocol nginxProtocol = metrics.getNginx();
        String url = nginxProtocol.getUrl();
        if (StringUtils.isEmpty(url) || !url.startsWith("/")) {
            nginxProtocol.setUrl((String)(url == null ? "/" : "/" + url.trim()));
        }
        HttpContext httpContext = this.createHttpContext(metrics.getNginx());
        HttpUriRequest request = this.createHttpRequest(metrics.getNginx());
        try (CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request, httpContext);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("StatusCode " + statusCode);
                return;
            }
            String resp = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            Long responseTime = System.currentTimeMillis() - startTime;
            if (StringUtils.equalsAny(metrics.getName(), NGINX_STATUS_NAME, AVAILABLE)) {
                this.parseNginxStatusResponse(builder, resp, metrics, responseTime);
            } else if (REQ_STATUS_NAME.equals(metrics.getName())) {
                this.parseReqStatusResponse(builder, resp, metrics, responseTime);
            }
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable(e);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (request != null) {
                request.abort();
            }
        }
    }

    @Override
    public String supportProtocol() {
        return "nginx";
    }

    private HttpContext createHttpContext(NginxProtocol nginxProtocol) {
        HttpHost host = new HttpHost(nginxProtocol.getHost(), Integer.parseInt(nginxProtocol.getPort()));
        HttpClientContext httpClientContext = new HttpClientContext();
        httpClientContext.setTargetHost(host);
        return httpClientContext;
    }

    private HttpUriRequest createHttpRequest(NginxProtocol nginxProtocol) {
        RequestBuilder requestBuilder = RequestBuilder.get();
        String portWithUri = nginxProtocol.getPort() + CollectUtil.replaceUriSpecialChar(nginxProtocol.getUrl());
        String host = nginxProtocol.getHost();
        if (IpDomainUtil.isHasSchema(host)) {
            requestBuilder.setUri(host + ":" + portWithUri);
        } else {
            String ipAddressType = IpDomainUtil.checkIpAddressType(host);
            String baseUri = "ipv6".equals(ipAddressType) ? String.format("[%s]:%s", host, portWithUri) : String.format("%s:%s", host, portWithUri);
            requestBuilder.setUri("http://" + baseUri);
        }
        requestBuilder.addHeader("Connection", "keep-alive");
        requestBuilder.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.76 Safari/537.36");
        requestBuilder.addHeader("Accept", "text/plain");
        int timeout = Integer.parseInt(nginxProtocol.getTimeout());
        if (timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        }
        return requestBuilder.build();
    }

    private void parseNginxStatusResponse(CollectRep.MetricsData.Builder builder, String resp, Metrics metrics, Long responseTime) {
        List<String> aliasFields = metrics.getAliasFields();
        Map<String, Object> metricMap = this.regexNginxStatusMatch(resp, metrics.getAliasFields().size());
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String alias : aliasFields) {
            Object value = metricMap.get(alias);
            if (value != null) {
                valueRowBuilder.addColumns(String.valueOf(value));
                continue;
            }
            if ("responseTime".equalsIgnoreCase(alias)) {
                valueRowBuilder.addColumns(responseTime.toString());
                continue;
            }
            valueRowBuilder.addColumns("&nbsp;");
        }
        builder.addValues(valueRowBuilder.build());
    }

    private void parseReqStatusResponse(CollectRep.MetricsData.Builder builder, String resp, Metrics metrics, Long responseTime) {
        List<ReqStatusResponse> reqStatusResponses = this.regexReqStatusMatch(resp);
        List<String> aliasFields = metrics.getAliasFields();
        for (ReqStatusResponse reqStatusResponse : reqStatusResponses) {
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : aliasFields) {
                if ("responseTime".equals(alias)) {
                    valueRowBuilder.addColumns(String.valueOf(responseTime));
                    continue;
                }
                try {
                    String methodName = reqStatusResponse.getFieldMethodName(alias);
                    Object value = this.reflect(reqStatusResponse, methodName);
                    value = value == null ? "&nbsp;" : value;
                    valueRowBuilder.addColumns(String.valueOf(value));
                }
                catch (Exception e) {
                    String errorMsg = CommonUtil.getMessageFromThrowable(e);
                    log.error(errorMsg);
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg(errorMsg);
                }
            }
            builder.addValues(valueRowBuilder.build());
        }
    }

    private Object reflect(ReqStatusResponse reqStatusResponse, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = reqStatusResponse.getClass();
        Method method = clazz.getMethod(methodName, new Class[0]);
        return method.invoke((Object)reqStatusResponse, new Object[0]);
    }

    private Map<String, Object> regexNginxStatusMatch(String resp, Integer aliasFieldsSize) {
        HashMap<String, Object> metricsMap = new HashMap<String, Object>(aliasFieldsSize);
        Pattern pattern = Pattern.compile(REGEX_SERVER);
        Matcher matcher = pattern.matcher(resp);
        while (matcher.find()) {
            String key = StringUtils.lowerCase(matcher.group(1));
            String value = matcher.group(2);
            metricsMap.put(CONNECTIONS.equals(key) ? ACTIVE : key, value);
        }
        Pattern pattern1 = Pattern.compile(REGEX_KEYS);
        Matcher matcher1 = pattern1.matcher(resp);
        Pattern pattern2 = Pattern.compile(REGEX_VALUES);
        Matcher matcher2 = pattern2.matcher(resp);
        if (matcher1.find() && matcher2.find()) {
            for (int i = 0; i < matcher1.groupCount(); ++i) {
                metricsMap.put(matcher1.group(i + 1), matcher2.group(i + 1));
            }
        }
        return metricsMap;
    }

    private List<ReqStatusResponse> regexReqStatusMatch(String resp) {
        ArrayList<ReqStatusResponse> reqStatusResponses = new ArrayList<ReqStatusResponse>();
        String[] lines = resp.split(REGEX_SPLIT);
        for (int i = 1; i < lines.length; ++i) {
            String[] values = lines[i].split(REGEX_LINE_SPLIT);
            ReqStatusResponse reqStatusResponse = ReqStatusResponse.builder().zoneName(values[0]).key(values[1]).maxActive(values[2]).maxBw(values[3]).traffic(values[4]).requests(values[5]).active(values[6]).bandwidth(values[7]).build();
            reqStatusResponses.add(reqStatusResponse);
        }
        return reqStatusResponses;
    }

    static class ReqStatusResponse {
        private String zoneName;
        private String maxActive;
        private String key;
        private String maxBw;
        private String traffic;
        private String requests;
        private String active;
        private String bandwidth;

        public String getFieldMethodName(String name) {
            String[] words = name.split(NginxCollectImpl.FIELD_SPLIT);
            StringBuilder result = new StringBuilder();
            for (String word : words) {
                result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
            }
            return NginxCollectImpl.GET + result;
        }

        public static ReqStatusResponseBuilder builder() {
            return new ReqStatusResponseBuilder();
        }

        public String getZoneName() {
            return this.zoneName;
        }

        public String getMaxActive() {
            return this.maxActive;
        }

        public String getKey() {
            return this.key;
        }

        public String getMaxBw() {
            return this.maxBw;
        }

        public String getTraffic() {
            return this.traffic;
        }

        public String getRequests() {
            return this.requests;
        }

        public String getActive() {
            return this.active;
        }

        public String getBandwidth() {
            return this.bandwidth;
        }

        public void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public void setMaxActive(String maxActive) {
            this.maxActive = maxActive;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setMaxBw(String maxBw) {
            this.maxBw = maxBw;
        }

        public void setTraffic(String traffic) {
            this.traffic = traffic;
        }

        public void setRequests(String requests) {
            this.requests = requests;
        }

        public void setActive(String active) {
            this.active = active;
        }

        public void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReqStatusResponse)) {
                return false;
            }
            ReqStatusResponse other = (ReqStatusResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$zoneName = this.getZoneName();
            String other$zoneName = other.getZoneName();
            if (this$zoneName == null ? other$zoneName != null : !this$zoneName.equals(other$zoneName)) {
                return false;
            }
            String this$maxActive = this.getMaxActive();
            String other$maxActive = other.getMaxActive();
            if (this$maxActive == null ? other$maxActive != null : !this$maxActive.equals(other$maxActive)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$maxBw = this.getMaxBw();
            String other$maxBw = other.getMaxBw();
            if (this$maxBw == null ? other$maxBw != null : !this$maxBw.equals(other$maxBw)) {
                return false;
            }
            String this$traffic = this.getTraffic();
            String other$traffic = other.getTraffic();
            if (this$traffic == null ? other$traffic != null : !this$traffic.equals(other$traffic)) {
                return false;
            }
            String this$requests = this.getRequests();
            String other$requests = other.getRequests();
            if (this$requests == null ? other$requests != null : !this$requests.equals(other$requests)) {
                return false;
            }
            String this$active = this.getActive();
            String other$active = other.getActive();
            if (this$active == null ? other$active != null : !this$active.equals(other$active)) {
                return false;
            }
            String this$bandwidth = this.getBandwidth();
            String other$bandwidth = other.getBandwidth();
            return !(this$bandwidth == null ? other$bandwidth != null : !this$bandwidth.equals(other$bandwidth));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReqStatusResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $zoneName = this.getZoneName();
            result = result * 59 + ($zoneName == null ? 43 : $zoneName.hashCode());
            String $maxActive = this.getMaxActive();
            result = result * 59 + ($maxActive == null ? 43 : $maxActive.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $maxBw = this.getMaxBw();
            result = result * 59 + ($maxBw == null ? 43 : $maxBw.hashCode());
            String $traffic = this.getTraffic();
            result = result * 59 + ($traffic == null ? 43 : $traffic.hashCode());
            String $requests = this.getRequests();
            result = result * 59 + ($requests == null ? 43 : $requests.hashCode());
            String $active = this.getActive();
            result = result * 59 + ($active == null ? 43 : $active.hashCode());
            String $bandwidth = this.getBandwidth();
            result = result * 59 + ($bandwidth == null ? 43 : $bandwidth.hashCode());
            return result;
        }

        public String toString() {
            return "NginxCollectImpl.ReqStatusResponse(zoneName=" + this.getZoneName() + ", maxActive=" + this.getMaxActive() + ", key=" + this.getKey() + ", maxBw=" + this.getMaxBw() + ", traffic=" + this.getTraffic() + ", requests=" + this.getRequests() + ", active=" + this.getActive() + ", bandwidth=" + this.getBandwidth() + ")";
        }

        public ReqStatusResponse(String zoneName, String maxActive, String key, String maxBw, String traffic, String requests, String active, String bandwidth) {
            this.zoneName = zoneName;
            this.maxActive = maxActive;
            this.key = key;
            this.maxBw = maxBw;
            this.traffic = traffic;
            this.requests = requests;
            this.active = active;
            this.bandwidth = bandwidth;
        }

        public ReqStatusResponse() {
        }

        public static class ReqStatusResponseBuilder {
            private String zoneName;
            private String maxActive;
            private String key;
            private String maxBw;
            private String traffic;
            private String requests;
            private String active;
            private String bandwidth;

            ReqStatusResponseBuilder() {
            }

            public ReqStatusResponseBuilder zoneName(String zoneName) {
                this.zoneName = zoneName;
                return this;
            }

            public ReqStatusResponseBuilder maxActive(String maxActive) {
                this.maxActive = maxActive;
                return this;
            }

            public ReqStatusResponseBuilder key(String key) {
                this.key = key;
                return this;
            }

            public ReqStatusResponseBuilder maxBw(String maxBw) {
                this.maxBw = maxBw;
                return this;
            }

            public ReqStatusResponseBuilder traffic(String traffic) {
                this.traffic = traffic;
                return this;
            }

            public ReqStatusResponseBuilder requests(String requests) {
                this.requests = requests;
                return this;
            }

            public ReqStatusResponseBuilder active(String active) {
                this.active = active;
                return this;
            }

            public ReqStatusResponseBuilder bandwidth(String bandwidth) {
                this.bandwidth = bandwidth;
                return this;
            }

            public ReqStatusResponse build() {
                return new ReqStatusResponse(this.zoneName, this.maxActive, this.key, this.maxBw, this.traffic, this.requests, this.active, this.bandwidth);
            }

            public String toString() {
                return "NginxCollectImpl.ReqStatusResponse.ReqStatusResponseBuilder(zoneName=" + this.zoneName + ", maxActive=" + this.maxActive + ", key=" + this.key + ", maxBw=" + this.maxBw + ", traffic=" + this.traffic + ", requests=" + this.requests + ", active=" + this.active + ", bandwidth=" + this.bandwidth + ")";
            }
        }
    }
}

