/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.nebulagraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.nebulagraph.NebulaTemplate;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.NgqlProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

public class NgqlCollectImpl
extends AbstractCollect {
    private static final String PARSE_TYPE_FILTER_COUNT = "filterCount";
    private static final String PARSE_TYPE_ONE_ROW = "oneRow";
    private static final String PARSE_TYPE_MULTI_ROW = "multiRow";
    private static final String PARSE_TYPE_COLUMNS = "columns";
    private static final String STATUS_RUNNING = "RUNNING";
    private static final String STATUS_QUEUE = "QUEUE";
    private static final String COMMAND_SHOW_JOBS = "SHOW JOBS;";

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        NgqlProtocol ngql = metrics.getNgql();
        Assert.hasText(ngql.getHost(), "NGQL protocol host is required");
        Assert.hasText(ngql.getPort(), "Port protocol host is required");
        Assert.hasText(ngql.getParseType(), "NGQL protocol parseType is required");
        Assert.hasText(ngql.getUsername(), "NGQL protocol username is required");
        Assert.hasText(ngql.getPassword(), "NGQL protocol password is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        NgqlProtocol ngql = metrics.getNgql();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        NebulaTemplate nebulaTemplate = new NebulaTemplate();
        try {
            boolean initSuccess = nebulaTemplate.initSession(ngql);
            if (!initSuccess) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("Failed to connect Nebula Graph");
                return;
            }
        }
        catch (Exception e) {
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(e.getMessage());
            return;
        }
        stopWatch.stop();
        long responseTime = stopWatch.getTotalTimeMillis();
        try {
            switch (ngql.getParseType()) {
                case "filterCount": {
                    this.filterCount(nebulaTemplate, ngql, metrics.getAliasFields(), builder, responseTime);
                    return;
                }
                case "oneRow": {
                    this.queryOneRow(nebulaTemplate, ngql, metrics.getAliasFields(), builder, responseTime);
                    return;
                }
                case "multiRow": {
                    this.queryMultiRow(nebulaTemplate, ngql.getCommands(), metrics.getAliasFields(), builder, responseTime);
                    return;
                }
                case "columns": {
                    this.queryColumns(nebulaTemplate, ngql.getCommands(), metrics.getAliasFields(), builder, responseTime);
                    return;
                }
            }
            return;
        }
        finally {
            nebulaTemplate.closeSessionAndPool();
        }
    }

    private void filterCount(NebulaTemplate nebulaTemplate, NgqlProtocol protocol, List<String> columns, CollectRep.MetricsData.Builder builder, Long responseTime) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (String command : protocol.getCommands()) {
            Map<String, String> showJobs = this.showJobs(nebulaTemplate, protocol.getSpaceName(), command);
            if (Objects.nonNull(showJobs)) {
                data.putAll(showJobs);
                continue;
            }
            String[] parts = command.split("#", -1);
            if (parts.length != 4) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("The command:[" + command + "] does not meet the requirements");
            }
            String fieldName = parts[0];
            String ngql = parts[1];
            String filterName = parts[2];
            String filterValue = parts[3];
            try {
                List<Map<String, Object>> maps = nebulaTemplate.executeCommand(ngql);
                Stream<Object> stream = maps.stream();
                if (StringUtils.isNotBlank(filterName)) {
                    stream = stream.filter(map -> Objects.equals(map.get(filterName), filterValue));
                }
                long count = stream.count();
                data.put(fieldName, Long.toString(count));
            }
            catch (Exception e) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("Query error:[" + ngql + "],Msg:[" + e.getMessage() + "]");
            }
        }
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String column : columns) {
            if ("responseTime".equals(column)) {
                valueRowBuilder.addColumns(String.valueOf(responseTime));
                continue;
            }
            String value = (String)data.get(column);
            value = value == null ? "&nbsp;" : value;
            valueRowBuilder.addColumns(value);
        }
        builder.addValues(valueRowBuilder.build());
    }

    private void queryOneRow(NebulaTemplate nebulaTemplate, NgqlProtocol protocol, List<String> columns, CollectRep.MetricsData.Builder builder, Long responseTime) {
        HashMap<String, Object> queryResult = new HashMap<String, Object>();
        for (String command : protocol.getCommands()) {
            Map<String, String> showJobs = this.showJobs(nebulaTemplate, protocol.getSpaceName(), command);
            if (Objects.nonNull(showJobs)) {
                queryResult.putAll(showJobs);
                continue;
            }
            List<Map<String, Object>> maps = nebulaTemplate.executeCommand(command);
            if (maps.isEmpty()) continue;
            queryResult.putAll(maps.get(0));
        }
        this.inflateData(columns, responseTime, queryResult, builder);
    }

    private void queryMultiRow(NebulaTemplate nebulaTemplate, List<String> commands, List<String> columns, CollectRep.MetricsData.Builder builder, Long responseTime) {
        String command = commands.get(0);
        try {
            List<Map<String, Object>> result = nebulaTemplate.executeCommand(command);
            for (Map<String, Object> row : result) {
                this.inflateData(columns, responseTime, row, builder);
            }
        }
        catch (Exception e) {
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("Query error:[" + command + "],Msg:[" + e.getMessage() + "]");
        }
    }

    private void queryColumns(NebulaTemplate nebulaTemplate, List<String> commands, List<String> columns, CollectRep.MetricsData.Builder builder, Long responseTime) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String command : commands) {
            try {
                List<Map<String, Object>> result = nebulaTemplate.executeCommand(command);
                if (!result.isEmpty() && result.get(0).size() < 2) {
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg("Parsing type columns requires the result set to contain at least two columns");
                    return;
                }
                for (Map<String, Object> map : result) {
                    List data = map.entrySet().stream().limit(2L).toList();
                    resultMap.put(Objects.toString(((Map.Entry)data.get(0)).getValue()), ((Map.Entry)data.get(1)).getValue());
                }
            }
            catch (Exception e) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("Query error:[" + command + "],Msg:[" + e.getMessage() + "]");
            }
        }
        this.inflateData(columns, responseTime, resultMap, builder);
    }

    private void inflateData(List<String> columns, Long responseTime, Map<String, Object> dataFromDb, CollectRep.MetricsData.Builder builder) {
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String column : columns) {
            if ("responseTime".equals(column)) {
                valueRowBuilder.addColumns(String.valueOf(responseTime));
                continue;
            }
            Object value = dataFromDb.get(column);
            value = value == null ? "&nbsp;" : value;
            valueRowBuilder.addColumns(Objects.toString(value));
        }
        builder.addValues(valueRowBuilder.build());
    }

    @Override
    public String supportProtocol() {
        return "ngql";
    }

    private Map<String, String> showJobs(NebulaTemplate template, String protocolSpaceName, String command) {
        if (!command.equalsIgnoreCase(COMMAND_SHOW_JOBS)) {
            return null;
        }
        ArrayList<String> spaceNames = new ArrayList<String>();
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<Map<String, Object>> jobs = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank(protocolSpaceName)) {
            spaceNames.add(protocolSpaceName);
        } else {
            List<Map<String, Object>> spaces = template.executeCommand("SHOW SPACES;");
            if (spaces.isEmpty()) {
                return result;
            }
            List<String> allSpace = spaces.stream().map(s -> s.get("Name")).filter(Objects::nonNull).map(Objects::toString).toList();
            spaceNames.addAll(allSpace);
        }
        for (String name : spaceNames) {
            jobs.addAll(template.executeCommand(COMMAND_SHOW_JOBS, name));
        }
        result.put("queue_jobs", String.valueOf(jobs.stream().filter(job -> Objects.equals(job.get("Status"), STATUS_QUEUE)).count()));
        result.put("running_jobs", String.valueOf(jobs.stream().filter(job -> Objects.equals(job.get("Status"), STATUS_RUNNING)).count()));
        return result;
    }
}

