/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.nebulagraph;

import com.vesoft.nebula.client.graph.NebulaPoolConfig;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.NebulaPool;
import com.vesoft.nebula.client.graph.net.Session;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.job.protocol.NgqlProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaTemplate {
    private static final Logger log = LoggerFactory.getLogger(NebulaTemplate.class);
    private String spaceName;
    private Session session;
    NebulaPool pool;

    public void closeSessionAndPool() {
        if (this.session != null && this.session.ping()) {
            this.session.close();
        }
        if (this.pool != null) {
            this.pool.close();
        }
    }

    public boolean initSession(NgqlProtocol protocol) {
        HostAddress hostAddress = new HostAddress(protocol.getHost(), Integer.parseInt(protocol.getPort()));
        this.spaceName = protocol.getSpaceName();
        this.pool = new NebulaPool();
        NebulaPoolConfig nebulaPoolConfig = new NebulaPoolConfig();
        nebulaPoolConfig.setMaxConnSize(100);
        nebulaPoolConfig.setTimeout(Integer.parseInt(protocol.getTimeout()));
        boolean initResult = this.pool.init(Collections.singletonList(hostAddress), nebulaPoolConfig);
        if (!initResult) {
            log.error("pool init failed.");
            return false;
        }
        this.session = this.pool.getSession(protocol.getUsername(), protocol.getPassword(), false);
        return true;
    }

    private ResultSet execute(String ngql) {
        try {
            ResultSet resultSet = this.session.execute(ngql);
            return resultSet;
        }
        catch (IOErrorException e) {
            log.error("Query error:\u3010{}\u3011,ErrorMsg:\u3010{}\u3011", (Object)ngql, (Object)e.getMessage());
            this.session.close();
            return null;
        }
    }

    public List<Map<String, Object>> executeCommand(String ngql) {
        return this.executeCommand(ngql, this.spaceName);
    }

    public List<Map<String, Object>> executeCommand(String ngql, String currentSpaceName) {
        ResultSet resultSet;
        if (StringUtils.isNotBlank(currentSpaceName)) {
            ngql = "USE " + currentSpaceName + ";" + (String)ngql;
        }
        if ((resultSet = this.execute((String)ngql)) == null) {
            log.error("Query Error result set is null,NGQL:\u3010{}\u3011", ngql);
            return Collections.emptyList();
        }
        List<String> columnNames = resultSet.getColumnNames();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int size = resultSet.getRows().size();
        for (int i = 0; i < size; ++i) {
            result.add(new LinkedHashMap());
        }
        for (String columnName : columnNames) {
            List<ValueWrapper> valueWrappers = resultSet.colValues(columnName);
            for (int i = 0; i < valueWrappers.size(); ++i) {
                ((Map)result.get(i)).put(columnName, this.convert(valueWrappers.get(i)));
            }
        }
        return result;
    }

    private Object convert(ValueWrapper wrapper) {
        if (wrapper.isBoolean()) {
            return wrapper.asBoolean();
        }
        if (wrapper.isString()) {
            return wrapper.asString();
        }
        if (wrapper.isDate()) {
            return wrapper.asDate();
        }
        if (wrapper.isDateTime()) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS").parse(wrapper.asDateTime().getLocalDateTimeStr().replace("T", " "));
        }
        if (wrapper.isLong()) {
            return wrapper.asLong();
        }
        if (wrapper.isDouble()) {
            return wrapper.asDouble();
        }
        if (wrapper.isPath()) {
            return wrapper.asPath().toString();
        }
        if (wrapper.isEdge()) {
            return wrapper.asRelationship().toString();
        }
        if (wrapper.isVertex()) {
            return wrapper.asNode().toString();
        }
        return null;
    }
}

