/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.nebulagraph;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.NebulaGraphProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaGraphCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(NebulaGraphCollectImpl.class);
    private static final int SUCCESS_CODE = 200;
    private static final String[] TIME_RANGE = new String[]{"5", "60", "600", "3600"};
    private static final String REGEX = "\\.%s\\=";
    private static final String STR_SPLIT = "\n";
    private static final String STORAGE_SPLIT_KEY_VALUE = "=";
    private static final String GRAPH_API = "/stats";
    private static final String STORAGE_API = "/rocksdb_stats";

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getNebulaGraph() == null) {
            throw new IllegalArgumentException("NebulaGraph collect must has NebulaGraph params");
        }
    }

    @Override
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        NebulaGraphProtocol nebulaGraph = metrics.getNebulaGraph();
        String timePeriod = nebulaGraph.getTimePeriod();
        if (!Objects.isNull(nebulaGraph.getTimePeriod()) && !Arrays.asList(TIME_RANGE).contains(timePeriod)) {
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("The time range for metric statistics, currently supporting 5 seconds, 60 seconds, 600 seconds, and 3600 seconds.");
            return;
        }
        if (nebulaGraph.getHost() == null || nebulaGraph.getHost().isEmpty()) {
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("The host of NebulaGraph must be set");
            return;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(64);
        HttpContext httpContext = this.createHttpContext(nebulaGraph.getHost(), nebulaGraph.getPort());
        HttpUriRequest request = this.createHttpRequest(nebulaGraph.getHost(), nebulaGraph.getPort(), nebulaGraph.getUrl(), nebulaGraph.getTimeout());
        try {
            CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request, httpContext);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("StatusCode " + statusCode);
                return;
            }
            String resp = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            long responseTime = System.currentTimeMillis() - startTime;
            resultMap.put("responseTime", Long.toString(responseTime));
            if (GRAPH_API.equals(nebulaGraph.getUrl())) {
                this.parseStatsResponse(resp, nebulaGraph.getTimePeriod(), resultMap);
            } else if (STORAGE_API.equals(nebulaGraph.getUrl())) {
                this.parseStorageResponse(resp, resultMap);
            }
            List<String> aliasFields = metrics.getAliasFields();
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String field : aliasFields) {
                String fieldValue = resultMap.get(field);
                valueRowBuilder.addColumns(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
            }
            builder.addValues(valueRowBuilder.build());
        }
        catch (IOException e) {
            String errorMsg = CommonUtil.getMessageFromThrowable(e);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    @Override
    public String supportProtocol() {
        return "nebulaGraph";
    }

    private HttpContext createHttpContext(String host, String port) {
        HttpHost httpHost = new HttpHost(host, Integer.parseInt(port));
        HttpClientContext httpClientContext = new HttpClientContext();
        httpClientContext.setTargetHost(httpHost);
        return httpClientContext;
    }

    private HttpUriRequest createHttpRequest(String host, String port, String url, String timeoutStr) {
        RequestBuilder requestBuilder = RequestBuilder.get();
        String uri = CollectUtil.replaceUriSpecialChar(url);
        if (IpDomainUtil.isHasSchema(host)) {
            requestBuilder.setUri(host + ":" + port + uri);
        } else {
            String ipAddressType = IpDomainUtil.checkIpAddressType(host);
            String baseUri = "ipv6".equals(ipAddressType) ? String.format("[%s]:%s", host, port + uri) : String.format("%s:%s", host, port + uri);
            requestBuilder.setUri("http://" + baseUri);
        }
        requestBuilder.addHeader("Connection", "keep-alive");
        requestBuilder.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.76 Safari/537.36");
        requestBuilder.addHeader("Accept", "text/plain");
        int timeout = Integer.parseInt(timeoutStr);
        if (timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        }
        return requestBuilder.build();
    }

    private void parseStatsResponse(String responseBody, String timePeriod, HashMap<String, String> resultMap) {
        String[] strArray;
        String timeRegex = String.format(REGEX, timePeriod);
        Pattern pattern = Pattern.compile(timeRegex);
        for (String str : strArray = responseBody.split(STR_SPLIT)) {
            Matcher matcher = pattern.matcher(str);
            if (!matcher.find()) continue;
            String[] split = str.split(timeRegex);
            resultMap.put(split[0], split[1]);
        }
    }

    private void parseStorageResponse(String responseBody, HashMap<String, String> resultMap) {
        String[] strArray;
        for (String str : strArray = responseBody.split(STR_SPLIT)) {
            String[] split = str.split(STORAGE_SPLIT_KEY_VALUE);
            resultMap.put(split[0], split[1]);
        }
    }
}

