/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.httpsd.discovery.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.DiscoveryClient;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.entity.ConnectConfig;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.entity.ServerInfo;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.entity.ServiceInstance;
import org.apache.hertzbeat.common.entity.job.protocol.HttpsdProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosDiscoveryClient
implements DiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryClient.class);
    private NamingService namingService;
    private ConnectConfig localConnectConfig;

    @Override
    public ConnectConfig buildConnectConfig(HttpsdProtocol httpsdProtocol) {
        return ConnectConfig.builder().host(httpsdProtocol.getHost()).port(Integer.parseInt(httpsdProtocol.getPort())).build();
    }

    @Override
    public void initClient(ConnectConfig connectConfig) {
        try {
            this.localConnectConfig = connectConfig;
            this.namingService = NamingFactory.createNamingService(connectConfig.getHost() + ":" + connectConfig.getPort());
        }
        catch (NacosException exception) {
            throw new RuntimeException("Failed to init namingService");
        }
    }

    @Override
    public ServerInfo getServerInfo() {
        if (Objects.isNull(this.namingService)) {
            throw new NullPointerException("NamingService is null");
        }
        if (!this.healthCheck()) {
            throw new RuntimeException("NamingService is not healthy");
        }
        ServerInfo serverInfo = ServerInfo.builder().address(this.localConnectConfig.getHost()).port(String.valueOf(this.localConnectConfig.getPort())).build();
        return serverInfo;
    }

    @Override
    public List<ServiceInstance> getServices() {
        if (Objects.isNull(this.namingService)) {
            log.error("NamingService is null");
            return Collections.emptyList();
        }
        if (!this.healthCheck()) {
            log.error("NamingService is not healthy");
            return Collections.emptyList();
        }
        ArrayList<ServiceInstance> serviceInstanceList = Lists.newArrayList();
        try {
            for (String serviceName : this.namingService.getServicesOfServer(0, 9999).getData()) {
                this.namingService.getAllInstances(serviceName).forEach(instance -> serviceInstanceList.add(ServiceInstance.builder().serviceId(instance.getInstanceId()).serviceName(instance.getServiceName()).address(instance.getIp()).weight(instance.getWeight()).metadata(instance.getMetadata()).port(instance.getPort()).healthStatus(instance.isHealthy() ? "UP" : "DOWN").build()));
            }
        }
        catch (NacosException e) {
            throw new RuntimeException("Failed to fetch instance info");
        }
        return serviceInstanceList;
    }

    @Override
    public boolean healthCheck() {
        return this.namingService.getServerStatus().equals("UP");
    }

    @Override
    public void close() {
        if (this.namingService == null) {
            return;
        }
        try {
            this.namingService.shutDown();
        }
        catch (NacosException exception) {
            log.error("Nacos client close exception: {}", (Object)exception.toString());
        }
    }
}

