/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.http.promethus.exporter;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hertzbeat.collector.collect.http.promethus.ParseException;
import org.apache.hertzbeat.collector.collect.http.promethus.exporter.MetricFamily;
import org.apache.hertzbeat.collector.collect.http.promethus.exporter.MetricType;
import org.apache.hertzbeat.common.util.StrBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterParser {
    private static final Logger log = LoggerFactory.getLogger(ExporterParser.class);
    private static final String HELP = "HELP";
    private static final String TYPE = "TYPE";
    private static final String EOF = "EOF";
    private static final String METRIC_NAME_LABEL = ".name";
    private static final String QUANTILE_LABEL = "quantile";
    private static final String BUCKET_LABEL = "le";
    private static final String NAME_LABEL = "__name__";
    private static final String SUM_SUFFIX = "_sum";
    private static final String COUNT_SUFFIX = "_count";
    private static final char LEFT_CURLY_BRACKET = '{';
    private static final char RIGHT_CURLY_BRACKET = '}';
    private static final char EQUALS = '=';
    private static final char QUOTES = '\"';
    private static final char ENTER = '\n';
    private static final char SPACE = ' ';
    private static final char COMMA = ',';
    private final Lock lock = new ReentrantLock();
    private MetricFamily currentMetricFamily;
    private String currentQuantile;
    private String currentBucket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MetricFamily> textToMetric(String resp) {
        ConcurrentHashMap<String, MetricFamily> metricMap = new ConcurrentHashMap<String, MetricFamily>(10);
        this.lock.lock();
        try {
            String[] lines;
            for (String line : lines = resp.split("\n")) {
                this.parseLine(metricMap, new StrBuffer(line));
            }
            ConcurrentHashMap<String, MetricFamily> concurrentHashMap = metricMap;
            return concurrentHashMap;
        }
        catch (Exception e) {
            log.error("parse prometheus exporter data error, msg: {}", (Object)e.getMessage());
        }
        finally {
            this.lock.unlock();
        }
        return metricMap;
    }

    private void parseLine(Map<String, MetricFamily> metricMap, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        switch (buffer.charAt(0)) {
            case '#': {
                buffer.read();
                this.currentMetricFamily = null;
                this.parseComment(metricMap, buffer);
                break;
            }
            case '\n': {
                break;
            }
            default: {
                this.currentBucket = null;
                this.currentQuantile = null;
                this.parseMetric(buffer);
            }
        }
    }

    private void parseComment(Map<String, MetricFamily> metricMap, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        String token = this.readTokenUnitWhitespace(buffer);
        if (EOF.equals(token)) {
            return;
        }
        if (!HELP.equals(token) && !TYPE.equals(token)) {
            log.error("parse comment error {}, start without {} or {}", buffer.toStr(), HELP, TYPE);
            return;
        }
        String metricName = this.readTokenAsMetricName(buffer);
        this.currentMetricFamily = metricMap.computeIfAbsent(metricName, key -> new MetricFamily());
        this.currentMetricFamily.setName(metricName);
        switch (token) {
            case "HELP": {
                this.parseHelp(buffer);
                break;
            }
            case "TYPE": {
                this.parseType(buffer);
                break;
            }
        }
    }

    private void parseHelp(StrBuffer line) {
        line.skipBlankTabs();
        this.currentMetricFamily.setHelp(line.toStr());
    }

    private void parseType(StrBuffer line) {
        line.skipBlankTabs();
        String type = line.toStr().toLowerCase();
        MetricType metricType = MetricType.getType(type);
        if (metricType == null) {
            throw new ParseException("pare type error");
        }
        this.currentMetricFamily.setMetricType(metricType);
    }

    private void parseMetric(StrBuffer buffer) {
        String metricName = this.readTokenAsMetricName(buffer);
        MetricFamily.Label label = new MetricFamily.Label();
        label.setName(METRIC_NAME_LABEL);
        label.setValue(metricName);
        if (metricName.isEmpty()) {
            log.error("error parse metric, metric name is null, line: {}", (Object)buffer.toStr());
            return;
        }
        List<MetricFamily.Metric> metricList = this.currentMetricFamily.getMetricList();
        if (metricList == null) {
            metricList = new ArrayList<MetricFamily.Metric>();
            this.currentMetricFamily.setMetricList(metricList);
        }
        MetricFamily.Metric metric = new MetricFamily.Metric();
        metricList.add(metric);
        metric.setLabelPair(new ArrayList<MetricFamily.Label>());
        metric.getLabelPair().add(label);
        this.readLabels(metric, buffer);
    }

    private void readLabels(MetricFamily.Metric metric, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        if (buffer.charAt(0) == '{') {
            buffer.read();
            this.startReadLabelName(metric, buffer);
        } else {
            this.readLabelValue(metric, null, buffer);
        }
    }

    private void startReadLabelName(MetricFamily.Metric metric, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        if (buffer.charAt(0) == '}') {
            buffer.read();
            buffer.skipBlankTabs();
            if (buffer.isEmpty()) {
                return;
            }
            this.readLabelValue(metric, new MetricFamily.Label(), buffer);
            return;
        }
        String labelName = this.readTokenAsLabelName(buffer);
        if (labelName.isEmpty() || labelName.equals(NAME_LABEL)) {
            throw new ParseException("invalid label name" + labelName + ", label name size = 0 or label name equals __name__");
        }
        MetricFamily.Label label = new MetricFamily.Label();
        label.setName(labelName);
        if (buffer.read() != '=') {
            throw new ParseException("parse error, not match the format of labelName=labelValue");
        }
        this.startReadLabelValue(metric, label, buffer);
    }

    private void startReadLabelValue(MetricFamily.Metric metric, MetricFamily.Label label, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        char c = buffer.read();
        if (c != '\"') {
            throw new ParseException("expected '\"' at start of label value, line: " + buffer.toStr());
        }
        String labelValue = this.readTokenAsLabelValue(buffer);
        label.setValue(labelValue);
        if (!this.isValidLabelValue(labelValue)) {
            throw new ParseException("no valid label value: " + labelValue);
        }
        if (this.currentMetricFamily.getMetricType().equals((Object)MetricType.SUMMARY) && label.getName().equals(QUANTILE_LABEL)) {
            this.currentQuantile = labelValue;
        } else if (this.currentMetricFamily.getMetricType().equals((Object)MetricType.HISTOGRAM) && label.getName().equals(BUCKET_LABEL)) {
            this.currentBucket = labelValue;
        }
        metric.getLabelPair().add(label);
        if (buffer.isEmpty()) {
            return;
        }
        c = buffer.read();
        switch (c) {
            case ',': {
                this.startReadLabelName(metric, buffer);
                break;
            }
            case '}': {
                this.readLabelValue(metric, label, buffer);
                break;
            }
            default: {
                throw new ParseException("expected '}' or ',' at end of label value, line: " + buffer.toStr());
            }
        }
    }

    private void readLabelValue(MetricFamily.Metric metric, MetricFamily.Label label, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        switch (this.currentMetricFamily.getMetricType()) {
            case INFO: {
                MetricFamily.Info info = new MetricFamily.Info();
                info.setValue(buffer.toDouble());
                metric.setInfo(info);
                break;
            }
            case COUNTER: {
                MetricFamily.Counter counter = new MetricFamily.Counter();
                counter.setValue(buffer.toDouble());
                metric.setCounter(counter);
                break;
            }
            case GAUGE: {
                MetricFamily.Gauge gauge = new MetricFamily.Gauge();
                gauge.setValue(buffer.toDouble());
                metric.setGauge(gauge);
                break;
            }
            case UNTYPED: {
                MetricFamily.Untyped untyped = new MetricFamily.Untyped();
                untyped.setValue(buffer.toDouble());
                metric.setUntyped(untyped);
                break;
            }
            case SUMMARY: {
                MetricFamily.Summary summary = new MetricFamily.Summary();
                summary.setValue(buffer.toDouble());
                metric.setSummary(summary);
                break;
            }
            case HISTOGRAM: {
                MetricFamily.Histogram histogram = new MetricFamily.Histogram();
                histogram.setValue(buffer.toDouble());
                metric.setHistogram(histogram);
                break;
            }
            default: {
                throw new ParseException("no such type in metricFamily");
            }
        }
    }

    private String readTokenUnitWhitespace(StrBuffer buffer) {
        char c;
        StringBuilder builder = new StringBuilder();
        while (!buffer.isEmpty() && (c = buffer.read()) != ' ') {
            builder.append(c);
        }
        return builder.toString();
    }

    private String readTokenAsMetricName(StrBuffer buffer) {
        buffer.skipBlankTabs();
        StringBuilder builder = new StringBuilder();
        if (this.isValidMetricNameStart(buffer.charAt(0))) {
            while (!buffer.isEmpty()) {
                char c = buffer.read();
                if (!this.isValidMetricNameContinuation(c)) {
                    buffer.rollback();
                    break;
                }
                builder.append(c);
            }
            return builder.toString();
        }
        throw new ParseException("parse metric name error");
    }

    private String readTokenAsLabelName(StrBuffer buffer) {
        buffer.skipBlankTabs();
        StringBuilder builder = new StringBuilder();
        char c = buffer.read();
        if (this.isValidLabelNameStart(c)) {
            builder.append(c);
            while (!buffer.isEmpty()) {
                c = buffer.read();
                if (!this.isValidLabelNameContinuation(c)) {
                    buffer.rollback();
                    break;
                }
                builder.append(c);
            }
            return builder.toString();
        }
        throw new ParseException("parse label name error");
    }

    private String readTokenAsLabelValue(StrBuffer buffer) {
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        block9: while (!buffer.isEmpty()) {
            char c = buffer.read();
            if (escaped) {
                switch (c) {
                    case '\"': 
                    case '\\': {
                        builder.append(c);
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    default: {
                        throw new ParseException("parse label value error");
                    }
                }
                escaped = false;
                continue;
            }
            switch (c) {
                case '\"': {
                    return builder.toString();
                }
                case '\n': {
                    throw new ParseException("parse label value error, next line");
                }
                case '\\': {
                    escaped = true;
                    continue block9;
                }
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private boolean isValidMetricNameStart(char c) {
        return this.isValidLabelNameStart(c) || c == ':';
    }

    private boolean isValidMetricNameContinuation(char c) {
        return this.isValidLabelNameContinuation(c) || c == ':';
    }

    private boolean isValidLabelNameStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean isValidLabelNameContinuation(char c) {
        return this.isValidLabelNameStart(c) || c >= '0' && c <= '9';
    }

    private boolean isValidLabelValue(String s) {
        return s != null && s.equals(new String(s.getBytes(StandardCharsets.UTF_8)));
    }

    private boolean isSum(String s) {
        return s != null && s.endsWith(SUM_SUFFIX);
    }

    private boolean isCount(String s) {
        return s != null && s.endsWith(COUNT_SUFFIX);
    }
}

