/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.common.ssh;

import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonSshClient {
    private static final Logger log = LoggerFactory.getLogger(CommonSshClient.class);
    private static final SshClient SSH_CLIENT = SshClient.setUpDefaultClient();

    public static SshClient getSshClient() {
        return SSH_CLIENT;
    }

    static {
        AcceptAllServerKeyVerifier verifier = AcceptAllServerKeyVerifier.INSTANCE;
        SSH_CLIENT.setServerKeyVerifier(verifier);
        PropertyResolverUtils.updateProperty((PropertyResolver)SSH_CLIENT, CoreModuleProperties.HEARTBEAT_INTERVAL.getName(), 2000);
        PropertyResolverUtils.updateProperty((PropertyResolver)SSH_CLIENT, CoreModuleProperties.HEARTBEAT_REPLY_WAIT.getName(), 300000);
        PropertyResolverUtils.updateProperty((PropertyResolver)SSH_CLIENT, CoreModuleProperties.SOCKET_KEEPALIVE.getName(), true);
        SSH_CLIENT.setKeyExchangeFactories(NamedFactory.setUpTransformedFactories(false, BuiltinDHFactories.VALUES, ClientBuilder.DH2KEX));
        SSH_CLIENT.start();
    }
}

