/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util.prometheus;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.hertzbeat.common.util.prometheus.Label;
import org.apache.hertzbeat.common.util.prometheus.Metric;

public final class PrometheusUtil {
    private static final int ERROR_FORMAT = -1;
    private static final int NORMAL_END = -2;
    private static final int COMMENT_LINE = -3;

    private PrometheusUtil() {
    }

    private static int parseMetricName(InputStream inputStream, Metric.MetricBuilder metricBuilder) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int i = inputStream.read();
        if (i == -1) {
            return -2;
        }
        if (i == 35) {
            return -3;
        }
        while (i != -1) {
            if (i == 32 || i == 123) {
                metricBuilder.metricName(stringBuilder.toString());
                return i;
            }
            stringBuilder.append((char)i);
            i = inputStream.read();
        }
        return -1;
    }

    private static int parseLabel(InputStream inputStream, List<Label> labelList) throws IOException {
        Label.LabelBuilder labelBuilder = new Label.LabelBuilder();
        StringBuilder labelName = new StringBuilder();
        int i = inputStream.read();
        while (i != -1 && i != 61) {
            labelName.append((char)i);
            i = inputStream.read();
        }
        if (i == -1) {
            return -1;
        }
        labelBuilder.name(labelName.toString());
        if (inputStream.read() != 34) {
            return -1;
        }
        StringBuilder labelValue = new StringBuilder();
        i = inputStream.read();
        while (i != -1 && i != 44 && i != 125) {
            labelValue.append((char)i);
            i = inputStream.read();
        }
        if (i == -1 || labelValue.charAt(labelValue.length() - 1) != '\"') {
            return -1;
        }
        if (i == 125 && inputStream.read() != 32) {
            return -1;
        }
        labelValue.deleteCharAt(labelValue.length() - 1);
        labelBuilder.value(labelValue.toString());
        labelList.add(labelBuilder.build());
        return i;
    }

    private static int parseLabelList(InputStream inputStream, Metric.MetricBuilder metricBuilder) throws IOException {
        ArrayList<Label> labelList = new ArrayList<Label>();
        int i = PrometheusUtil.parseLabel(inputStream, labelList);
        while (i == 44) {
            i = PrometheusUtil.parseLabel(inputStream, labelList);
        }
        if (i == -1) {
            return -1;
        }
        metricBuilder.labelList(labelList);
        return i;
    }

    private static int parseValue(InputStream inputStream, Metric.MetricBuilder metricBuilder) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        int i = inputStream.read();
        while (i != -1 && i != 32 && i != 10) {
            stringBuilder.append((char)i);
            i = inputStream.read();
        }
        switch (string = stringBuilder.toString()) {
            case "NaN": {
                metricBuilder.value(Double.NaN);
                break;
            }
            case "+Inf": {
                metricBuilder.value(Double.POSITIVE_INFINITY);
                break;
            }
            case "-Inf": {
                metricBuilder.value(Double.NEGATIVE_INFINITY);
                break;
            }
            default: {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    metricBuilder.value(bigDecimal.doubleValue());
                    break;
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        }
        if (i == -1) {
            return -2;
        }
        return i;
    }

    private static int parseTimestamp(InputStream inputStream, Metric.MetricBuilder metricBuilder) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int i = inputStream.read();
        while (i != -1 && i != 10) {
            stringBuilder.append((char)i);
            i = inputStream.read();
        }
        String string = stringBuilder.toString();
        try {
            metricBuilder.timestamp(Long.parseLong(string));
        }
        catch (NumberFormatException e) {
            return -1;
        }
        if (i == -1) {
            return -2;
        }
        return i;
    }

    private static int parseMetric(InputStream inputStream, List<Metric> metrics) throws IOException {
        Metric.MetricBuilder metricBuilder = new Metric.MetricBuilder();
        int i = PrometheusUtil.parseMetricName(inputStream, metricBuilder);
        if (i == -1 || i == -2 || i == -3) {
            return i;
        }
        if (i == 123 && (i = PrometheusUtil.parseLabelList(inputStream, metricBuilder)) == -1) {
            return i;
        }
        i = PrometheusUtil.parseValue(inputStream, metricBuilder);
        if (i != 32) {
            metrics.add(metricBuilder.build());
            return i;
        }
        i = PrometheusUtil.parseTimestamp(inputStream, metricBuilder);
        metrics.add(metricBuilder.build());
        return i;
    }

    private static int skipCommentLine(InputStream inputStream) throws IOException {
        int i = inputStream.read();
        while (i != -1 && i != 10) {
            i = inputStream.read();
        }
        if (i == -1) {
            return -2;
        }
        return i;
    }

    public static List<Metric> parseMetrics(InputStream inputStream) throws IOException {
        ArrayList<Metric> metricList = new ArrayList<Metric>();
        int i = PrometheusUtil.parseMetric(inputStream, metricList);
        while (i == 10 || i == -3) {
            if (i == -3 && PrometheusUtil.skipCommentLine(inputStream) == -2) {
                return metricList;
            }
            i = PrometheusUtil.parseMetric(inputStream, metricList);
        }
        if (i == -2) {
            return metricList;
        }
        return null;
    }
}

