/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtoJsonUtil {
    private static final Logger log = LoggerFactory.getLogger(ProtoJsonUtil.class);
    private static final JsonFormat.Printer PRINTER = JsonFormat.printer();
    private static final JsonFormat.Parser PARSER = JsonFormat.parser();

    private ProtoJsonUtil() {
    }

    public static String toJsonStr(Message proto) {
        try {
            return PRINTER.print((MessageOrBuilder)proto);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Message toProtobuf(String json, Message.Builder builder) {
        try {
            PARSER.merge(json, builder);
            return builder.build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

