/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.support.valid;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.apache.hertzbeat.common.support.valid.HostValid;
import org.apache.hertzbeat.common.util.IpDomainUtil;

public class HostParamValidator
implements ConstraintValidator<HostValid, String> {
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String BLANK = "";
    public static final String PATTERN_HTTP = "(?i)http://";
    public static final String PATTERN_HTTPS = "(?i)https://";

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value != null && value.toLowerCase().contains(HTTP)) {
            value = value.replaceAll(PATTERN_HTTP, BLANK);
        }
        if (value != null && value.toLowerCase().contains(HTTPS)) {
            value = value.replace(PATTERN_HTTPS, BLANK);
        }
        return IpDomainUtil.validateIpDomain(value);
    }
}

