/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.manager.TagItem;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.springframework.stereotype.Component;

@Converter
@Component
public class JsonTagListAttributeConverter
implements AttributeConverter<List<TagItem>, String> {
    public String convertToDatabaseColumn(List<TagItem> attribute) {
        return JsonUtil.toJson(attribute);
    }

    public List<TagItem> convertToEntityAttribute(String dbData) {
        TypeReference<List<TagItem>> typeReference = new TypeReference<List<TagItem>>(){};
        List<TagItem> tagItems = JsonUtil.fromJson(dbData, typeReference);
        if (tagItems == null) {
            TypeReference<Map<String, String>> mapTypeReference = new TypeReference<Map<String, String>>(){};
            Map<String, String> map = JsonUtil.fromJson(dbData, mapTypeReference);
            if (map != null) {
                return map.entrySet().stream().map(entry -> new TagItem((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
            }
            return null;
        }
        return tagItems;
    }
}

