/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hertzbeat.common.entity.job.protocol.DnsProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.FtpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.HttpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.HttpsdProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.IcmpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.JdbcProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.JmxProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.MemcachedProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.MongodbProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.NebulaGraphProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.NginxProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.NgqlProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.NtpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.Pop3Protocol;
import org.apache.hertzbeat.common.entity.job.protocol.PrometheusProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.PushProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.RedfishProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.RedisProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.RocketmqProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.SmtpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.SnmpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.SshProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.TelnetProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.UdpProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.WebsocketProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);
    private String name;
    private Map<String, String> i18n;
    private String protocol;
    private Byte priority;
    private boolean visible = true;
    private List<Field> fields;
    private List<String> aliasFields;
    private List<String> calculates;
    private List<String> units;
    private HttpProtocol http;
    private IcmpProtocol icmp;
    private TelnetProtocol telnet;
    private SmtpProtocol smtp;
    private NtpProtocol ntp;
    private WebsocketProtocol websocket;
    private MemcachedProtocol memcached;
    private NebulaGraphProtocol nebulaGraph;
    private UdpProtocol udp;
    private JdbcProtocol jdbc;
    private SshProtocol ssh;
    private RedisProtocol redis;
    private MongodbProtocol mongodb;
    private JmxProtocol jmx;
    private SnmpProtocol snmp;
    private FtpProtocol ftp;
    private RocketmqProtocol rocketmq;
    private PushProtocol push;
    private PrometheusProtocol prometheus;
    private DnsProtocol dns;
    private NginxProtocol nginx;
    private Pop3Protocol pop3;
    private HttpsdProtocol httpsd;
    private RedfishProtocol redfish;
    private NgqlProtocol ngql;
    @JsonIgnore
    private transient AtomicReference<CollectRep.MetricsData> subTaskDataRef;
    @JsonIgnore
    private transient AtomicInteger subTaskNum;
    @JsonIgnore
    private transient Integer subTaskId;

    public boolean isHasSubTask() {
        return this.subTaskNum != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeSubTaskResponse(CollectRep.MetricsData metricsData) {
        if (this.subTaskNum == null) {
            return true;
        }
        AtomicInteger atomicInteger = this.subTaskNum;
        synchronized (atomicInteger) {
            int index = this.subTaskNum.decrementAndGet();
            if (this.subTaskDataRef.get() == null) {
                this.subTaskDataRef.set(metricsData);
            } else if (metricsData.getValuesCount() >= 1) {
                CollectRep.MetricsData.Builder dataBuilder = CollectRep.MetricsData.newBuilder(this.subTaskDataRef.get());
                for (CollectRep.ValueRow valueRow : metricsData.getValuesList()) {
                    if (valueRow.getColumnsCount() == dataBuilder.getFieldsCount()) {
                        dataBuilder.addValues(valueRow);
                        continue;
                    }
                    log.error("consume subTask data value not mapping filed");
                }
                this.subTaskDataRef.set(dataBuilder.build());
            }
            return index == 0;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metrics metrics = (Metrics)o;
        return this.name.equals(metrics.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static MetricsBuilder builder() {
        return new MetricsBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getI18n() {
        return this.i18n;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Byte getPriority() {
        return this.priority;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<String> getAliasFields() {
        return this.aliasFields;
    }

    public List<String> getCalculates() {
        return this.calculates;
    }

    public List<String> getUnits() {
        return this.units;
    }

    public HttpProtocol getHttp() {
        return this.http;
    }

    public IcmpProtocol getIcmp() {
        return this.icmp;
    }

    public TelnetProtocol getTelnet() {
        return this.telnet;
    }

    public SmtpProtocol getSmtp() {
        return this.smtp;
    }

    public NtpProtocol getNtp() {
        return this.ntp;
    }

    public WebsocketProtocol getWebsocket() {
        return this.websocket;
    }

    public MemcachedProtocol getMemcached() {
        return this.memcached;
    }

    public NebulaGraphProtocol getNebulaGraph() {
        return this.nebulaGraph;
    }

    public UdpProtocol getUdp() {
        return this.udp;
    }

    public JdbcProtocol getJdbc() {
        return this.jdbc;
    }

    public SshProtocol getSsh() {
        return this.ssh;
    }

    public RedisProtocol getRedis() {
        return this.redis;
    }

    public MongodbProtocol getMongodb() {
        return this.mongodb;
    }

    public JmxProtocol getJmx() {
        return this.jmx;
    }

    public SnmpProtocol getSnmp() {
        return this.snmp;
    }

    public FtpProtocol getFtp() {
        return this.ftp;
    }

    public RocketmqProtocol getRocketmq() {
        return this.rocketmq;
    }

    public PushProtocol getPush() {
        return this.push;
    }

    public PrometheusProtocol getPrometheus() {
        return this.prometheus;
    }

    public DnsProtocol getDns() {
        return this.dns;
    }

    public NginxProtocol getNginx() {
        return this.nginx;
    }

    public Pop3Protocol getPop3() {
        return this.pop3;
    }

    public HttpsdProtocol getHttpsd() {
        return this.httpsd;
    }

    public RedfishProtocol getRedfish() {
        return this.redfish;
    }

    public NgqlProtocol getNgql() {
        return this.ngql;
    }

    public AtomicReference<CollectRep.MetricsData> getSubTaskDataRef() {
        return this.subTaskDataRef;
    }

    public AtomicInteger getSubTaskNum() {
        return this.subTaskNum;
    }

    public Integer getSubTaskId() {
        return this.subTaskId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setI18n(Map<String, String> i18n) {
        this.i18n = i18n;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setPriority(Byte priority) {
        this.priority = priority;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void setAliasFields(List<String> aliasFields) {
        this.aliasFields = aliasFields;
    }

    public void setCalculates(List<String> calculates) {
        this.calculates = calculates;
    }

    public void setUnits(List<String> units) {
        this.units = units;
    }

    public void setHttp(HttpProtocol http) {
        this.http = http;
    }

    public void setIcmp(IcmpProtocol icmp) {
        this.icmp = icmp;
    }

    public void setTelnet(TelnetProtocol telnet) {
        this.telnet = telnet;
    }

    public void setSmtp(SmtpProtocol smtp) {
        this.smtp = smtp;
    }

    public void setNtp(NtpProtocol ntp) {
        this.ntp = ntp;
    }

    public void setWebsocket(WebsocketProtocol websocket) {
        this.websocket = websocket;
    }

    public void setMemcached(MemcachedProtocol memcached) {
        this.memcached = memcached;
    }

    public void setNebulaGraph(NebulaGraphProtocol nebulaGraph) {
        this.nebulaGraph = nebulaGraph;
    }

    public void setUdp(UdpProtocol udp) {
        this.udp = udp;
    }

    public void setJdbc(JdbcProtocol jdbc) {
        this.jdbc = jdbc;
    }

    public void setSsh(SshProtocol ssh) {
        this.ssh = ssh;
    }

    public void setRedis(RedisProtocol redis) {
        this.redis = redis;
    }

    public void setMongodb(MongodbProtocol mongodb) {
        this.mongodb = mongodb;
    }

    public void setJmx(JmxProtocol jmx) {
        this.jmx = jmx;
    }

    public void setSnmp(SnmpProtocol snmp) {
        this.snmp = snmp;
    }

    public void setFtp(FtpProtocol ftp) {
        this.ftp = ftp;
    }

    public void setRocketmq(RocketmqProtocol rocketmq) {
        this.rocketmq = rocketmq;
    }

    public void setPush(PushProtocol push) {
        this.push = push;
    }

    public void setPrometheus(PrometheusProtocol prometheus) {
        this.prometheus = prometheus;
    }

    public void setDns(DnsProtocol dns) {
        this.dns = dns;
    }

    public void setNginx(NginxProtocol nginx) {
        this.nginx = nginx;
    }

    public void setPop3(Pop3Protocol pop3) {
        this.pop3 = pop3;
    }

    public void setHttpsd(HttpsdProtocol httpsd) {
        this.httpsd = httpsd;
    }

    public void setRedfish(RedfishProtocol redfish) {
        this.redfish = redfish;
    }

    public void setNgql(NgqlProtocol ngql) {
        this.ngql = ngql;
    }

    @JsonIgnore
    public void setSubTaskDataRef(AtomicReference<CollectRep.MetricsData> subTaskDataRef) {
        this.subTaskDataRef = subTaskDataRef;
    }

    @JsonIgnore
    public void setSubTaskNum(AtomicInteger subTaskNum) {
        this.subTaskNum = subTaskNum;
    }

    @JsonIgnore
    public void setSubTaskId(Integer subTaskId) {
        this.subTaskId = subTaskId;
    }

    public String toString() {
        return "Metrics(name=" + this.getName() + ", i18n=" + this.getI18n() + ", protocol=" + this.getProtocol() + ", priority=" + this.getPriority() + ", visible=" + this.isVisible() + ", fields=" + this.getFields() + ", aliasFields=" + this.getAliasFields() + ", calculates=" + this.getCalculates() + ", units=" + this.getUnits() + ", http=" + this.getHttp() + ", icmp=" + this.getIcmp() + ", telnet=" + this.getTelnet() + ", smtp=" + this.getSmtp() + ", ntp=" + this.getNtp() + ", websocket=" + this.getWebsocket() + ", memcached=" + this.getMemcached() + ", nebulaGraph=" + this.getNebulaGraph() + ", udp=" + this.getUdp() + ", jdbc=" + this.getJdbc() + ", ssh=" + this.getSsh() + ", redis=" + this.getRedis() + ", mongodb=" + this.getMongodb() + ", jmx=" + this.getJmx() + ", snmp=" + this.getSnmp() + ", ftp=" + this.getFtp() + ", rocketmq=" + this.getRocketmq() + ", push=" + this.getPush() + ", prometheus=" + this.getPrometheus() + ", dns=" + this.getDns() + ", nginx=" + this.getNginx() + ", pop3=" + this.getPop3() + ", httpsd=" + this.getHttpsd() + ", redfish=" + this.getRedfish() + ", ngql=" + this.getNgql() + ", subTaskDataRef=" + this.getSubTaskDataRef() + ", subTaskNum=" + this.getSubTaskNum() + ", subTaskId=" + this.getSubTaskId() + ")";
    }

    public Metrics(String name, Map<String, String> i18n, String protocol, Byte priority, boolean visible, List<Field> fields, List<String> aliasFields, List<String> calculates, List<String> units, HttpProtocol http, IcmpProtocol icmp, TelnetProtocol telnet, SmtpProtocol smtp, NtpProtocol ntp, WebsocketProtocol websocket, MemcachedProtocol memcached, NebulaGraphProtocol nebulaGraph, UdpProtocol udp, JdbcProtocol jdbc, SshProtocol ssh, RedisProtocol redis, MongodbProtocol mongodb, JmxProtocol jmx, SnmpProtocol snmp, FtpProtocol ftp, RocketmqProtocol rocketmq, PushProtocol push, PrometheusProtocol prometheus, DnsProtocol dns, NginxProtocol nginx, Pop3Protocol pop3, HttpsdProtocol httpsd, RedfishProtocol redfish, NgqlProtocol ngql, AtomicReference<CollectRep.MetricsData> subTaskDataRef, AtomicInteger subTaskNum, Integer subTaskId) {
        this.name = name;
        this.i18n = i18n;
        this.protocol = protocol;
        this.priority = priority;
        this.visible = visible;
        this.fields = fields;
        this.aliasFields = aliasFields;
        this.calculates = calculates;
        this.units = units;
        this.http = http;
        this.icmp = icmp;
        this.telnet = telnet;
        this.smtp = smtp;
        this.ntp = ntp;
        this.websocket = websocket;
        this.memcached = memcached;
        this.nebulaGraph = nebulaGraph;
        this.udp = udp;
        this.jdbc = jdbc;
        this.ssh = ssh;
        this.redis = redis;
        this.mongodb = mongodb;
        this.jmx = jmx;
        this.snmp = snmp;
        this.ftp = ftp;
        this.rocketmq = rocketmq;
        this.push = push;
        this.prometheus = prometheus;
        this.dns = dns;
        this.nginx = nginx;
        this.pop3 = pop3;
        this.httpsd = httpsd;
        this.redfish = redfish;
        this.ngql = ngql;
        this.subTaskDataRef = subTaskDataRef;
        this.subTaskNum = subTaskNum;
        this.subTaskId = subTaskId;
    }

    public Metrics() {
    }

    public static class MetricsBuilder {
        private String name;
        private Map<String, String> i18n;
        private String protocol;
        private Byte priority;
        private boolean visible;
        private List<Field> fields;
        private List<String> aliasFields;
        private List<String> calculates;
        private List<String> units;
        private HttpProtocol http;
        private IcmpProtocol icmp;
        private TelnetProtocol telnet;
        private SmtpProtocol smtp;
        private NtpProtocol ntp;
        private WebsocketProtocol websocket;
        private MemcachedProtocol memcached;
        private NebulaGraphProtocol nebulaGraph;
        private UdpProtocol udp;
        private JdbcProtocol jdbc;
        private SshProtocol ssh;
        private RedisProtocol redis;
        private MongodbProtocol mongodb;
        private JmxProtocol jmx;
        private SnmpProtocol snmp;
        private FtpProtocol ftp;
        private RocketmqProtocol rocketmq;
        private PushProtocol push;
        private PrometheusProtocol prometheus;
        private DnsProtocol dns;
        private NginxProtocol nginx;
        private Pop3Protocol pop3;
        private HttpsdProtocol httpsd;
        private RedfishProtocol redfish;
        private NgqlProtocol ngql;
        private AtomicReference<CollectRep.MetricsData> subTaskDataRef;
        private AtomicInteger subTaskNum;
        private Integer subTaskId;

        MetricsBuilder() {
        }

        public MetricsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricsBuilder i18n(Map<String, String> i18n) {
            this.i18n = i18n;
            return this;
        }

        public MetricsBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public MetricsBuilder priority(Byte priority) {
            this.priority = priority;
            return this;
        }

        public MetricsBuilder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public MetricsBuilder fields(List<Field> fields) {
            this.fields = fields;
            return this;
        }

        public MetricsBuilder aliasFields(List<String> aliasFields) {
            this.aliasFields = aliasFields;
            return this;
        }

        public MetricsBuilder calculates(List<String> calculates) {
            this.calculates = calculates;
            return this;
        }

        public MetricsBuilder units(List<String> units) {
            this.units = units;
            return this;
        }

        public MetricsBuilder http(HttpProtocol http) {
            this.http = http;
            return this;
        }

        public MetricsBuilder icmp(IcmpProtocol icmp) {
            this.icmp = icmp;
            return this;
        }

        public MetricsBuilder telnet(TelnetProtocol telnet) {
            this.telnet = telnet;
            return this;
        }

        public MetricsBuilder smtp(SmtpProtocol smtp) {
            this.smtp = smtp;
            return this;
        }

        public MetricsBuilder ntp(NtpProtocol ntp) {
            this.ntp = ntp;
            return this;
        }

        public MetricsBuilder websocket(WebsocketProtocol websocket) {
            this.websocket = websocket;
            return this;
        }

        public MetricsBuilder memcached(MemcachedProtocol memcached) {
            this.memcached = memcached;
            return this;
        }

        public MetricsBuilder nebulaGraph(NebulaGraphProtocol nebulaGraph) {
            this.nebulaGraph = nebulaGraph;
            return this;
        }

        public MetricsBuilder udp(UdpProtocol udp) {
            this.udp = udp;
            return this;
        }

        public MetricsBuilder jdbc(JdbcProtocol jdbc) {
            this.jdbc = jdbc;
            return this;
        }

        public MetricsBuilder ssh(SshProtocol ssh) {
            this.ssh = ssh;
            return this;
        }

        public MetricsBuilder redis(RedisProtocol redis) {
            this.redis = redis;
            return this;
        }

        public MetricsBuilder mongodb(MongodbProtocol mongodb) {
            this.mongodb = mongodb;
            return this;
        }

        public MetricsBuilder jmx(JmxProtocol jmx) {
            this.jmx = jmx;
            return this;
        }

        public MetricsBuilder snmp(SnmpProtocol snmp) {
            this.snmp = snmp;
            return this;
        }

        public MetricsBuilder ftp(FtpProtocol ftp) {
            this.ftp = ftp;
            return this;
        }

        public MetricsBuilder rocketmq(RocketmqProtocol rocketmq) {
            this.rocketmq = rocketmq;
            return this;
        }

        public MetricsBuilder push(PushProtocol push) {
            this.push = push;
            return this;
        }

        public MetricsBuilder prometheus(PrometheusProtocol prometheus) {
            this.prometheus = prometheus;
            return this;
        }

        public MetricsBuilder dns(DnsProtocol dns) {
            this.dns = dns;
            return this;
        }

        public MetricsBuilder nginx(NginxProtocol nginx) {
            this.nginx = nginx;
            return this;
        }

        public MetricsBuilder pop3(Pop3Protocol pop3) {
            this.pop3 = pop3;
            return this;
        }

        public MetricsBuilder httpsd(HttpsdProtocol httpsd) {
            this.httpsd = httpsd;
            return this;
        }

        public MetricsBuilder redfish(RedfishProtocol redfish) {
            this.redfish = redfish;
            return this;
        }

        public MetricsBuilder ngql(NgqlProtocol ngql) {
            this.ngql = ngql;
            return this;
        }

        @JsonIgnore
        public MetricsBuilder subTaskDataRef(AtomicReference<CollectRep.MetricsData> subTaskDataRef) {
            this.subTaskDataRef = subTaskDataRef;
            return this;
        }

        @JsonIgnore
        public MetricsBuilder subTaskNum(AtomicInteger subTaskNum) {
            this.subTaskNum = subTaskNum;
            return this;
        }

        @JsonIgnore
        public MetricsBuilder subTaskId(Integer subTaskId) {
            this.subTaskId = subTaskId;
            return this;
        }

        public Metrics build() {
            return new Metrics(this.name, this.i18n, this.protocol, this.priority, this.visible, this.fields, this.aliasFields, this.calculates, this.units, this.http, this.icmp, this.telnet, this.smtp, this.ntp, this.websocket, this.memcached, this.nebulaGraph, this.udp, this.jdbc, this.ssh, this.redis, this.mongodb, this.jmx, this.snmp, this.ftp, this.rocketmq, this.push, this.prometheus, this.dns, this.nginx, this.pop3, this.httpsd, this.redfish, this.ngql, this.subTaskDataRef, this.subTaskNum, this.subTaskId);
        }

        public String toString() {
            return "Metrics.MetricsBuilder(name=" + this.name + ", i18n=" + this.i18n + ", protocol=" + this.protocol + ", priority=" + this.priority + ", visible=" + this.visible + ", fields=" + this.fields + ", aliasFields=" + this.aliasFields + ", calculates=" + this.calculates + ", units=" + this.units + ", http=" + this.http + ", icmp=" + this.icmp + ", telnet=" + this.telnet + ", smtp=" + this.smtp + ", ntp=" + this.ntp + ", websocket=" + this.websocket + ", memcached=" + this.memcached + ", nebulaGraph=" + this.nebulaGraph + ", udp=" + this.udp + ", jdbc=" + this.jdbc + ", ssh=" + this.ssh + ", redis=" + this.redis + ", mongodb=" + this.mongodb + ", jmx=" + this.jmx + ", snmp=" + this.snmp + ", ftp=" + this.ftp + ", rocketmq=" + this.rocketmq + ", push=" + this.push + ", prometheus=" + this.prometheus + ", dns=" + this.dns + ", nginx=" + this.nginx + ", pop3=" + this.pop3 + ", httpsd=" + this.httpsd + ", redfish=" + this.redfish + ", ngql=" + this.ngql + ", subTaskDataRef=" + this.subTaskDataRef + ", subTaskNum=" + this.subTaskNum + ", subTaskId=" + this.subTaskId + ")";
        }
    }

    public static class Field {
        private String field;
        private Map<String, String> i18n;
        private byte type = 1;
        private boolean instance = false;
        private boolean label = false;
        private String unit;

        public static FieldBuilder builder() {
            return new FieldBuilder();
        }

        public String getField() {
            return this.field;
        }

        public Map<String, String> getI18n() {
            return this.i18n;
        }

        public byte getType() {
            return this.type;
        }

        public boolean isInstance() {
            return this.instance;
        }

        public boolean isLabel() {
            return this.label;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setI18n(Map<String, String> i18n) {
            this.i18n = i18n;
        }

        public void setType(byte type) {
            this.type = type;
        }

        public void setInstance(boolean instance) {
            this.instance = instance;
        }

        public void setLabel(boolean label) {
            this.label = label;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.isInstance() != other.isInstance()) {
                return false;
            }
            if (this.isLabel() != other.isLabel()) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            Map<String, String> this$i18n = this.getI18n();
            Map<String, String> other$i18n = other.getI18n();
            if (this$i18n == null ? other$i18n != null : !((Object)this$i18n).equals(other$i18n)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Field;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            result = result * 59 + (this.isInstance() ? 79 : 97);
            result = result * 59 + (this.isLabel() ? 79 : 97);
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            Map<String, String> $i18n = this.getI18n();
            result = result * 59 + ($i18n == null ? 43 : ((Object)$i18n).hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        public String toString() {
            return "Metrics.Field(field=" + this.getField() + ", i18n=" + this.getI18n() + ", type=" + this.getType() + ", instance=" + this.isInstance() + ", label=" + this.isLabel() + ", unit=" + this.getUnit() + ")";
        }

        public Field(String field, Map<String, String> i18n, byte type, boolean instance, boolean label, String unit) {
            this.field = field;
            this.i18n = i18n;
            this.type = type;
            this.instance = instance;
            this.label = label;
            this.unit = unit;
        }

        public Field() {
        }

        public static class FieldBuilder {
            private String field;
            private Map<String, String> i18n;
            private byte type;
            private boolean instance;
            private boolean label;
            private String unit;

            FieldBuilder() {
            }

            public FieldBuilder field(String field) {
                this.field = field;
                return this;
            }

            public FieldBuilder i18n(Map<String, String> i18n) {
                this.i18n = i18n;
                return this;
            }

            public FieldBuilder type(byte type) {
                this.type = type;
                return this;
            }

            public FieldBuilder instance(boolean instance) {
                this.instance = instance;
                return this;
            }

            public FieldBuilder label(boolean label) {
                this.label = label;
                return this;
            }

            public FieldBuilder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public Field build() {
                return new Field(this.field, this.i18n, this.type, this.instance, this.label, this.unit);
            }

            public String toString() {
                return "Metrics.Field.FieldBuilder(field=" + this.field + ", i18n=" + this.i18n + ", type=" + this.type + ", instance=" + this.instance + ", label=" + this.label + ", unit=" + this.unit + ")";
            }
        }
    }
}

