/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Job {
    private static final Logger log = LoggerFactory.getLogger(Job.class);
    private long id;
    private long tenantId = 0L;
    private long monitorId;
    private boolean hide = true;
    private String category;
    private String app;
    private Map<String, String> name;
    private Map<String, String> help;
    private Map<String, String> helpLink;
    private long timestamp;
    private long interval = 600L;
    private boolean isCyclic = false;
    private List<ParamDefine> params;
    private List<Metrics> metrics;
    private List<Configmap> configmap;
    @JsonIgnore
    private Map<String, Configmap> envConfigmaps;
    @JsonIgnore
    private transient long dispatchTime;
    @JsonIgnore
    private transient LinkedList<Set<Metrics>> priorMetrics;
    @JsonIgnore
    private transient List<CollectRep.MetricsData> responseDataTemp;

    public synchronized void constructPriorMetrics() {
        Map<Byte, List<Metrics>> map = this.metrics.stream().peek(metric -> {
            if ((metric.getAliasFields() == null || metric.getAliasFields().isEmpty()) && metric.getFields() != null) {
                metric.setAliasFields(metric.getFields().stream().map(Metrics.Field::getField).collect(Collectors.toList()));
            }
            if (metric.getPriority() == null) {
                metric.setPriority((byte)127);
            }
        }).collect(Collectors.groupingBy(Metrics::getPriority));
        this.priorMetrics = new LinkedList();
        map.values().forEach(metric -> {
            Set metricsSet = Collections.synchronizedSet(new HashSet(metric));
            this.priorMetrics.add(metricsSet);
        });
        this.priorMetrics.sort(Comparator.comparing(e -> {
            Optional metric = e.stream().findAny();
            if (metric.isPresent()) {
                return ((Metrics)metric.get()).getPriority();
            }
            return (byte)127;
        }));
        this.envConfigmaps = new HashMap<String, Configmap>(8);
    }

    public synchronized Set<Metrics> getNextCollectMetrics(Metrics metrics, boolean first) {
        if (this.priorMetrics == null || this.priorMetrics.isEmpty()) {
            return null;
        }
        Set<Metrics> metricsSet = this.priorMetrics.peek();
        if (first) {
            if (metricsSet.isEmpty()) {
                log.error("metrics must has one [availability] metrics at least.");
            }
            return metricsSet;
        }
        if (metrics == null) {
            log.error("metrics can not null when not first get");
            return null;
        }
        if (!metricsSet.remove(metrics)) {
            log.warn("Job {} appId {} app {} metrics {} remove empty error in priorMetrics.", new Object[]{this.id, this.monitorId, this.app, metrics.getName()});
        }
        if (metricsSet.isEmpty()) {
            this.priorMetrics.poll();
            if (this.priorMetrics.isEmpty()) {
                return null;
            }
            Set<Metrics> source = this.priorMetrics.peek();
            return new HashSet<Metrics>(source);
        }
        return Collections.emptySet();
    }

    public void addCollectMetricsData(CollectRep.MetricsData metricsData) {
        if (this.responseDataTemp == null) {
            this.responseDataTemp = new LinkedList<CollectRep.MetricsData>();
        }
        this.responseDataTemp.add(metricsData);
    }

    public Map<String, Configmap> getEnvConfigmaps() {
        return this.envConfigmaps;
    }

    public void addEnvConfigmaps(Map<String, Configmap> envConfigmaps) {
        if (this.envConfigmaps == null) {
            this.envConfigmaps = envConfigmaps;
        } else {
            this.envConfigmaps.putAll(envConfigmaps);
        }
    }

    public Job clone() {
        return (Job)JsonUtil.fromJson(JsonUtil.toJson(this), this.getClass());
    }

    public static JobBuilder builder() {
        return new JobBuilder();
    }

    public long getId() {
        return this.id;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public long getMonitorId() {
        return this.monitorId;
    }

    public boolean isHide() {
        return this.hide;
    }

    public String getCategory() {
        return this.category;
    }

    public String getApp() {
        return this.app;
    }

    public Map<String, String> getName() {
        return this.name;
    }

    public Map<String, String> getHelp() {
        return this.help;
    }

    public Map<String, String> getHelpLink() {
        return this.helpLink;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getInterval() {
        return this.interval;
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public List<ParamDefine> getParams() {
        return this.params;
    }

    public List<Metrics> getMetrics() {
        return this.metrics;
    }

    public List<Configmap> getConfigmap() {
        return this.configmap;
    }

    public long getDispatchTime() {
        return this.dispatchTime;
    }

    public LinkedList<Set<Metrics>> getPriorMetrics() {
        return this.priorMetrics;
    }

    public List<CollectRep.MetricsData> getResponseDataTemp() {
        return this.responseDataTemp;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public void setMonitorId(long monitorId) {
        this.monitorId = monitorId;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
    }

    public void setHelp(Map<String, String> help) {
        this.help = help;
    }

    public void setHelpLink(Map<String, String> helpLink) {
        this.helpLink = helpLink;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
    }

    public void setParams(List<ParamDefine> params) {
        this.params = params;
    }

    public void setMetrics(List<Metrics> metrics) {
        this.metrics = metrics;
    }

    public void setConfigmap(List<Configmap> configmap) {
        this.configmap = configmap;
    }

    @JsonIgnore
    public void setEnvConfigmaps(Map<String, Configmap> envConfigmaps) {
        this.envConfigmaps = envConfigmaps;
    }

    @JsonIgnore
    public void setDispatchTime(long dispatchTime) {
        this.dispatchTime = dispatchTime;
    }

    @JsonIgnore
    public void setPriorMetrics(LinkedList<Set<Metrics>> priorMetrics) {
        this.priorMetrics = priorMetrics;
    }

    @JsonIgnore
    public void setResponseDataTemp(List<CollectRep.MetricsData> responseDataTemp) {
        this.responseDataTemp = responseDataTemp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getTenantId() != other.getTenantId()) {
            return false;
        }
        if (this.getMonitorId() != other.getMonitorId()) {
            return false;
        }
        if (this.isHide() != other.isHide()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        if (this.isCyclic() != other.isCyclic()) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        Map<String, String> this$name = this.getName();
        Map<String, String> other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Map<String, String> this$help = this.getHelp();
        Map<String, String> other$help = other.getHelp();
        if (this$help == null ? other$help != null : !((Object)this$help).equals(other$help)) {
            return false;
        }
        Map<String, String> this$helpLink = this.getHelpLink();
        Map<String, String> other$helpLink = other.getHelpLink();
        if (this$helpLink == null ? other$helpLink != null : !((Object)this$helpLink).equals(other$helpLink)) {
            return false;
        }
        List<ParamDefine> this$params = this.getParams();
        List<ParamDefine> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        List<Metrics> this$metrics = this.getMetrics();
        List<Metrics> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        List<Configmap> this$configmap = this.getConfigmap();
        List<Configmap> other$configmap = other.getConfigmap();
        if (this$configmap == null ? other$configmap != null : !((Object)this$configmap).equals(other$configmap)) {
            return false;
        }
        Map<String, Configmap> this$envConfigmaps = this.getEnvConfigmaps();
        Map<String, Configmap> other$envConfigmaps = other.getEnvConfigmaps();
        return !(this$envConfigmaps == null ? other$envConfigmaps != null : !((Object)this$envConfigmaps).equals(other$envConfigmaps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Job;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $tenantId = this.getTenantId();
        result = result * 59 + (int)($tenantId >>> 32 ^ $tenantId);
        long $monitorId = this.getMonitorId();
        result = result * 59 + (int)($monitorId >>> 32 ^ $monitorId);
        result = result * 59 + (this.isHide() ? 79 : 97);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $interval = this.getInterval();
        result = result * 59 + (int)($interval >>> 32 ^ $interval);
        result = result * 59 + (this.isCyclic() ? 79 : 97);
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        Map<String, String> $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Map<String, String> $help = this.getHelp();
        result = result * 59 + ($help == null ? 43 : ((Object)$help).hashCode());
        Map<String, String> $helpLink = this.getHelpLink();
        result = result * 59 + ($helpLink == null ? 43 : ((Object)$helpLink).hashCode());
        List<ParamDefine> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        List<Metrics> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        List<Configmap> $configmap = this.getConfigmap();
        result = result * 59 + ($configmap == null ? 43 : ((Object)$configmap).hashCode());
        Map<String, Configmap> $envConfigmaps = this.getEnvConfigmaps();
        result = result * 59 + ($envConfigmaps == null ? 43 : ((Object)$envConfigmaps).hashCode());
        return result;
    }

    public String toString() {
        return "Job(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", monitorId=" + this.getMonitorId() + ", hide=" + this.isHide() + ", category=" + this.getCategory() + ", app=" + this.getApp() + ", name=" + this.getName() + ", help=" + this.getHelp() + ", helpLink=" + this.getHelpLink() + ", timestamp=" + this.getTimestamp() + ", interval=" + this.getInterval() + ", isCyclic=" + this.isCyclic() + ", params=" + this.getParams() + ", metrics=" + this.getMetrics() + ", configmap=" + this.getConfigmap() + ", envConfigmaps=" + this.getEnvConfigmaps() + ", dispatchTime=" + this.getDispatchTime() + ", priorMetrics=" + this.getPriorMetrics() + ", responseDataTemp=" + this.getResponseDataTemp() + ")";
    }

    public Job(long id, long tenantId, long monitorId, boolean hide, String category, String app, Map<String, String> name, Map<String, String> help, Map<String, String> helpLink, long timestamp, long interval, boolean isCyclic, List<ParamDefine> params, List<Metrics> metrics, List<Configmap> configmap, Map<String, Configmap> envConfigmaps, long dispatchTime, LinkedList<Set<Metrics>> priorMetrics, List<CollectRep.MetricsData> responseDataTemp) {
        this.id = id;
        this.tenantId = tenantId;
        this.monitorId = monitorId;
        this.hide = hide;
        this.category = category;
        this.app = app;
        this.name = name;
        this.help = help;
        this.helpLink = helpLink;
        this.timestamp = timestamp;
        this.interval = interval;
        this.isCyclic = isCyclic;
        this.params = params;
        this.metrics = metrics;
        this.configmap = configmap;
        this.envConfigmaps = envConfigmaps;
        this.dispatchTime = dispatchTime;
        this.priorMetrics = priorMetrics;
        this.responseDataTemp = responseDataTemp;
    }

    public Job() {
    }

    public static class JobBuilder {
        private long id;
        private long tenantId;
        private long monitorId;
        private boolean hide;
        private String category;
        private String app;
        private Map<String, String> name;
        private Map<String, String> help;
        private Map<String, String> helpLink;
        private long timestamp;
        private long interval;
        private boolean isCyclic;
        private List<ParamDefine> params;
        private List<Metrics> metrics;
        private List<Configmap> configmap;
        private Map<String, Configmap> envConfigmaps;
        private long dispatchTime;
        private LinkedList<Set<Metrics>> priorMetrics;
        private List<CollectRep.MetricsData> responseDataTemp;

        JobBuilder() {
        }

        public JobBuilder id(long id) {
            this.id = id;
            return this;
        }

        public JobBuilder tenantId(long tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public JobBuilder monitorId(long monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public JobBuilder hide(boolean hide) {
            this.hide = hide;
            return this;
        }

        public JobBuilder category(String category) {
            this.category = category;
            return this;
        }

        public JobBuilder app(String app) {
            this.app = app;
            return this;
        }

        public JobBuilder name(Map<String, String> name) {
            this.name = name;
            return this;
        }

        public JobBuilder help(Map<String, String> help) {
            this.help = help;
            return this;
        }

        public JobBuilder helpLink(Map<String, String> helpLink) {
            this.helpLink = helpLink;
            return this;
        }

        public JobBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public JobBuilder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public JobBuilder isCyclic(boolean isCyclic) {
            this.isCyclic = isCyclic;
            return this;
        }

        public JobBuilder params(List<ParamDefine> params) {
            this.params = params;
            return this;
        }

        public JobBuilder metrics(List<Metrics> metrics) {
            this.metrics = metrics;
            return this;
        }

        public JobBuilder configmap(List<Configmap> configmap) {
            this.configmap = configmap;
            return this;
        }

        @JsonIgnore
        public JobBuilder envConfigmaps(Map<String, Configmap> envConfigmaps) {
            this.envConfigmaps = envConfigmaps;
            return this;
        }

        @JsonIgnore
        public JobBuilder dispatchTime(long dispatchTime) {
            this.dispatchTime = dispatchTime;
            return this;
        }

        @JsonIgnore
        public JobBuilder priorMetrics(LinkedList<Set<Metrics>> priorMetrics) {
            this.priorMetrics = priorMetrics;
            return this;
        }

        @JsonIgnore
        public JobBuilder responseDataTemp(List<CollectRep.MetricsData> responseDataTemp) {
            this.responseDataTemp = responseDataTemp;
            return this;
        }

        public Job build() {
            return new Job(this.id, this.tenantId, this.monitorId, this.hide, this.category, this.app, this.name, this.help, this.helpLink, this.timestamp, this.interval, this.isCyclic, this.params, this.metrics, this.configmap, this.envConfigmaps, this.dispatchTime, this.priorMetrics, this.responseDataTemp);
        }

        public String toString() {
            return "Job.JobBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", monitorId=" + this.monitorId + ", hide=" + this.hide + ", category=" + this.category + ", app=" + this.app + ", name=" + this.name + ", help=" + this.help + ", helpLink=" + this.helpLink + ", timestamp=" + this.timestamp + ", interval=" + this.interval + ", isCyclic=" + this.isCyclic + ", params=" + this.params + ", metrics=" + this.metrics + ", configmap=" + this.configmap + ", envConfigmaps=" + this.envConfigmaps + ", dispatchTime=" + this.dispatchTime + ", priorMetrics=" + this.priorMetrics + ", responseDataTemp=" + this.responseDataTemp + ")";
        }
    }
}

