/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import com.google.common.base.Objects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.hertzbeat.common.entity.manager.JsonTagListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.TagItem;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert_define")
@Schema(description="Alarm Threshold Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class AlertDefine {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Threshold Id", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Monitoring Type", example="linux", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    @NotNull
    private @Size(max=100) @NotNull String app;
    @Schema(title="Monitoring Metrics", example="cpu", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    @NotNull
    private @Size(max=100) @NotNull String metric;
    @Schema(title="Monitoring Metrics Field", example="usage", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    private @Size(max=100) String field;
    @Schema(title="Is Apply All Default", example="false", accessMode=Schema.AccessMode.READ_WRITE)
    private boolean preset;
    @Schema(title="Alarm Threshold Expr", example="usage>90", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=2048)
    @Column(length=2048)
    private @Size(max=2048) String expr;
    @Schema(title="Alarm Level 0:High-Emergency-Critical Alarm 1:Medium-Critical-Critical Alarm 2:Low-Warning-Warning", example="1", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    @Max(value=2L)
    private @Min(value=0L) @Max(value=2L) byte priority;
    @Schema(title="Alarm Trigger Times.The alarm is triggered only after the required number of times is reached", example="3", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    @Max(value=10L)
    private @Min(value=0L) @Max(value=10L) Integer times;
    @Schema(description="Tags(status:success,env:prod)", example="{name: key1, value: value1}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonTagListAttributeConverter.class)
    @Column(length=2048)
    private List<TagItem> tags;
    @Schema(title="Is Enable", example="true", accessMode=Schema.AccessMode.READ_WRITE)
    private boolean enable = true;
    @Schema(title="Is Send Alarm Recover Notice", example="false", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(columnDefinition="boolean default false")
    private boolean recoverNotice = false;
    @Schema(title="Alarm Template", example="linux {monitor_name}: {monitor_id} cpu usage high", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=2048)
    @Column(length=2048)
    private @Size(max=2048) String template;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlertDefine)) {
            return false;
        }
        AlertDefine that = (AlertDefine)o;
        return this.priority == that.priority && Objects.equal((Object)this.app, (Object)that.app) && Objects.equal((Object)this.metric, (Object)that.metric) && Objects.equal((Object)this.field, (Object)that.field) && Objects.equal((Object)this.expr, (Object)that.expr) && Objects.equal((Object)this.times, (Object)that.times) && Objects.equal((Object)this.template, (Object)that.template);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.app, this.metric, this.field, this.expr, this.priority, this.times, this.template});
    }

    public static AlertDefineBuilder builder() {
        return new AlertDefineBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getApp() {
        return this.app;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getField() {
        return this.field;
    }

    public boolean isPreset() {
        return this.preset;
    }

    public String getExpr() {
        return this.expr;
    }

    public byte getPriority() {
        return this.priority;
    }

    public Integer getTimes() {
        return this.times;
    }

    public List<TagItem> getTags() {
        return this.tags;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isRecoverNotice() {
        return this.recoverNotice;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setPreset(boolean preset) {
        this.preset = preset;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setTimes(Integer times) {
        this.times = times;
    }

    public void setTags(List<TagItem> tags) {
        this.tags = tags;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setRecoverNotice(boolean recoverNotice) {
        this.recoverNotice = recoverNotice;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public String toString() {
        return "AlertDefine(id=" + this.getId() + ", app=" + this.getApp() + ", metric=" + this.getMetric() + ", field=" + this.getField() + ", preset=" + this.isPreset() + ", expr=" + this.getExpr() + ", priority=" + this.getPriority() + ", times=" + this.getTimes() + ", tags=" + this.getTags() + ", enable=" + this.isEnable() + ", recoverNotice=" + this.isRecoverNotice() + ", template=" + this.getTemplate() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public AlertDefine(Long id, String app, String metric, String field, boolean preset, String expr, byte priority, Integer times, List<TagItem> tags, boolean enable, boolean recoverNotice, String template, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.app = app;
        this.metric = metric;
        this.field = field;
        this.preset = preset;
        this.expr = expr;
        this.priority = priority;
        this.times = times;
        this.tags = tags;
        this.enable = enable;
        this.recoverNotice = recoverNotice;
        this.template = template;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public AlertDefine() {
    }

    public static class AlertDefineBuilder {
        private Long id;
        private String app;
        private String metric;
        private String field;
        private boolean preset;
        private String expr;
        private byte priority;
        private Integer times;
        private List<TagItem> tags;
        private boolean enable;
        private boolean recoverNotice;
        private String template;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        AlertDefineBuilder() {
        }

        public AlertDefineBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AlertDefineBuilder app(String app) {
            this.app = app;
            return this;
        }

        public AlertDefineBuilder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public AlertDefineBuilder field(String field) {
            this.field = field;
            return this;
        }

        public AlertDefineBuilder preset(boolean preset) {
            this.preset = preset;
            return this;
        }

        public AlertDefineBuilder expr(String expr) {
            this.expr = expr;
            return this;
        }

        public AlertDefineBuilder priority(byte priority) {
            this.priority = priority;
            return this;
        }

        public AlertDefineBuilder times(Integer times) {
            this.times = times;
            return this;
        }

        public AlertDefineBuilder tags(List<TagItem> tags) {
            this.tags = tags;
            return this;
        }

        public AlertDefineBuilder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public AlertDefineBuilder recoverNotice(boolean recoverNotice) {
            this.recoverNotice = recoverNotice;
            return this;
        }

        public AlertDefineBuilder template(String template) {
            this.template = template;
            return this;
        }

        public AlertDefineBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AlertDefineBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public AlertDefineBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AlertDefineBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public AlertDefine build() {
            return new AlertDefine(this.id, this.app, this.metric, this.field, this.preset, this.expr, this.priority, this.times, this.tags, this.enable, this.recoverNotice, this.template, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "AlertDefine.AlertDefineBuilder(id=" + this.id + ", app=" + this.app + ", metric=" + this.metric + ", field=" + this.field + ", preset=" + this.preset + ", expr=" + this.expr + ", priority=" + this.priority + ", times=" + this.times + ", tags=" + this.tags + ", enable=" + this.enable + ", recoverNotice=" + this.recoverNotice + ", template=" + this.template + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

