/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.unit.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.hertzbeat.collector.dispatch.unit.DataUnit;
import org.apache.hertzbeat.collector.dispatch.unit.UnitConvert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class DataSizeConvert
implements UnitConvert {
    private static final Logger log = LoggerFactory.getLogger(DataSizeConvert.class);

    @Override
    public String convert(String value, String originUnit, String newUnit) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (!this.checkUnit(originUnit) || !this.checkUnit(newUnit)) {
            return null;
        }
        if (originUnit.equalsIgnoreCase(newUnit)) {
            log.warn("The origin unit is the same as the new unit, no need to convert");
            return value;
        }
        BigDecimal size = new BigDecimal(value);
        for (DataUnit dataUnit : DataUnit.values()) {
            if (dataUnit.getUnit().equals(originUnit.toUpperCase())) {
                size = size.multiply(new BigDecimal(dataUnit.getScale()));
            }
            if (!dataUnit.getUnit().equals(newUnit.toUpperCase())) continue;
            size = size.divide(new BigDecimal(dataUnit.getScale()), 12, RoundingMode.HALF_UP);
        }
        return size.setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }

    @Override
    public boolean checkUnit(String unit) {
        if (unit == null || unit.isEmpty()) {
            return false;
        }
        for (DataUnit dataUnit : DataUnit.values()) {
            if (!dataUnit.getUnit().equals(unit.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

