/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.prometheus;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import org.apache.commons.net.util.Base64;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.collector.collect.prometheus.parser.MetricFamily;
import org.apache.hertzbeat.collector.collect.prometheus.parser.TextParser;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.PrometheusProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PrometheusAutoCollectImpl {
    private static final Logger log = LoggerFactory.getLogger(PrometheusAutoCollectImpl.class);
    private final Set<Integer> defaultSuccessStatusCodes = Stream.of(200, 201, 202, 300, 301, 302).collect(Collectors.toSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CollectRep.MetricsData> collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        block22: {
            try {
                this.validateParams(metrics);
            }
            catch (Exception e) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg(e.getMessage());
                return null;
            }
            HttpContext httpContext = this.createHttpContext(metrics.getPrometheus());
            HttpUriRequest request = this.createHttpRequest(metrics.getPrometheus());
            try {
                CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request, httpContext);
                int statusCode = response.getStatusLine().getStatusCode();
                boolean isSuccessInvoke = this.defaultSuccessStatusCodes.contains(statusCode);
                log.debug("http response status: {}", (Object)statusCode);
                if (!isSuccessInvoke) {
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg("StatusCode " + statusCode);
                    List<CollectRep.MetricsData> list = null;
                    return list;
                }
                String resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                long collectTime = System.currentTimeMillis();
                builder.setTime(collectTime);
                if (resp == null || "".equals(resp)) {
                    log.error("http response content is empty, status: {}.", (Object)statusCode);
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg("http response content is empty");
                    break block22;
                }
                try {
                    List<CollectRep.MetricsData> list = this.parseResponseByPrometheusExporter(resp, metrics.getAliasFields(), builder);
                    return list;
                }
                catch (Exception e) {
                    try {
                        log.info("parse error: {}.", (Object)e.getMessage(), (Object)e);
                        builder.setCode(CollectRep.Code.FAIL);
                        builder.setMsg("parse response data error:" + e.getMessage());
                    }
                    catch (ClientProtocolException e1) {
                        String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e1);
                        log.error(errorMsg);
                        builder.setCode(CollectRep.Code.UN_CONNECTABLE);
                        builder.setMsg(errorMsg);
                    }
                    catch (UnknownHostException e2) {
                        String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e2);
                        log.info(errorMsg);
                        builder.setCode(CollectRep.Code.UN_REACHABLE);
                        builder.setMsg("unknown host:" + errorMsg);
                    }
                    catch (InterruptedIOException | ConnectException | SSLException e3) {
                        String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e3);
                        log.info(errorMsg);
                        builder.setCode(CollectRep.Code.UN_CONNECTABLE);
                        builder.setMsg(errorMsg);
                    }
                    catch (IOException e4) {
                        String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e4);
                        log.info(errorMsg);
                        builder.setCode(CollectRep.Code.FAIL);
                        builder.setMsg(errorMsg);
                    }
                    catch (Exception e2) {
                        String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e2);
                        log.error(errorMsg, (Throwable)e2);
                        builder.setCode(CollectRep.Code.FAIL);
                        builder.setMsg(errorMsg);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (request != null) {
                    request.abort();
                }
            }
        }
        return Collections.singletonList(builder.build());
    }

    public String supportProtocol() {
        return "prometheus";
    }

    private void validateParams(Metrics metrics) throws Exception {
        if (metrics == null || metrics.getPrometheus() == null) {
            throw new Exception("Prometheus collect must has prometheus params");
        }
        PrometheusProtocol protocol = metrics.getPrometheus();
        if (protocol.getPath() == null || "".equals(protocol.getPath()) || !protocol.getPath().startsWith("/")) {
            protocol.setPath((String)(protocol.getPath() == null ? "/" : "/" + protocol.getPath().trim()));
        }
    }

    private List<CollectRep.MetricsData> parseResponseByPrometheusExporter(String resp, List<String> aliasFields, CollectRep.MetricsData.Builder builder) {
        Map<String, MetricFamily> metricFamilyMap = TextParser.textToMetricFamilies(resp);
        LinkedList<CollectRep.MetricsData> metricsDataList = new LinkedList<CollectRep.MetricsData>();
        for (Map.Entry<String, MetricFamily> entry : metricFamilyMap.entrySet()) {
            builder.clearMetrics();
            builder.clearFields();
            builder.clearValues();
            String metricsName = entry.getKey();
            builder.setMetrics(metricsName);
            MetricFamily metricFamily = entry.getValue();
            if (metricFamily.getMetricList().isEmpty()) continue;
            LinkedList metricsFields = new LinkedList();
            for (int index = 0; index < metricFamily.getMetricList().size(); ++index) {
                MetricFamily.Metric metric = metricFamily.getMetricList().get(index);
                if (index == 0) {
                    metric.getLabels().forEach(label -> {
                        metricsFields.add(label.getName());
                        builder.addFields(CollectRep.Field.newBuilder().setName(label.getName()).setType(1).setLabel(true).build());
                    });
                    builder.addFields(CollectRep.Field.newBuilder().setName("value").setType(0).setLabel(false).build());
                }
                Map<String, String> labelMap = metric.getLabels().stream().collect(Collectors.toMap(MetricFamily.Label::getName, MetricFamily.Label::getValue));
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String field : metricsFields) {
                    String fieldValue = labelMap.get(field);
                    valueRowBuilder.addColumns(fieldValue == null ? "&nbsp;" : fieldValue);
                }
                valueRowBuilder.addColumns(String.valueOf(metric.getValue()));
                builder.addValues(valueRowBuilder.build());
            }
            metricsDataList.add(builder.build());
        }
        return metricsDataList;
    }

    public HttpContext createHttpContext(PrometheusProtocol protocol) {
        PrometheusProtocol.Authorization auth = protocol.getAuthorization();
        if (auth != null && "Digest Auth".equals(auth.getType())) {
            HttpClientContext clientContext = new HttpClientContext();
            if (StringUtils.hasText((String)auth.getDigestAuthUsername()) && StringUtils.hasText((String)auth.getDigestAuthPassword())) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(auth.getDigestAuthUsername(), auth.getDigestAuthPassword());
                provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(new HttpHost(protocol.getHost(), Integer.parseInt(protocol.getPort())), (AuthScheme)new DigestScheme());
                clientContext.setCredentialsProvider((CredentialsProvider)provider);
                clientContext.setAuthCache((AuthCache)authCache);
                return clientContext;
            }
        }
        return null;
    }

    public HttpUriRequest createHttpRequest(PrometheusProtocol protocol) {
        RequestBuilder requestBuilder = RequestBuilder.get();
        Map params = protocol.getParams();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry param : params.entrySet()) {
                if (!StringUtils.hasText((String)((String)param.getValue()))) continue;
                requestBuilder.addParameter((String)param.getKey(), (String)param.getValue());
            }
        }
        requestBuilder.addHeader("Connection", "keep-alive");
        requestBuilder.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.76 Safari/537.36");
        Map headers = protocol.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                if (!StringUtils.hasText((String)((String)entry.getValue()))) continue;
                requestBuilder.addHeader(CollectUtil.replaceUriSpecialChar((String)entry.getKey()), CollectUtil.replaceUriSpecialChar((String)entry.getValue()));
            }
        }
        requestBuilder.addHeader("Accept", "*/*");
        if (protocol.getAuthorization() != null) {
            PrometheusProtocol.Authorization authorization = protocol.getAuthorization();
            if ("Bearer Token".equalsIgnoreCase(authorization.getType())) {
                String string = "Bearer " + authorization.getBearerTokenToken();
                requestBuilder.addHeader("Authorization", string);
            } else if ("Basic Auth".equals(authorization.getType()) && StringUtils.hasText((String)authorization.getBasicAuthUsername()) && StringUtils.hasText((String)authorization.getBasicAuthPassword())) {
                String string = authorization.getBasicAuthUsername() + ":" + authorization.getBasicAuthPassword();
                String encodedAuth = new String(Base64.encodeBase64((byte[])string.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                requestBuilder.addHeader("Authorization", "Basic " + encodedAuth);
            }
        }
        if (StringUtils.hasLength((String)protocol.getPayload())) {
            requestBuilder.setEntity((HttpEntity)new StringEntity(protocol.getPayload(), StandardCharsets.UTF_8));
        }
        String uri = CollectUtil.replaceUriSpecialChar(protocol.getPath());
        if (IpDomainUtil.isHasSchema((String)protocol.getHost())) {
            requestBuilder.setUri(protocol.getHost() + ":" + protocol.getPort() + uri);
        } else {
            String string = IpDomainUtil.checkIpAddressType((String)protocol.getHost());
            String baseUri = "ipv6".equals(string) ? String.format("[%s]:%s%s", protocol.getHost(), protocol.getPort(), uri) : String.format("%s:%s%s", protocol.getHost(), protocol.getPort(), uri);
            boolean ssl = Boolean.parseBoolean(protocol.getSsl());
            if (ssl) {
                requestBuilder.setUri("https://" + baseUri);
            } else {
                requestBuilder.setUri("http://" + baseUri);
            }
        }
        int n = CollectUtil.getTimeout(protocol.getTimeout(), 0);
        if (n > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(n).setSocketTimeout(n).setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        }
        return requestBuilder.build();
    }

    public static PrometheusAutoCollectImpl getInstance() {
        return SingleInstance.INSTANCE;
    }

    private static class SingleInstance {
        private static final PrometheusAutoCollectImpl INSTANCE = new PrometheusAutoCollectImpl();

        private SingleInstance() {
        }
    }
}

