/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.memcached;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.MemcachedProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(MemcachedCollectImpl.class);
    private static final String STATS = "stats";
    private static final String STATS_SETTINGS = "stats settings";
    private static final String STATS_ITEMS = "stats items";
    private static final String STATS_SIZES = "stats sizes";
    private static final String STATS_END_RSP = "END";

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getMemcached() == null) {
            throw new IllegalArgumentException("Memcached collect must has Memcached params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        MemcachedProtocol memcachedProtocol = metrics.getMemcached();
        String memcachedHost = memcachedProtocol.getHost();
        String memcachedPort = memcachedProtocol.getPort();
        Socket socket = null;
        try {
            socket = new Socket();
            InetSocketAddress socketAddress = new InetSocketAddress(memcachedHost, Integer.parseInt(memcachedPort));
            socket.connect(socketAddress);
            if (socket.isConnected()) {
                long responseTime = System.currentTimeMillis() - startTime;
                PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                HashMap<String, String> resultMap = new HashMap<String, String>(128);
                MemcachedCollectImpl.parseCmdResponse(resultMap, in, out, STATS);
                MemcachedCollectImpl.parseCmdResponse(resultMap, in, out, STATS_SETTINGS);
                MemcachedCollectImpl.parseSizesOutput(resultMap, in, out);
                resultMap.put("responseTime", Long.toString(responseTime));
                in.close();
                out.close();
                socket.close();
                List aliasFields = metrics.getAliasFields();
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String field : aliasFields) {
                    String fieldValue = (String)resultMap.get(field);
                    valueRowBuilder.addColumns(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
                }
                builder.addValues(valueRowBuilder.build());
            } else {
                builder.setCode(CollectRep.Code.UN_CONNECTABLE);
                builder.setMsg("Peer connect failed:");
            }
        }
        catch (UnknownHostException unknownHostException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)unknownHostException);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("UnknownHost:" + errorMsg);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)socketTimeoutException);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("Socket connect timeout: " + errorMsg);
        }
        catch (IOException ioException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)ioException);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("Connect fail:" + errorMsg);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    private static void parseCmdResponse(Map<String, String> statsMap, BufferedReader in, PrintWriter out, String cmd) throws IOException {
        String line;
        out.println(cmd);
        while ((line = in.readLine()) != null && !line.equals(STATS_END_RSP)) {
            String[] parts = line.split(" ");
            if (parts.length != 3) continue;
            statsMap.put(parts[1], parts[2]);
        }
    }

    private static void parseSizesOutput(Map<String, String> statsMap, BufferedReader in, PrintWriter out) throws IOException {
        String line;
        out.println(STATS_SIZES);
        while ((line = in.readLine()) != null && !line.equals(STATS_END_RSP)) {
            String[] parts = line.split("\\s+");
            if (parts.length < 3 || !"STAT".equals(parts[0])) continue;
            statsMap.put("item_size", parts[1]);
            statsMap.put("item_count", parts[2]);
        }
    }

    @Override
    public String supportProtocol() {
        return "memcached";
    }
}

