/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.jmx;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.cache.CacheIdentifier;
import org.apache.hertzbeat.collector.collect.common.cache.ConnectionCommonCache;
import org.apache.hertzbeat.collector.collect.common.cache.JmxConnect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.JmxProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JmxCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(JmxCollectImpl.class);
    private static final String JMX_URL_PREFIX = "service:jmx:rmi:///jndi/rmi://";
    private static final String JMX_URL_SUFFIX = "/jmxrmi";
    private static final String IGNORED_STUB = "/stub/";
    private static final String SUB_ATTRIBUTE = "->";
    private final ConnectionCommonCache<CacheIdentifier, JmxConnect> connectionCommonCache = new ConnectionCommonCache();

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        Assert.isTrue((metrics != null && metrics.getJmx() != null ? 1 : 0) != 0, (String)"JMX collect must have JMX params");
        String url = metrics.getJmx().getUrl();
        if (StringUtils.hasText((String)url)) {
            Assert.doesNotContain((String)url, (String)IGNORED_STUB, (String)"JMX url prohibit contains stub, please check");
        }
    }

    @Override
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        try {
            JmxProtocol jmxProtocol = metrics.getJmx();
            JMXConnector jmxConnector = this.getConnectSession(jmxProtocol);
            MBeanServerConnection serverConnection = jmxConnector.getMBeanServerConnection();
            ObjectName objectName = new ObjectName(jmxProtocol.getObjectName());
            Set<ObjectInstance> objectInstanceSet = serverConnection.queryMBeans(objectName, null);
            Set attributeNameSet = metrics.getAliasFields().stream().map(field -> field.split(SUB_ATTRIBUTE)[0]).collect(Collectors.toSet());
            for (ObjectInstance objectInstance : objectInstanceSet) {
                ObjectName currentObjectName = objectInstance.getObjectName();
                MBeanInfo beanInfo = serverConnection.getMBeanInfo(currentObjectName);
                MBeanAttributeInfo[] attrInfos = beanInfo.getAttributes();
                String[] attributes = new String[attributeNameSet.size()];
                attributes = Arrays.stream(attrInfos).filter(item -> item.isReadable() && attributeNameSet.contains(item.getName())).map(MBeanFeatureInfo::getName).collect(Collectors.toList()).toArray(attributes);
                AttributeList attributeList = serverConnection.getAttributes(currentObjectName, attributes);
                Map<String, String> attributeValueMap = this.extractAttributeValue(attributeList);
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String aliasField : metrics.getAliasFields()) {
                    String fieldValue = attributeValueMap.get(aliasField);
                    valueRowBuilder.addColumns(fieldValue != null ? fieldValue : "&nbsp;");
                }
                builder.addValues(valueRowBuilder.build());
            }
        }
        catch (IOException exception) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)exception);
            log.error("JMX IOException :{}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error("JMX Error :{}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    @Override
    public String supportProtocol() {
        return "jmx";
    }

    private Map<String, String> extractAttributeValue(AttributeList attributeList) {
        if (attributeList == null || attributeList.isEmpty()) {
            throw new RuntimeException("attributeList is empty");
        }
        HashMap<String, String> attributeValueMap = new HashMap<String, String>(attributeList.size());
        for (Attribute attribute : attributeList.asList()) {
            Object value = attribute.getValue();
            if (value == null) {
                log.info("attribute {} value is null.", (Object)attribute.getName());
                continue;
            }
            if (value instanceof Number || value instanceof String || value instanceof ObjectName || value instanceof Boolean || value instanceof Date || value instanceof TimeUnit) {
                attributeValueMap.put(attribute.getName(), value.toString());
                continue;
            }
            if (value instanceof CompositeData) {
                CompositeData compositeData = (CompositeData)value;
                CompositeType compositeType = compositeData.getCompositeType();
                for (String typeKey : compositeType.keySet()) {
                    Object fieldValue = compositeData.get(typeKey);
                    attributeValueMap.put(attribute.getName() + SUB_ATTRIBUTE + typeKey, fieldValue.toString());
                }
                continue;
            }
            if (value instanceof String[]) {
                String[] values = (String[])value;
                StringBuilder builder = new StringBuilder();
                for (int index = 0; index < values.length; ++index) {
                    builder.append(values[index]);
                    if (index >= values.length - 1) continue;
                    builder.append(",");
                }
                attributeValueMap.put(attribute.getName(), builder.toString());
                continue;
            }
            log.warn("attribute value type {} not support.", (Object)value.getClass().getName());
        }
        return attributeValueMap;
    }

    private JMXConnector getConnectSession(JmxProtocol jmxProtocol) throws IOException {
        CacheIdentifier identifier = CacheIdentifier.builder().ip(jmxProtocol.getHost()).port(jmxProtocol.getPort()).username(jmxProtocol.getUsername()).password(jmxProtocol.getPassword()).build();
        Optional<JmxConnect> cacheOption = this.connectionCommonCache.getCache(identifier, true);
        JMXConnector conn = null;
        if (cacheOption.isPresent()) {
            JmxConnect jmxConnect = cacheOption.get();
            conn = jmxConnect.getConnection();
            try {
                conn.getMBeanServerConnection();
            }
            catch (Exception e) {
                conn = null;
                this.connectionCommonCache.removeCache(identifier);
            }
        }
        if (conn != null) {
            return conn;
        }
        Object url = jmxProtocol.getUrl() != null ? jmxProtocol.getUrl() : JMX_URL_PREFIX + jmxProtocol.getHost() + ":" + jmxProtocol.getPort() + JMX_URL_SUFFIX;
        HashMap<String, Object> environment = new HashMap<String, Object>(4);
        if (StringUtils.hasText((String)jmxProtocol.getUsername()) && StringUtils.hasText((String)jmxProtocol.getPassword())) {
            String[] credential = new String[]{jmxProtocol.getUsername(), jmxProtocol.getPassword()};
            environment.put("jmx.remote.credentials", credential);
        }
        if (Boolean.TRUE.toString().equals(jmxProtocol.getSsl())) {
            environment.put("java.naming.security.protocol", "ssl");
            SslRMIClientSocketFactory clientSocketFactory = new SslRMIClientSocketFactory();
            environment.put("jmx.remote.rmi.client.socket.factory", clientSocketFactory);
            environment.put("com.sun.jndi.rmi.factory.socket", clientSocketFactory);
        }
        JMXServiceURL jmxServiceUrl = new JMXServiceURL((String)url);
        conn = JMXConnectorFactory.connect(jmxServiceUrl, environment);
        this.connectionCommonCache.addCache(identifier, new JmxConnect(conn));
        return conn;
    }
}

