/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.icmp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.IcmpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(IcmpCollectImpl.class);

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getIcmp() == null) {
            throw new IllegalArgumentException("ICMP collect must has icmp params");
        }
    }

    @Override
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        IcmpProtocol icmp = metrics.getIcmp();
        int timeout = 6000;
        try {
            timeout = Integer.parseInt(icmp.getTimeout());
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        try {
            boolean status = InetAddress.getByName(icmp.getHost()).isReachable(timeout);
            long responseTime = System.currentTimeMillis() - startTime;
            if (!status) {
                builder.setCode(CollectRep.Code.UN_REACHABLE);
                builder.setMsg("Un Reachable, Timeout " + timeout + "ms");
                return;
            }
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : metrics.getAliasFields()) {
                if ("responseTime".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumns(Long.toString(responseTime));
                    continue;
                }
                valueRowBuilder.addColumns("&nbsp;");
            }
            builder.addValues(valueRowBuilder.build());
        }
        catch (UnknownHostException unknownHostException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)unknownHostException);
            builder.setCode(CollectRep.Code.UN_REACHABLE);
            builder.setMsg("UnknownHost " + errorMsg);
        }
        catch (IOException ioException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)ioException);
            builder.setCode(CollectRep.Code.UN_REACHABLE);
            builder.setMsg("IOException " + errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error(errorMsg, (Throwable)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    @Override
    public String supportProtocol() {
        return "icmp";
    }
}

