/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.httpsd;

import com.ecwid.consul.transport.TransportException;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.DiscoveryClient;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.DiscoveryClientManagement;
import org.apache.hertzbeat.collector.collect.httpsd.discovery.entity.ServerInfo;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.HttpsdProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsdImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(HttpsdImpl.class);
    private static final String SERVER = "server";
    @VisibleForTesting
    private DiscoveryClientManagement discoveryClientManagement = new DiscoveryClientManagement();

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        HttpsdProtocol httpsdProtocol = metrics.getHttpsd();
        if (Objects.isNull(httpsdProtocol) || httpsdProtocol.isInvalid()) {
            throw new IllegalArgumentException("http_sd collect must have a valid http_sd protocol param! ");
        }
    }

    @Override
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        HttpsdProtocol httpsdProtocol = metrics.getHttpsd();
        try (DiscoveryClient discoveryClient = this.discoveryClientManagement.getClient(httpsdProtocol);){
            this.collectMetrics(builder, metrics, discoveryClient);
        }
        catch (TransportException e1) {
            String errorMsg = "Consul " + CommonUtil.getMessageFromThrowable((Throwable)e1);
            log.error(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error(errorMsg, (Throwable)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    private void collectMetrics(CollectRep.MetricsData.Builder builder, Metrics metrics, DiscoveryClient discoveryClient) {
        long beginTime = System.currentTimeMillis();
        if (StringUtils.equals((CharSequence)metrics.getName(), (CharSequence)SERVER)) {
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            ServerInfo serverInfo = discoveryClient.getServerInfo();
            metrics.getAliasFields().forEach(fieldName -> {
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)"responseTime", (CharSequence[])new CharSequence[]{fieldName})) {
                    valueRowBuilder.addColumns(String.valueOf(System.currentTimeMillis() - beginTime));
                } else {
                    this.addColumnIfMatched((String)fieldName, serverInfo, valueRowBuilder);
                }
            });
            builder.addValues(valueRowBuilder.build());
        } else {
            discoveryClient.getServices().forEach(serviceInstance -> {
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                metrics.getAliasFields().forEach(fieldName -> this.addColumnIfMatched((String)fieldName, serviceInstance, valueRowBuilder));
                builder.addValues(valueRowBuilder.build());
            });
        }
    }

    @Override
    public String supportProtocol() {
        return "httpsd";
    }

    private boolean checkParamsFailed(HttpsdProtocol httpsd) {
        return Objects.isNull(httpsd) || httpsd.isInvalid();
    }

    private void addColumnIfMatched(String fieldName, Object sourceObj, CollectRep.ValueRow.Builder valueRowBuilder) {
        String columnValue = null;
        try {
            Field declaredField = sourceObj.getClass().getDeclaredField(fieldName);
            declaredField.setAccessible(Boolean.TRUE);
            columnValue = String.valueOf(declaredField.get(sourceObj));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.warn("No such field for {}", (Object)fieldName);
        }
        valueRowBuilder.addColumns(StringUtils.isBlank(columnValue) ? "&nbsp;" : columnValue);
    }

    public void setDiscoveryClientManagement(DiscoveryClientManagement discoveryClientManagement) {
        this.discoveryClientManagement = discoveryClientManagement;
    }
}

