/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ftp;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.FtpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FtpCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(FtpCollectImpl.class);
    private static final String ANONYMOUS = "anonymous";
    private static final String PASSWORD = "password";

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getFtp() == null) {
            throw new IllegalArgumentException("Ftp collect must has ftp params.");
        }
        FtpProtocol ftpProtocol = metrics.getFtp();
        Assert.hasText((String)ftpProtocol.getHost(), (String)"Ftp Protocol host is required.");
        Assert.hasText((String)ftpProtocol.getPort(), (String)"Ftp Protocol port is required.");
        Assert.hasText((String)ftpProtocol.getDirection(), (String)"Ftp Protocol direction is required.");
        Assert.hasText((String)ftpProtocol.getTimeout(), (String)"Ftp Protocol timeout is required.");
    }

    @Override
    public void collect(CollectRep.MetricsData.Builder builder, long monitorId, String app, Metrics metrics) {
        FTPClient ftpClient = new FTPClient();
        FtpProtocol ftpProtocol = metrics.getFtp();
        ftpClient.setControlKeepAliveReplyTimeout(Integer.parseInt(ftpProtocol.getTimeout()));
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        try {
            Map<String, String> valueMap = this.collectValue(ftpClient, ftpProtocol);
            metrics.getAliasFields().forEach(it -> {
                if (valueMap.containsKey(it)) {
                    String fieldValue = (String)valueMap.get(it);
                    valueRowBuilder.addColumns(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
                } else {
                    valueRowBuilder.addColumns("&nbsp;");
                }
            });
        }
        catch (Exception e) {
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(e.getMessage());
            return;
        }
        builder.addValues(valueRowBuilder.build());
    }

    private Map<String, String> collectValue(FTPClient ftpClient, FtpProtocol ftpProtocol) {
        String responseTime;
        boolean isActive;
        try {
            long startTime = System.currentTimeMillis();
            this.connect(ftpClient, ftpProtocol);
            this.login(ftpClient, ftpProtocol);
            isActive = ftpClient.changeWorkingDirectory(ftpProtocol.getDirection());
            long endTime = System.currentTimeMillis();
            responseTime = String.valueOf(endTime - startTime);
            ftpClient.disconnect();
        }
        catch (Exception e) {
            log.info("[FTPClient] error: {}", (Object)CommonUtil.getMessageFromThrowable((Throwable)e), (Object)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return new HashMap<String, String>(8){
            {
                super(initialCapacity);
                this.put("isActive", Boolean.toString(isActive));
                this.put("responseTime", responseTime);
            }
        };
    }

    private void login(FTPClient ftpClient, FtpProtocol ftpProtocol) {
        try {
            if (StringUtils.hasText((String)ftpProtocol.getUsername()) && StringUtils.hasText((String)ftpProtocol.getPassword())) {
                if (!ftpClient.login(ftpProtocol.getUsername(), ftpProtocol.getPassword())) {
                    throw new IllegalArgumentException("The username or password may be wrong.");
                }
                return;
            }
            if (!ftpClient.login(ANONYMOUS, PASSWORD)) {
                throw new IllegalArgumentException("The server may not allow anonymous access, we need to username and password.");
            }
        }
        catch (Exception e) {
            log.info("[ftp login] error: {}", (Object)CommonUtil.getMessageFromThrowable((Throwable)e), (Object)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void connect(FTPClient ftpClient, FtpProtocol ftpProtocol) {
        try {
            ftpClient.connect(ftpProtocol.getHost(), Integer.parseInt(ftpProtocol.getPort()));
        }
        catch (Exception e) {
            log.info("[ftp connection] error: {}", (Object)CommonUtil.getMessageFromThrowable((Throwable)e), (Object)e);
            throw new IllegalArgumentException("The host or port may be wrong.");
        }
    }

    @Override
    public String supportProtocol() {
        return "ftp";
    }
}

