/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc;

import com.google.protobuf.Message;
import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import io.greptime.common.Display;
import io.greptime.common.Endpoint;
import io.greptime.common.util.Clock;
import io.greptime.common.util.Cpus;
import io.greptime.common.util.DirectExecutor;
import io.greptime.common.util.Ensures;
import io.greptime.common.util.ExecutorServiceHelper;
import io.greptime.common.util.MetricsUtil;
import io.greptime.common.util.NamedThreadFactory;
import io.greptime.common.util.ObjectPool;
import io.greptime.common.util.RefCell;
import io.greptime.common.util.SharedThreadPool;
import io.greptime.common.util.StringBuilderHelper;
import io.greptime.common.util.SystemPropertyUtil;
import io.greptime.common.util.ThreadPoolUtil;
import io.greptime.rpc.Context;
import io.greptime.rpc.IdChannel;
import io.greptime.rpc.ManagedChannelHelper;
import io.greptime.rpc.MarshallerRegistry;
import io.greptime.rpc.Observer;
import io.greptime.rpc.RpcClient;
import io.greptime.rpc.RpcOptions;
import io.greptime.rpc.errors.ConnectFailException;
import io.greptime.rpc.errors.InvokeTimeoutException;
import io.greptime.rpc.errors.OnlyErrorMessage;
import io.greptime.rpc.errors.RemotingException;
import io.greptime.rpc.interceptors.ClientRequestLimitInterceptor;
import io.greptime.rpc.interceptors.ContextToHeadersInterceptor;
import io.greptime.rpc.interceptors.MetricInterceptor;
import io.greptime.rpc.limit.Gradient2Limit;
import io.greptime.rpc.limit.LimitMetricRegistry;
import io.greptime.rpc.limit.RequestLimiterBuilder;
import io.greptime.rpc.limit.VegasLimit;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClient
implements RpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcClient.class);
    private static final SharedThreadPool SHARED_ASYNC_POOL = new SharedThreadPool((ObjectPool.Resource)new ObjectPool.Resource<ExecutorService>(){

        public ExecutorService create() {
            return GrpcClient.newSharedPool();
        }

        public void close(ExecutorService ins) {
            ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)ins);
        }
    });
    private static final int CONN_RESET_THRESHOLD = SystemPropertyUtil.getInt((String)"greptimedb.grpc.conn.failures.reset_threshold", (int)3);
    private static final String LIMITER_NAME = "grpc_call";
    private static final String REQ_RT = "req_rt";
    private static final String REQ_FAILED = "req_failed";
    private static final String UNARY_CALL = "unary-call";
    private static final String SERVER_STREAMING_CALL = "server-streaming-call";
    private static final String CLIENT_STREAMING_CALL = "client-streaming-call";
    private final Map<Endpoint, IdChannel> managedChannelPool = new ConcurrentHashMap<Endpoint, IdChannel>();
    private final Map<Endpoint, AtomicInteger> transientFailures = new ConcurrentHashMap<Endpoint, AtomicInteger>();
    private final List<ClientInterceptor> interceptors = new CopyOnWriteArrayList<ClientInterceptor>();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final List<RpcClient.ConnectionObserver> connectionObservers = new CopyOnWriteArrayList<RpcClient.ConnectionObserver>();
    private final MarshallerRegistry marshallerRegistry;
    private RpcOptions opts;
    private Executor asyncPool;
    private boolean useSharedRpcPool;

    public GrpcClient(MarshallerRegistry marshallerRegistry) {
        this.marshallerRegistry = marshallerRegistry;
    }

    public boolean init(RpcOptions opts) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Grpc client has started");
        }
        this.opts = ((RpcOptions)Ensures.ensureNonNull((Object)opts, (String)"null `GrpcClient.opts`")).copy();
        this.useSharedRpcPool = this.opts.isUseRpcSharedPool();
        this.asyncPool = this.useSharedRpcPool ? (Executor)SHARED_ASYNC_POOL.getObject() : new DirectExecutor("rpc-direct-pool");
        this.initInterceptors();
        return true;
    }

    public void shutdownGracefully() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        if (this.useSharedRpcPool) {
            SHARED_ASYNC_POOL.returnObject((Object)((ExecutorService)this.asyncPool));
        }
        this.asyncPool = null;
        this.closeAllChannels();
    }

    public boolean checkConnection(Endpoint endpoint) {
        return this.checkConnection(endpoint, false);
    }

    public boolean checkConnection(Endpoint endpoint, boolean createIfAbsent) {
        Ensures.ensureNonNull((Object)endpoint, (String)"null `endpoint`");
        return this.checkChannel(endpoint, createIfAbsent);
    }

    public void closeConnection(Endpoint endpoint) {
        Ensures.ensureNonNull((Object)endpoint, (String)"null `endpoint`");
        this.closeChannel(endpoint);
    }

    public void registerConnectionObserver(RpcClient.ConnectionObserver observer) {
        this.connectionObservers.add(observer);
    }

    public <Req, Resp> Resp invokeSync(Endpoint endpoint, Req request, Context ctx, long timeoutMs) throws RemotingException {
        long timeout = this.calcTimeout(timeoutMs);
        final CompletableFuture future = new CompletableFuture();
        this.invokeAsync(endpoint, request, ctx, new Observer<Resp>(){

            public void onNext(Resp value) {
                future.complete(value);
            }

            public void onError(Throwable err) {
                future.completeExceptionally(err);
            }
        }, timeout);
        try {
            return (Resp)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new InvokeTimeoutException((Throwable)e);
        }
        catch (Throwable t) {
            future.cancel(true);
            throw new RemotingException(t);
        }
    }

    public <Req, Resp> void invokeAsync(Endpoint endpoint, Req request, final Context ctx, final Observer<Resp> observer, long timeoutMs) {
        GrpcClient.checkArgs(endpoint, request, ctx, observer);
        ContextToHeadersInterceptor.setCurrentCtx(ctx);
        MethodDescriptor<Message, Message> method = this.getCallMethod(request, MethodDescriptor.MethodType.UNARY);
        long timeout = this.calcTimeout(timeoutMs);
        CallOptions callOpts = CallOptions.DEFAULT.withDeadlineAfter(timeout, TimeUnit.MILLISECONDS).withExecutor(this.getObserverExecutor(observer));
        final String methodName = method.getFullMethodName();
        final String address = endpoint.toString();
        final long startCall = Clock.defaultClock().getTick();
        Channel ch = this.getCheckedChannel(endpoint, err -> {
            this.attachErrMsg((Throwable)err, UNARY_CALL, methodName, address, startCall, -1L, ctx);
            observer.onError(err);
        });
        if (ch == null) {
            return;
        }
        final String target = GrpcClient.target(ch, address);
        ClientCalls.asyncUnaryCall((ClientCall)ch.newCall(method, callOpts), (Object)((Message)request), (StreamObserver)new StreamObserver<Message>(){

            public void onNext(Message value) {
                this.onReceived(false);
                observer.onNext((Object)value);
            }

            public void onError(Throwable err) {
                GrpcClient.this.attachErrMsg(err, GrpcClient.UNARY_CALL, methodName, target, startCall, this.onReceived(true), ctx);
                observer.onError(err);
            }

            public void onCompleted() {
                observer.onCompleted();
            }

            private long onReceived(boolean onError) {
                long duration = Clock.defaultClock().duration(startCall);
                MetricsUtil.timer((Object[])new Object[]{GrpcClient.REQ_RT, methodName}).update(duration, TimeUnit.MILLISECONDS);
                MetricsUtil.timer((Object[])new Object[]{GrpcClient.REQ_RT, methodName, address}).update(duration, TimeUnit.MILLISECONDS);
                if (onError) {
                    MetricsUtil.meter((Object[])new Object[]{GrpcClient.REQ_FAILED, methodName}).mark();
                    MetricsUtil.meter((Object[])new Object[]{GrpcClient.REQ_FAILED, methodName, address}).mark();
                }
                return duration;
            }
        });
    }

    public <Req, Resp> void invokeServerStreaming(Endpoint endpoint, Req request, final Context ctx, final Observer<Resp> observer) {
        GrpcClient.checkArgs(endpoint, request, ctx, observer);
        ContextToHeadersInterceptor.setCurrentCtx(ctx);
        MethodDescriptor<Message, Message> method = this.getCallMethod(request, MethodDescriptor.MethodType.SERVER_STREAMING);
        CallOptions callOpts = CallOptions.DEFAULT.withExecutor(this.getObserverExecutor(observer));
        final String methodName = method.getFullMethodName();
        String address = endpoint.toString();
        final long startCall = Clock.defaultClock().getTick();
        Channel ch = this.getCheckedChannel(endpoint, err -> {
            this.attachErrMsg((Throwable)err, SERVER_STREAMING_CALL, methodName, address, startCall, -1L, ctx);
            observer.onError(err);
        });
        if (ch == null) {
            return;
        }
        final String target = GrpcClient.target(ch, address);
        ClientCalls.asyncServerStreamingCall((ClientCall)ch.newCall(method, callOpts), (Object)((Message)request), (StreamObserver)new StreamObserver<Message>(){

            public void onNext(Message value) {
                observer.onNext((Object)value);
            }

            public void onError(Throwable err) {
                GrpcClient.this.attachErrMsg(err, GrpcClient.SERVER_STREAMING_CALL, methodName, target, startCall, -1L, ctx);
                observer.onError(err);
            }

            public void onCompleted() {
                observer.onCompleted();
            }
        });
    }

    public <Req, Resp> Observer<Req> invokeClientStreaming(Endpoint endpoint, Req defaultReqIns, final Context ctx, final Observer<Resp> respObserver) {
        GrpcClient.checkArgs(endpoint, defaultReqIns, ctx, respObserver);
        ContextToHeadersInterceptor.setCurrentCtx(ctx);
        MethodDescriptor<Message, Message> method = this.getCallMethod(defaultReqIns, MethodDescriptor.MethodType.CLIENT_STREAMING);
        CallOptions callOpts = CallOptions.DEFAULT.withExecutor(this.getObserverExecutor(respObserver));
        final String methodName = method.getFullMethodName();
        String address = endpoint.toString();
        final long startCall = Clock.defaultClock().getTick();
        RefCell refErr = new RefCell();
        Channel ch = this.getCheckedChannel(endpoint, err -> {
            this.attachErrMsg((Throwable)err, CLIENT_STREAMING_CALL, methodName, address, startCall, -1L, ctx);
            refErr.set(err);
        });
        if (ch == null) {
            respObserver.onError((Throwable)refErr.get());
            return new Observer.RejectedObserver((Throwable)refErr.get());
        }
        final String target = GrpcClient.target(ch, address);
        final StreamObserver gRpcObs = ClientCalls.asyncClientStreamingCall((ClientCall)ch.newCall(method, callOpts), (StreamObserver)new StreamObserver<Message>(){

            public void onNext(Message value) {
                respObserver.onNext((Object)value);
            }

            public void onError(Throwable err) {
                GrpcClient.this.attachErrMsg(err, GrpcClient.CLIENT_STREAMING_CALL, methodName, target, startCall, -1L, ctx);
                respObserver.onError(err);
            }

            public void onCompleted() {
                respObserver.onCompleted();
            }
        });
        return new Observer<Req>(){

            public void onNext(Req value) {
                gRpcObs.onNext((Object)((Message)value));
            }

            public void onError(Throwable err) {
                gRpcObs.onError(err);
            }

            public void onCompleted() {
                gRpcObs.onCompleted();
            }
        };
    }

    public void addInterceptor(ClientInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    private void initInterceptors() {
        RpcOptions.LimitKind kind;
        if (this.opts.isEnableMetricInterceptor()) {
            this.addInterceptor(new MetricInterceptor());
        }
        if ((kind = this.opts.getLimitKind()) != null && kind != RpcOptions.LimitKind.None) {
            this.addInterceptor(this.createRequestLimitInterceptor(kind));
        }
        this.addInterceptor(new ContextToHeadersInterceptor());
    }

    private ClientRequestLimitInterceptor createRequestLimitInterceptor(RpcOptions.LimitKind kind) {
        AbstractLimit limit;
        LimitMetricRegistry metricRegistry = new LimitMetricRegistry();
        int minInitialLimit = 20;
        switch (kind) {
            case Vegas: {
                limit = VegasLimit.newBuilder().initialLimit(Math.max(minInitialLimit, this.opts.getInitialLimit())).maxConcurrency(this.opts.getMaxLimit()).smoothing(this.opts.getSmoothing()).logOnLimitChange(this.opts.isLogOnLimitChange()).metricRegistry(metricRegistry).build();
                break;
            }
            case Gradient: {
                limit = Gradient2Limit.newBuilder().initialLimit(Math.max(minInitialLimit, this.opts.getInitialLimit())).maxConcurrency(this.opts.getMaxLimit()).longWindow(this.opts.getLongRttWindow()).smoothing(this.opts.getSmoothing()).queueSize(Math.max(4, Cpus.cpus() << 1)).logOnLimitChange(this.opts.isLogOnLimitChange()).metricRegistry(metricRegistry).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported limit kind: " + kind);
            }
        }
        RequestLimiterBuilder limiterBuilder = (RequestLimiterBuilder)((RequestLimiterBuilder)((RequestLimiterBuilder)RequestLimiterBuilder.newBuilder().named(LIMITER_NAME)).metricRegistry(metricRegistry)).blockOnLimit(this.opts.isBlockOnLimit(), this.opts.getDefaultRpcTimeout()).limit((Limit)limit);
        Map<String, Double> methodsLimitPercent = this.marshallerRegistry.getAllMethodsLimitPercent();
        if (methodsLimitPercent.isEmpty()) {
            return new ClientRequestLimitInterceptor(limiterBuilder.build());
        }
        double sum = methodsLimitPercent.values().stream().reduce(0.0, Double::sum);
        Ensures.ensure((Math.abs(sum - 1.0) < 0.1 ? 1 : 0) != 0, (Object)"the total percent sum of partitions must be near 100%");
        methodsLimitPercent.forEach((arg_0, arg_1) -> ((RequestLimiterBuilder)limiterBuilder).partition(arg_0, arg_1));
        return new ClientRequestLimitInterceptor(limiterBuilder.partitionByMethod().build(), methodsLimitPercent::containsKey);
    }

    private void attachErrMsg(Throwable err, String callType, String method, String target, long startCall, long duration, Context ctx) {
        StringBuilder buf = StringBuilderHelper.get().append("Grpc ").append(callType).append(" got an error,").append(" method=").append(method).append(", target=").append(target).append(", startCall=").append(startCall);
        if (duration > 0L) {
            buf.append(", duration=").append(duration).append(" millis");
        }
        buf.append(", ctx=").append(ctx);
        err.addSuppressed((Throwable)new OnlyErrorMessage(buf.toString()));
    }

    private long calcTimeout(long timeoutMs) {
        return timeoutMs > 0L ? timeoutMs : (long)this.opts.getDefaultRpcTimeout();
    }

    private Executor getObserverExecutor(Observer<?> observer) {
        return observer.executor() != null ? observer.executor() : this.asyncPool;
    }

    private void closeAllChannels() {
        this.managedChannelPool.values().forEach(ch -> {
            boolean ret = ManagedChannelHelper.shutdownAndAwaitTermination(ch);
            LOG.info("Shutdown managed channel: {}, {}.", (Object)ch, (Object)(ret ? "success" : "failed"));
        });
        this.managedChannelPool.clear();
    }

    private void closeChannel(Endpoint endpoint) {
        ManagedChannel ch = this.managedChannelPool.remove(endpoint);
        LOG.info("Close connection: {}, {}.", (Object)endpoint, (Object)ch);
        if (ch != null) {
            ManagedChannelHelper.shutdownAndAwaitTermination(ch);
        }
    }

    private boolean checkChannel(Endpoint endpoint, boolean createIfAbsent) {
        ManagedChannel ch = this.getChannel(endpoint, createIfAbsent);
        if (ch == null) {
            return false;
        }
        return this.checkConnectivity(endpoint, ch);
    }

    private boolean checkConnectivity(Endpoint endpoint, ManagedChannel ch) {
        ConnectivityState st = ch.getState(false);
        if (st != ConnectivityState.TRANSIENT_FAILURE && st != ConnectivityState.SHUTDOWN) {
            return true;
        }
        int c = this.incConnFailuresCount(endpoint);
        if (c < CONN_RESET_THRESHOLD) {
            if (c == CONN_RESET_THRESHOLD - 1) {
                ch.resetConnectBackoff();
            }
            return true;
        }
        this.clearConnFailuresCount(endpoint);
        IdChannel removedCh = this.managedChannelPool.remove(endpoint);
        if (removedCh == null) {
            return false;
        }
        LOG.warn("Channel {} in [INACTIVE] state {} times, it has been removed from the pool.", (Object)GrpcClient.target((Channel)removedCh, endpoint), (Object)c);
        if (removedCh != ch) {
            ManagedChannelHelper.shutdownAndAwaitTermination(removedCh, 100L);
        }
        ManagedChannelHelper.shutdownAndAwaitTermination(ch, 100L);
        return false;
    }

    private int incConnFailuresCount(Endpoint endpoint) {
        return this.transientFailures.computeIfAbsent(endpoint, ep -> new AtomicInteger()).incrementAndGet();
    }

    private void clearConnFailuresCount(Endpoint endpoint) {
        this.transientFailures.remove(endpoint);
    }

    private MethodDescriptor<Message, Message> getCallMethod(Object request, MethodDescriptor.MethodType methodType) {
        Ensures.ensure((boolean)(request instanceof Message), (Object)"gRPC impl only support protobuf");
        Class<?> reqCls = ((Message)request).getClass();
        Message defaultReqIns = this.marshallerRegistry.getDefaultRequestInstance(reqCls);
        Message defaultRespIns = this.marshallerRegistry.getDefaultResponseInstance(reqCls);
        Ensures.ensureNonNull((Object)defaultReqIns, (String)("null default request instance: " + reqCls.getName()));
        Ensures.ensureNonNull((Object)defaultRespIns, (String)("null default response instance: " + reqCls.getName()));
        return MethodDescriptor.newBuilder().setType(methodType).setFullMethodName(this.marshallerRegistry.getMethodName(reqCls, methodType)).setRequestMarshaller(ProtoUtils.marshaller((Message)defaultReqIns)).setResponseMarshaller(ProtoUtils.marshaller((Message)defaultRespIns)).build();
    }

    private Channel getCheckedChannel(Endpoint endpoint, Consumer<Throwable> onFailed) {
        ManagedChannel ch = this.getChannel(endpoint, true);
        if (this.checkConnectivity(endpoint, ch)) {
            return ch;
        }
        onFailed.accept((Throwable)new ConnectFailException("Connect failed to " + endpoint));
        return null;
    }

    private ManagedChannel getChannel(Endpoint endpoint, boolean createIfAbsent) {
        if (createIfAbsent) {
            return this.managedChannelPool.computeIfAbsent(endpoint, this::newChannel);
        }
        return this.managedChannelPool.get(endpoint);
    }

    private IdChannel newChannel(Endpoint endpoint) {
        ManagedChannel innerChannel = ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)endpoint.getAddr(), (int)endpoint.getPort()).usePlaintext().executor(this.asyncPool)).intercept(this.interceptors)).maxInboundMessageSize(this.opts.getMaxInboundMessageSize()).flowControlWindow(this.opts.getFlowControlWindow()).idleTimeout(this.opts.getIdleTimeoutSeconds(), TimeUnit.SECONDS)).keepAliveTime(this.opts.getKeepAliveTimeSeconds(), TimeUnit.SECONDS).keepAliveTimeout(this.opts.getKeepAliveTimeoutSeconds(), TimeUnit.SECONDS).keepAliveWithoutCalls(this.opts.isKeepAliveWithoutCalls()).withOption(ChannelOption.SO_REUSEADDR, (Object)true).withOption(ChannelOption.TCP_NODELAY, (Object)true).build();
        IdChannel idChannel = new IdChannel(innerChannel);
        if (LOG.isInfoEnabled()) {
            LOG.info("Creating new channel to: {}.", (Object)GrpcClient.target((Channel)idChannel, endpoint));
        }
        this.notifyWhenStateChanged(ConnectivityState.IDLE, endpoint, idChannel);
        return idChannel;
    }

    private void notifyWhenStateChanged(ConnectivityState state, Endpoint endpoint, IdChannel ch) {
        ch.notifyWhenStateChanged(state, () -> this.onStateChanged(endpoint, ch));
    }

    private void onStateChanged(Endpoint endpoint, IdChannel ch) {
        ConnectivityState state = ch.getState(false);
        if (LOG.isInfoEnabled()) {
            LOG.info("The channel {} is in state: {}.", (Object)GrpcClient.target((Channel)ch, endpoint), (Object)state);
        }
        switch (state) {
            case READY: {
                this.notifyReady(endpoint);
                this.notifyWhenStateChanged(ConnectivityState.READY, endpoint, ch);
                break;
            }
            case TRANSIENT_FAILURE: {
                this.notifyFailure(endpoint);
                this.notifyWhenStateChanged(ConnectivityState.TRANSIENT_FAILURE, endpoint, ch);
                break;
            }
            case SHUTDOWN: {
                this.notifyShutdown(endpoint);
                break;
            }
            case CONNECTING: {
                this.notifyWhenStateChanged(ConnectivityState.CONNECTING, endpoint, ch);
                break;
            }
            case IDLE: {
                this.notifyWhenStateChanged(ConnectivityState.IDLE, endpoint, ch);
            }
        }
    }

    private void notifyReady(Endpoint endpoint) {
        this.connectionObservers.forEach(o -> o.onReady(endpoint));
    }

    private void notifyFailure(Endpoint endpoint) {
        this.connectionObservers.forEach(o -> o.onFailure(endpoint));
    }

    private void notifyShutdown(Endpoint endpoint) {
        this.connectionObservers.forEach(o -> o.onShutdown(endpoint));
    }

    public void display(Display.Printer out) {
        out.println((Object)"--- GrpcClient ---").print((Object)"started=").println((Object)this.started).print((Object)"opts=").println((Object)this.opts).print((Object)"connectionObservers=").println(this.connectionObservers).print((Object)"asyncPool=").println((Object)this.asyncPool).print((Object)"interceptors=").println(this.interceptors).print((Object)"managedChannelPool=").println(this.managedChannelPool).print((Object)"transientFailures=").println(this.transientFailures);
    }

    private static String target(Channel ch, Endpoint ep) {
        return GrpcClient.target(ch, ep == null ? null : ep.toString());
    }

    private static String target(Channel ch, String address) {
        return StringBuilderHelper.get().append('[').append(GrpcClient.channelId(ch)).append('/').append(address).append(']').toString();
    }

    private static long channelId(Channel ch) {
        if (ch instanceof IdChannel) {
            return ((IdChannel)ch).getChannelId();
        }
        return -1L;
    }

    private static void checkArgs(Endpoint endpoint, Object request, Context ctx, Observer<?> observer) {
        Ensures.ensureNonNull((Object)endpoint, (String)"null `endpoint`");
        Ensures.ensureNonNull((Object)request, (String)"null `request`");
        Ensures.ensureNonNull((Object)ctx, (String)"null `ctx`");
        Ensures.ensureNonNull(observer, (String)"null `observer`");
    }

    private static ExecutorService newSharedPool() {
        String name = "rpc_shared_pool";
        int coreWorks = SystemPropertyUtil.getInt((String)"greptimedb.grpc.pool.core_workers", (int)Cpus.cpus());
        int maximumWorks = SystemPropertyUtil.getInt((String)"greptimedb.grpc.pool.maximum_works", (int)(Cpus.cpus() << 2));
        return ThreadPoolUtil.newBuilder().poolName(name).enableMetric(Boolean.valueOf(true)).coreThreads(Integer.valueOf(coreWorks)).maximumThreads(Integer.valueOf(maximumWorks)).keepAliveSeconds(Long.valueOf(60L)).workQueue(new ArrayBlockingQueue(512)).threadFactory((ThreadFactory)new NamedThreadFactory(name, true)).rejectedHandler((RejectedExecutionHandler)new AsyncPoolRejectedHandler(name)).build();
    }

    private static class AsyncPoolRejectedHandler
    implements RejectedExecutionHandler {
        private final String name;

        AsyncPoolRejectedHandler(String name) {
            this.name = name;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            LOG.error("Thread poll {} is busy, the caller thread {} will run this task {}.", new Object[]{this.name, Thread.currentThread(), r});
            if (!executor.isShutdown()) {
                r.run();
            }
        }
    }
}

