/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ClassScanner {

    private static final Logger log = LoggerFactory.getLogger(ClassScanner.class);
    private static final Character STAR_CHAR = Character.valueOf('*');
    private static final String STAR_STR = "*";
    private static final Pattern ANONYMOUS_INNER_CLASS_PATTERN = Pattern.compile("^[\\s\\S]*\\${1}\\d+\\.class$");

    public static List<Class<?>> scanPackages(String ... scanBasePackages) {
        LinkedList classList = new LinkedList();
        if (scanBasePackages.length == 0) {
            return classList;
        }
        for (String pkg : scanBasePackages) {
            if (pkg == null || pkg.length() == 0) continue;
            classList.addAll(ClassScanner.scanOnePackage(pkg));
        }
        return classList;
    }

    public static List<Class<?>> scanPackages(List<String> scanBasePackages) {
        LinkedList classList = new LinkedList();
        if (scanBasePackages.size() == 0) {
            return classList;
        }
        for (String pkg : scanBasePackages) {
            if (pkg == null || pkg.length() == 0) continue;
            classList.addAll(ClassScanner.scanOnePackage(pkg));
        }
        return classList;
    }

    public static List<Class<?>> scanByAnnotation(Class<? extends Annotation> annotation, String ... scanBasePackages) {
        List<Class<?>> classList = ClassScanner.scanPackages(scanBasePackages);
        ArrayList result = new ArrayList();
        for (Class<?> clz : classList) {
            Annotation clzAnnotation = clz.getAnnotation(annotation);
            if (clzAnnotation == null) continue;
            result.add(clz);
        }
        return result;
    }

    public static List<Class<?>> scanByName(String nameSimpleReg, String ... scanBasePackages) {
        List<Class<?>> classList = ClassScanner.scanPackages(scanBasePackages);
        ArrayList result = new ArrayList();
        for (Class<?> clz : classList) {
            if (!ClassScanner.nameMatch(nameSimpleReg, clz.getName())) continue;
            result.add(clz);
        }
        return result;
    }

    private static List<Class<?>> scanOnePackage(String pkg) {
        List<Class<?>> classList = new LinkedList();
        try {
            String pathName = ClassScanner.package2Path(pkg);
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(pathName);
            classList = ClassScanner.scanUrls(pkg, urls);
        }
        catch (IOException e) {
            log.error("Warning: Can not scan package\uff1a{}", (Object)pkg);
        }
        return classList;
    }

    private static List<Class<?>> scanUrls(String pkg, Enumeration<URL> urls) throws IOException {
        LinkedList classList = new LinkedList();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String protocol = url.getProtocol();
            if (ProtocolTypes.file.name().equals(protocol)) {
                String path = URLDecoder.decode(url.getFile(), "UTF-8");
                classList.addAll(ClassScanner.recursiveScan4Path(pkg, path));
                continue;
            }
            if (!ProtocolTypes.jar.name().equals(protocol)) continue;
            String jarPath = ClassScanner.getJarPathFormUrl(url);
            classList.addAll(ClassScanner.recursiveScan4Jar(pkg, jarPath));
        }
        return classList;
    }

    private static String getJarPathFormUrl(URL url) {
        String file = url.getFile();
        return file.substring(0, file.lastIndexOf("!")).replaceFirst("file:", "");
    }

    private static List<Class<?>> recursiveScan4Path(String pkg, String filePath) {
        File[] dirs;
        LinkedList classList = new LinkedList();
        File file = new File(filePath);
        if (!file.exists() || !file.isDirectory()) {
            return classList;
        }
        File[] classes = file.listFiles(child -> ClassScanner.isClass(child.getName()));
        if (classes != null) {
            for (File child2 : classes) {
                String className = ClassScanner.classFile2SimpleClass(pkg + "." + child2.getName());
                try {
                    Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(className);
                    classList.add(clz);
                }
                catch (ClassNotFoundException | LinkageError e) {
                    log.error("Warning: Can not load class: {}", (Object)className);
                }
            }
        }
        if ((dirs = file.listFiles(File::isDirectory)) != null) {
            for (File child3 : dirs) {
                String childPackageName = pkg + "." + child3.getName();
                String childPath = filePath + "/" + child3.getName();
                classList.addAll(ClassScanner.recursiveScan4Path(childPackageName, childPath));
            }
        }
        return classList;
    }

    private static List<Class<?>> recursiveScan4Jar(String pkg, String jarPath) throws IOException {
        LinkedList classList = new LinkedList();
        try (JarInputStream jin = new JarInputStream(new FileInputStream(jarPath));){
            JarEntry entry = jin.getNextJarEntry();
            while (entry != null) {
                String name = entry.getName();
                entry = jin.getNextJarEntry();
                if (!name.contains(ClassScanner.package2Path(pkg)) || !ClassScanner.isClass(name) || ClassScanner.isAnonymousInnerClass(name)) continue;
                String className = ClassScanner.classFile2SimpleClass(ClassScanner.path2Package(name));
                try {
                    Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(className);
                    classList.add(clz);
                }
                catch (ClassNotFoundException | LinkageError e) {
                    log.error("Warning: Can not load class: {}", (Object)className);
                }
            }
        }
        return classList;
    }

    public static boolean nameMatch(String regex, String name) {
        if (regex == null || regex.length() == 0 || name == null || name.length() == 0) {
            return false;
        }
        int i;
        while ((i = regex.indexOf(124)) >= 0) {
            if (ClassScanner.doSingleNameMatch(regex.substring(0, i), name)) {
                return true;
            }
            regex = regex.substring(i + 1);
        }
        return ClassScanner.doSingleNameMatch(regex, name);
    }

    private static boolean doSingleNameMatch(String regex, String name) {
        if (regex == null || regex.length() == 0 || name == null || name.length() == 0) {
            return false;
        }
        if (STAR_CHAR.charValue() == regex.charAt(0)) {
            return name.endsWith(regex.substring(1));
        }
        if (regex.endsWith(STAR_STR)) {
            return name.startsWith(regex.substring(0, regex.length() - 1));
        }
        int starPos = regex.indexOf(42);
        if (-1 == starPos) {
            return regex.equals(name);
        }
        return name.startsWith(regex.substring(0, starPos)) && name.endsWith(regex.substring(starPos + 1));
    }

    private static String package2Path(String packageName) {
        return packageName.replace(".", "/");
    }

    private static String path2Package(String pathName) {
        return pathName.replaceAll("/", ".");
    }

    private static boolean isClass(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return fileName.endsWith(".class");
    }

    private static String classFile2SimpleClass(String classFileName) {
        return classFileName.replace(".class", "");
    }

    private static boolean isAnonymousInnerClass(String className) {
        return ANONYMOUS_INNER_CLASS_PATTERN.matcher(className).matches();
    }

    public static enum ProtocolTypes {
        http,
        https,
        file,
        jar;

    }
}

