/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc;

import io.greptime.common.Copiable;
import java.util.concurrent.TimeUnit;

public class RpcOptions
implements Copiable<RpcOptions> {
    private boolean useRpcSharedPool = false;
    private int defaultRpcTimeout = 10000;
    private int maxInboundMessageSize = 0x10000000;
    private int flowControlWindow = 0x10000000;
    private long idleTimeoutSeconds = TimeUnit.MINUTES.toSeconds(5L);
    private long keepAliveTimeSeconds = Long.MAX_VALUE;
    private long keepAliveTimeoutSeconds = 3L;
    private boolean keepAliveWithoutCalls = false;
    private LimitKind limitKind = LimitKind.None;
    private int initialLimit = 64;
    private int maxLimit = 1024;
    private int longRttWindow = 100;
    private double smoothing = 0.2;
    private boolean blockOnLimit = false;
    private boolean logOnLimitChange = true;
    private boolean enableMetricInterceptor = false;

    public boolean isUseRpcSharedPool() {
        return this.useRpcSharedPool;
    }

    public void setUseRpcSharedPool(boolean useRpcSharedPool) {
        this.useRpcSharedPool = useRpcSharedPool;
    }

    public int getDefaultRpcTimeout() {
        return this.defaultRpcTimeout;
    }

    public void setDefaultRpcTimeout(int defaultRpcTimeout) {
        this.defaultRpcTimeout = defaultRpcTimeout;
    }

    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public int getFlowControlWindow() {
        return this.flowControlWindow;
    }

    public void setFlowControlWindow(int flowControlWindow) {
        this.flowControlWindow = flowControlWindow;
    }

    public long getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void setIdleTimeoutSeconds(long idleTimeoutSeconds) {
        this.idleTimeoutSeconds = idleTimeoutSeconds;
    }

    public long getKeepAliveTimeSeconds() {
        return this.keepAliveTimeSeconds;
    }

    public void setKeepAliveTimeSeconds(long keepAliveTimeSeconds) {
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
    }

    public long getKeepAliveTimeoutSeconds() {
        return this.keepAliveTimeoutSeconds;
    }

    public void setKeepAliveTimeoutSeconds(long keepAliveTimeoutSeconds) {
        this.keepAliveTimeoutSeconds = keepAliveTimeoutSeconds;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public void setKeepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    public LimitKind getLimitKind() {
        return this.limitKind;
    }

    public void setLimitKind(LimitKind limitKind) {
        this.limitKind = limitKind;
    }

    public int getInitialLimit() {
        return this.initialLimit;
    }

    public void setInitialLimit(int initialLimit) {
        this.initialLimit = initialLimit;
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public void setMaxLimit(int maxLimit) {
        this.maxLimit = maxLimit;
    }

    public int getLongRttWindow() {
        return this.longRttWindow;
    }

    public void setLongRttWindow(int longRttWindow) {
        this.longRttWindow = longRttWindow;
    }

    public double getSmoothing() {
        return this.smoothing;
    }

    public void setSmoothing(double smoothing) {
        this.smoothing = smoothing;
    }

    public boolean isBlockOnLimit() {
        return this.blockOnLimit;
    }

    public void setBlockOnLimit(boolean blockOnLimit) {
        this.blockOnLimit = blockOnLimit;
    }

    public boolean isLogOnLimitChange() {
        return this.logOnLimitChange;
    }

    public void setLogOnLimitChange(boolean logOnLimitChange) {
        this.logOnLimitChange = logOnLimitChange;
    }

    public boolean isEnableMetricInterceptor() {
        return this.enableMetricInterceptor;
    }

    public void setEnableMetricInterceptor(boolean enableMetricInterceptor) {
        this.enableMetricInterceptor = enableMetricInterceptor;
    }

    public RpcOptions copy() {
        RpcOptions opts = new RpcOptions();
        opts.useRpcSharedPool = this.useRpcSharedPool;
        opts.defaultRpcTimeout = this.defaultRpcTimeout;
        opts.maxInboundMessageSize = this.maxInboundMessageSize;
        opts.flowControlWindow = this.flowControlWindow;
        opts.idleTimeoutSeconds = this.idleTimeoutSeconds;
        opts.keepAliveTimeSeconds = this.keepAliveTimeSeconds;
        opts.keepAliveTimeoutSeconds = this.keepAliveTimeoutSeconds;
        opts.keepAliveWithoutCalls = this.keepAliveWithoutCalls;
        opts.limitKind = this.limitKind;
        opts.initialLimit = this.initialLimit;
        opts.maxLimit = this.maxLimit;
        opts.longRttWindow = this.longRttWindow;
        opts.smoothing = this.smoothing;
        opts.blockOnLimit = this.blockOnLimit;
        opts.logOnLimitChange = this.logOnLimitChange;
        opts.enableMetricInterceptor = this.enableMetricInterceptor;
        return opts;
    }

    public String toString() {
        return "RpcOptions{useRpcSharedPool=" + this.useRpcSharedPool + ", defaultRpcTimeout=" + this.defaultRpcTimeout + ", maxInboundMessageSize=" + this.maxInboundMessageSize + ", flowControlWindow=" + this.flowControlWindow + ", idleTimeoutSeconds=" + this.idleTimeoutSeconds + ", keepAliveTimeSeconds=" + this.keepAliveTimeSeconds + ", keepAliveTimeoutSeconds=" + this.keepAliveTimeoutSeconds + ", keepAliveWithoutCalls=" + this.keepAliveWithoutCalls + ", limitKind=" + (Object)((Object)this.limitKind) + ", initialLimit=" + this.initialLimit + ", maxLimit=" + this.maxLimit + ", longRttWindow=" + this.longRttWindow + ", smoothing=" + this.smoothing + ", blockOnLimit=" + this.blockOnLimit + ", logOnLimitChange=" + this.logOnLimitChange + ", enableMetricInterceptor=" + this.enableMetricInterceptor + '}';
    }

    public static RpcOptions newDefault() {
        return new RpcOptions();
    }

    public static enum LimitKind {
        Vegas,
        Gradient,
        None;

    }
}

