/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.grpc;

import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import io.grpc.internal.ReadableBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.arrow.memory.ArrowBuf;

public class GetReadableBuffer {
    private static final Field READABLE_BUFFER;
    private static final Class<?> BUFFER_INPUT_STREAM;

    public static ReadableBuffer getReadableBuffer(InputStream is) {
        if (BUFFER_INPUT_STREAM == null || !is.getClass().equals(BUFFER_INPUT_STREAM)) {
            return null;
        }
        try {
            return (ReadableBuffer)READABLE_BUFFER.get(is);
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public static void readIntoBuffer(InputStream stream, ArrowBuf buf, int size, boolean fastPath) throws IOException {
        ReadableBuffer readableBuffer;
        ReadableBuffer readableBuffer2 = readableBuffer = fastPath ? GetReadableBuffer.getReadableBuffer(stream) : null;
        if (readableBuffer != null) {
            readableBuffer.readBytes(buf.nioBuffer(0L, size));
        } else {
            byte[] heapBytes = new byte[size];
            ByteStreams.readFully((InputStream)stream, (byte[])heapBytes);
            buf.writeBytes(heapBytes);
        }
        buf.writerIndex((long)size);
    }

    static {
        Field tmpField = null;
        Class<?> tmpClazz = null;
        try {
            Class<?> clazz = Class.forName("io.grpc.internal.ReadableBuffers$BufferInputStream");
            Field f = clazz.getDeclaredField("buffer");
            f.setAccessible(true);
            tmpField = f;
            tmpClazz = clazz;
        }
        catch (Exception e) {
            new RuntimeException("Failed to initialize GetReadableBuffer, falling back to slow path", e).printStackTrace();
        }
        READABLE_BUFFER = tmpField;
        BUFFER_INPUT_STREAM = tmpClazz;
    }
}

