/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth2;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.grpc.StatusUtils;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.flight.impl.FlightServiceGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHandshakeWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ClientHandshakeWrapper.class);

    public static void doClientHandshake(FlightServiceGrpc.FlightServiceStub stub) {
        HandshakeObserver observer = new HandshakeObserver();
        try {
            observer.requestObserver = stub.handshake(observer);
            observer.requestObserver.onNext((Object)Flight.HandshakeRequest.newBuilder().build());
            observer.requestObserver.onCompleted();
            try {
                if (!((Boolean)observer.completed.get()).booleanValue()) {
                    throw CallStatus.UNAUTHENTICATED.toRuntimeException();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw ex;
            }
            catch (ExecutionException ex) {
                FlightRuntimeException wrappedException = StatusUtils.fromThrowable(ex.getCause());
                logger.error("Failed on completing future", (Throwable)wrappedException);
                throw wrappedException;
            }
        }
        catch (StatusRuntimeException sre) {
            logger.error("Failed with SREe", (Throwable)sre);
            throw StatusUtils.fromGrpcRuntimeException(sre);
        }
        catch (Throwable ex) {
            logger.error("Failed with unknown", ex);
            if (ex instanceof FlightRuntimeException) {
                throw (FlightRuntimeException)ex;
            }
            throw StatusUtils.fromThrowable(ex);
        }
    }

    private static class HandshakeObserver
    implements StreamObserver<Flight.HandshakeResponse> {
        private volatile StreamObserver<Flight.HandshakeRequest> requestObserver;
        private final CompletableFuture<Boolean> completed = new CompletableFuture();

        public void onNext(Flight.HandshakeResponse value) {
        }

        public void onError(Throwable t) {
            this.completed.completeExceptionally(t);
        }

        public void onCompleted() {
            this.completed.complete(true);
        }
    }
}

