/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.validate.MetadataV4UnionChecker;

public class SchemaResult {
    private final Schema schema;
    private final IpcOption option;

    public SchemaResult(Schema schema) {
        this(schema, IpcOption.DEFAULT);
    }

    public SchemaResult(Schema schema, IpcOption option) {
        MetadataV4UnionChecker.checkForUnion(schema.getFields().iterator(), (MetadataVersion)option.metadataVersion);
        this.schema = schema;
        this.option = option;
    }

    public Schema getSchema() {
        return this.schema;
    }

    Flight.SchemaResult toProtocol() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(baos)), (Schema)this.schema, (IpcOption)this.option);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Flight.SchemaResult.newBuilder().setSchema(ByteString.copyFrom((byte[])baos.toByteArray())).build();
    }

    static SchemaResult fromProtocol(Flight.SchemaResult pbSchemaResult) {
        try {
            ByteBuffer schemaBuf = pbSchemaResult.getSchema().asReadOnlyByteBuffer();
            Schema schema = pbSchemaResult.getSchema().size() > 0 ? MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel((InputStream)new ByteBufferBackedInputStream(schemaBuf)))) : new Schema((Iterable)ImmutableList.of());
            return new SchemaResult(schema);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

