/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.EventLoopGroup;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.arrow.flight.FlightBindingService;
import org.apache.arrow.flight.FlightConstants;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServerMiddleware;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.ServerHeaderMiddleware;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.flight.auth.ServerAuthInterceptor;
import org.apache.arrow.flight.auth2.CallHeaderAuthenticator;
import org.apache.arrow.flight.auth2.ServerCallHeaderAuthMiddleware;
import org.apache.arrow.flight.grpc.ServerInterceptorAdapter;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightServer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(FlightServer.class);
    private final Location location;
    private final Server server;
    @VisibleForTesting
    final ExecutorService grpcExecutor;
    static final int MAX_GRPC_MESSAGE_SIZE = Integer.MAX_VALUE;

    private FlightServer(Location location, Server server, ExecutorService grpcExecutor) {
        this.location = location;
        this.server = server;
        this.grpcExecutor = grpcExecutor;
    }

    public FlightServer start() throws IOException {
        this.server.start();
        return this;
    }

    public int getPort() {
        return this.server.getPort();
    }

    public Location getLocation() {
        if (this.location.getUri().getPort() == 0) {
            URI uri = this.location.getUri();
            try {
                return new Location(new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), this.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return this.location;
    }

    public void awaitTermination() throws InterruptedException {
        this.server.awaitTermination();
    }

    public void shutdown() {
        this.server.shutdown();
        if (this.grpcExecutor != null) {
            this.grpcExecutor.shutdown();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.server.awaitTermination(timeout, unit);
    }

    @Override
    public void close() throws InterruptedException {
        this.shutdown();
        boolean terminated = this.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        if (terminated) {
            logger.debug("Server was terminated within 3s");
            return;
        }
        this.server.shutdownNow();
        int count = 0;
        while (!this.server.isTerminated() & count < 30) {
            ++count;
            logger.debug("Waiting for termination");
            Thread.sleep(100L);
        }
        if (!this.server.isTerminated()) {
            logger.warn("Couldn't shutdown server, resources likely will be leaked.");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BufferAllocator allocator, Location location, FlightProducer producer) {
        return new Builder(allocator, location, producer);
    }

    public static final class Builder {
        private BufferAllocator allocator;
        private Location location;
        private FlightProducer producer;
        private final Map<String, Object> builderOptions;
        private ServerAuthHandler authHandler = ServerAuthHandler.NO_OP;
        private CallHeaderAuthenticator headerAuthenticator = CallHeaderAuthenticator.NO_OP;
        private ExecutorService executor = null;
        private int maxInboundMessageSize = Integer.MAX_VALUE;
        private InputStream certChain;
        private InputStream key;
        private final List<ServerInterceptorAdapter.KeyFactory<?>> interceptors;
        private final Set<String> interceptorKeys;

        Builder() {
            this.builderOptions = new HashMap<String, Object>();
            this.interceptors = new ArrayList();
            this.interceptorKeys = new HashSet<String>();
        }

        Builder(BufferAllocator allocator, Location location, FlightProducer producer) {
            this();
            this.allocator = (BufferAllocator)Preconditions.checkNotNull((Object)allocator);
            this.location = (Location)Preconditions.checkNotNull((Object)location);
            this.producer = (FlightProducer)Preconditions.checkNotNull((Object)producer);
        }

        public FlightServer build() {
            ExecutorService grpcExecutor;
            ExecutorService exec;
            NettyServerBuilder builder;
            if (this.headerAuthenticator != CallHeaderAuthenticator.NO_OP) {
                this.middleware(FlightServerMiddleware.Key.of("Authorization"), new ServerCallHeaderAuthMiddleware.Factory(this.headerAuthenticator));
            }
            this.middleware(FlightConstants.HEADER_KEY, new ServerHeaderMiddleware.Factory());
            switch (this.location.getUri().getScheme()) {
                case "grpc+unix": {
                    builder = NettyServerBuilder.forAddress((SocketAddress)this.location.toSocketAddress());
                    try {
                        try {
                            builder.channelType(Class.forName("io.netty.channel.epoll.EpollServerDomainSocketChannel"));
                            EventLoopGroup elg2 = (EventLoopGroup)Class.forName("io.netty.channel.epoll.EpollEventLoopGroup").newInstance();
                            builder.bossEventLoopGroup(elg2).workerEventLoopGroup(elg2);
                        }
                        catch (ClassNotFoundException e) {
                            builder.channelType(Class.forName("io.netty.channel.kqueue.KQueueServerDomainSocketChannel"));
                            EventLoopGroup elg3 = (EventLoopGroup)Class.forName("io.netty.channel.kqueue.KQueueEventLoopGroup").newInstance();
                            builder.bossEventLoopGroup(elg3).workerEventLoopGroup(elg3);
                        }
                        break;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new UnsupportedOperationException("Could not find suitable Netty native transport implementation for domain socket address.");
                    }
                }
                case "grpc": 
                case "grpc+tcp": {
                    builder = NettyServerBuilder.forAddress((SocketAddress)this.location.toSocketAddress());
                    break;
                }
                case "grpc+tls": {
                    if (this.certChain == null) {
                        throw new IllegalArgumentException("Must provide a certificate and key to serve gRPC over TLS");
                    }
                    builder = NettyServerBuilder.forAddress((SocketAddress)this.location.toSocketAddress());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Scheme is not supported: " + this.location.getUri().getScheme());
                }
            }
            if (this.certChain != null) {
                builder.useTransportSecurity(this.certChain, this.key);
            }
            if (this.executor != null) {
                exec = this.executor;
                grpcExecutor = null;
            } else {
                grpcExecutor = exec = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("flight-server-default-executor-%d").build());
            }
            FlightBindingService flightService = new FlightBindingService(this.allocator, this.producer, this.authHandler, exec);
            ((NettyServerBuilder)builder.executor((Executor)exec)).maxInboundMessageSize(this.maxInboundMessageSize).addService(ServerInterceptors.intercept((BindableService)flightService, (ServerInterceptor[])new ServerInterceptor[]{new ServerAuthInterceptor(this.authHandler)}));
            this.builderOptions.computeIfPresent("grpc.builderConsumer", (key, builderConsumer) -> {
                Consumer consumer = (Consumer)builderConsumer;
                consumer.accept(builder);
                return null;
            });
            this.builderOptions.computeIfPresent("netty.channelType", (key, channelType) -> {
                builder.channelType((Class)channelType);
                return null;
            });
            this.builderOptions.computeIfPresent("netty.bossEventLoopGroup", (key, elg) -> {
                builder.bossEventLoopGroup((EventLoopGroup)elg);
                return null;
            });
            this.builderOptions.computeIfPresent("netty.workerEventLoopGroup", (key, elg) -> {
                builder.workerEventLoopGroup((EventLoopGroup)elg);
                return null;
            });
            builder.intercept((ServerInterceptor)new ServerInterceptorAdapter(this.interceptors));
            return new FlightServer(this.location, builder.build(), grpcExecutor);
        }

        public Builder maxInboundMessageSize(int maxMessageSize) {
            this.maxInboundMessageSize = maxMessageSize;
            return this;
        }

        public Builder useTls(File certChain, File key) throws IOException {
            this.certChain = new FileInputStream(certChain);
            this.key = new FileInputStream(key);
            return this;
        }

        public Builder useTls(InputStream certChain, InputStream key) {
            this.certChain = certChain;
            this.key = key;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder authHandler(ServerAuthHandler authHandler) {
            this.authHandler = authHandler;
            return this;
        }

        public Builder headerAuthenticator(CallHeaderAuthenticator headerAuthenticator) {
            this.headerAuthenticator = headerAuthenticator;
            return this;
        }

        public Builder transportHint(String key, Object option) {
            this.builderOptions.put(key, option);
            return this;
        }

        public <T extends FlightServerMiddleware> Builder middleware(FlightServerMiddleware.Key<T> key, FlightServerMiddleware.Factory<T> factory) {
            if (this.interceptorKeys.contains(key.key)) {
                throw new IllegalArgumentException("Key already exists: " + key.key);
            }
            this.interceptors.add(new ServerInterceptorAdapter.KeyFactory<T>(key, factory));
            this.interceptorKeys.add(key.key);
            return this;
        }

        public Builder allocator(BufferAllocator allocator) {
            this.allocator = (BufferAllocator)Preconditions.checkNotNull((Object)allocator);
            return this;
        }

        public Builder location(Location location) {
            this.location = (Location)Preconditions.checkNotNull((Object)location);
            return this;
        }

        public Builder producer(FlightProducer producer) {
            this.producer = (FlightProducer)Preconditions.checkNotNull((Object)producer);
            return this;
        }
    }
}

