/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.validate.MetadataV4UnionChecker;

public class FlightInfo {
    private final Schema schema;
    private final FlightDescriptor descriptor;
    private final List<FlightEndpoint> endpoints;
    private final long bytes;
    private final long records;
    private final IpcOption option;

    public FlightInfo(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints, long bytes, long records) {
        this(schema, descriptor, endpoints, bytes, records, IpcOption.DEFAULT);
    }

    public FlightInfo(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints, long bytes, long records, IpcOption option) {
        Objects.requireNonNull(schema);
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(endpoints);
        MetadataV4UnionChecker.checkForUnion(schema.getFields().iterator(), (MetadataVersion)option.metadataVersion);
        this.schema = schema;
        this.descriptor = descriptor;
        this.endpoints = endpoints;
        this.bytes = bytes;
        this.records = records;
        this.option = option;
    }

    FlightInfo(Flight.FlightInfo pbFlightInfo) throws URISyntaxException {
        try {
            ByteBuffer schemaBuf = pbFlightInfo.getSchema().asReadOnlyByteBuffer();
            this.schema = pbFlightInfo.getSchema().size() > 0 ? MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel((InputStream)new ByteBufferBackedInputStream(schemaBuf)))) : new Schema((Iterable)ImmutableList.of());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.descriptor = new FlightDescriptor(pbFlightInfo.getFlightDescriptor());
        this.endpoints = new ArrayList<FlightEndpoint>();
        for (Flight.FlightEndpoint endpoint : pbFlightInfo.getEndpointList()) {
            this.endpoints.add(new FlightEndpoint(endpoint));
        }
        this.bytes = pbFlightInfo.getTotalBytes();
        this.records = pbFlightInfo.getTotalRecords();
        this.option = IpcOption.DEFAULT;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getRecords() {
        return this.records;
    }

    public FlightDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List<FlightEndpoint> getEndpoints() {
        return this.endpoints;
    }

    Flight.FlightInfo toProtocol() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(baos)), (Schema)this.schema, (IpcOption)this.option);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Flight.FlightInfo.newBuilder().addAllEndpoint(this.endpoints.stream().map(t -> t.toProtocol()).collect(Collectors.toList())).setSchema(ByteString.copyFrom((byte[])baos.toByteArray())).setFlightDescriptor(this.descriptor.toProtocol()).setTotalBytes(this.bytes).setTotalRecords(this.records).build();
    }

    public ByteBuffer serialize() {
        return ByteBuffer.wrap(this.toProtocol().toByteArray());
    }

    public static FlightInfo deserialize(ByteBuffer serialized) throws IOException, URISyntaxException {
        return new FlightInfo(Flight.FlightInfo.parseFrom(serialized));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlightInfo that = (FlightInfo)o;
        return this.bytes == that.bytes && this.records == that.records && this.schema.equals((Object)that.schema) && this.descriptor.equals(that.descriptor) && this.endpoints.equals(that.endpoints);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.descriptor, this.endpoints, this.bytes, this.records);
    }

    public String toString() {
        return "FlightInfo{schema=" + this.schema + ", descriptor=" + this.descriptor + ", endpoints=" + this.endpoints + ", bytes=" + this.bytes + ", records=" + this.records + '}';
    }
}

